<?php
namespace app\common\validate;

use think\Validate;

class CompanyContent extends Validate
{
    protected $rule =   [
        'contacts'              => 'require',
        'contacts_mobile'       => 'require',
        'contacts_address'      => 'require',
        'contacts_area'         => 'require',
        'company_website'       => 'url',
        'company_introduction'  => 'length:2,200',
        'company_descript'      => 'require|length:2,2000',
    ];
    
    protected $message  =   [
        'contacts.require'              => '请输入联系人',
        'contacts_mobile.require'       => '请输入联系人手机号',
        'contacts_address.require'      => '请输入公司地址',
        'contacts_area.require'         => '请选择公司所在地',
        'company_website.url'           => '公司网址不正确',
        'company_introduction.length'   => '公司简介长度为2~200位',
        'company_descript.require'      => '请输入公司介绍',
        'company_descript.length'       => '公司介绍长度为2~2000位',
    ];
}