<?php
namespace app\common\validate;

use think\Validate;

class CompanyAttestation extends Validate
{
    protected $rule =   [
        'uscc'                     => 'require|unique:company_attestation',
        'business_license'         => 'require',
    ];
    
    protected $message  =   [
        'uscc.require'                     => '企业统一社会信用代码不能为空', 
        'uscc.unique'                      => '企业已存在', 
        'business_license.require'          => '企业简称长度为2~10位',
    ];
}