<?php
namespace app\common\validate;

use think\Validate;

class Company extends Validate
{
    protected $rule =   [
        'title'                     => 'require|length:2,30|unique:company',
        'stitle'                    => 'length:2,10',
        'nature'                    => 'require',
        'industry_id'               => 'require',
        'size_type'                 => 'require',
        'registered_capital'        => 'require|egt:10',
        'registered_capital_type'   => 'require',
        'corporate_welfare'         => 'array',
    ];
    
    protected $message  =   [
        'title.require'                     => '企业名称不能为空', 
        'title.length'                      => '企业名称长度为2~30位', 
        'title.unique'                      => '企业已存在', 
        'stitle.length'                     => '企业简称长度为2~10位',
        'nature.require'                    => '请选择企业性质',
        'industry_id.require'               => '请选择企业所属行业',
        'size_type.require'                 => '请选择企业规模',
        'registered_capital.require'        => '请输入注册资金',
        'registered_capital.egt'            => '注册资金最少为10万',
        'registered_capital_type.require'   => '请选择注册资金币种',
        'corporate_welfare.array'           => '企业福利格式不正确',
    ];
}