<?php
namespace app\common\tag;
use think\template\TagLib;
class XYCms extends TagLib{
    /**
     * 定义标签列表
     */
    protected $tags   =  [
        'web'               => ['attr'=>'name','close'=>0],
        'seo'               => ['attr'=>'name','close'=>0],
        'messageconfig'     => ['attr'=>'name','close'=>0],
        'scoreconfig'       => ['attr'=>'name','close'=>0],
        'invoiceconfig'     => ['attr'=>'name','close'=>0],
        'companyconfig'     => ['attr'=>'name','close'=>0],
        'resumeconfig'      => ['attr'=>'name','close'=>0],
        'smsconfig'         => ['attr'=>'name','close'=>0],
        'mapconfig'         => ['attr'=>'name','close'=>0],
        'isimgcode'         => ['attr'=>'name','close'=>0],
        'captcha'           => ['attr'=>'name','close'=>0],
        'captchatsec'       => ['attr'=>'name','close'=>0],
        'captchavaptcha'    => ['attr'=>'name','close'=>0],
        'xycms'             => ['attr'=>'name','close'=>0],
        'imsetting'         => ['attr'=>'name','close'=>0],
        'imtoken'           => ['attr'=>'name','close'=>0],
        'statusalias'       => ['attr'=>'name','close'=>0],
        'industry'          => ['close'=>0],
        'jobscate'          => ['close'=>0],
        'citylist'          => ['close'=>0],
        'arealist'          => ['close'=>0],
        'jobscatelist'      => ['attr'=>'name','close'=>1],
        'ads'               => ['attr'=>'name','close'=>1],
        'hasads'            => ['attr'=>'name','close'=>1],
        'articlelist'       => ['attr'=>'name','close'=>1],
        'articlepage'       => ['attr'=>'name','close'=>1],
        'articlecatelist'   => ['attr'=>'name','close'=>1],
        'links'             => ['attr'=>'name','close'=>1],
        'companylist'       => ['attr'=>'name','close'=>1],
        'companylistbyrand' => ['attr'=>'name','close'=>1],
        'companypage'       => ['attr'=>'name','close'=>1],
        'resumelist'        => ['attr'=>'name','close'=>1],
        'resumepage'        => ['attr'=>'name','close'=>1],
        'jobslist'          => ['attr'=>'name','close'=>1],
        'jobslistbyrand'    => ['attr'=>'name','close'=>1],
        'jobspage'          => ['attr'=>'name','close'=>1],
        'menu'              => ['attr'=>'name','close'=>1],
        'vip'               => ['attr'=>'name','close'=>1],
        'valueadded'        => ['attr'=>'name','close'=>1],
        'jobfair'           => ['attr'=>'name','close'=>1],
        'subsite'           => ['attr'=>'name','close'=>1],
    ];
    /**
     * 站点配置
     */
    public function tagWeb($tag)
    {
        return '{:config(\'web.'.$tag['name'].'\')}';
    }
    /**
     * 站点配置
     */
    public function tagSeo($tag)
    {
        return '{:config(\'xy_seo.'.$tag['name'].'\')}';
    }
    /**
     * 状态别名
     */
    public function tagStatusalias($tag)
    {
        $parse = '{php}$statusalias_'.removePHPStr($tag['name']).'=app\common\model\StatusAlias::getCate(\''.$tag['name'].'\');{/php}';
        $serialize=empty($tag['serialize'])?'':$tag['serialize'];
        switch ($serialize) {
            case 'json':
                $parse .= '{:json_encode($statusalias_'.removePHPStr($tag['name']).',JSON_UNESCAPED_UNICODE)}';
                break;
        }
        return $parse;
    }
    /**
     * 消息配置
     */
    public function tagMessageconfig($tag)
    {
        return '{:config(\'xycms_message.'.$tag['name'].'\')}';
    }
    /**
     * 积分配置
     */
    public function tagScoreconfig($tag)
    {
        return '{:config(\'xy_score.'.$tag['name'].'\')}';
    }
    /**
     * 发票配置
     */
    public function tagInvoiceconfig($tag)
    {
        return '{:config(\'xy_invoice.'.$tag['name'].'\')}';
    }
    /**
     * 企业配置
     */
    public function tagCompanyconfig($tag)
    {
        return '{:config(\'xy_company.'.$tag['name'].'\')}';
    }
    /**
     * 个人配置
     */
    public function tagResumeconfig($tag)
    {
        return '{:config(\'xy_resume.'.$tag['name'].'\')}';
    }
    /**
     * 短信配置
     */
    public function tagSmsconfig($tag)
    {
        return '{:config(\'sms.'.$tag['name'].'\')}';
    }
    /**
     * 地图配置
     */
    public function tagMapconfig($tag)
    {
        return '{:config(\'xy_map.'.$tag['name'].'\')}';
    }
    /**
     * 判断是否需要验证码
     */
    public function tagIsimgcode($tag)
    {
        return '{:intval(think\\\facade\\\Cookie::get(\'is_imgcode\'),0)>=config(\'captcha.error_sum\')?1:0}';
    }
    /**
     * 验证码配置
     */
    public function tagCaptcha($tag)
    {
        return '{:config(\'captcha.'.$tag['name'].'\')}';
    }
    /**
     * 腾讯天御验证码配置
     */
    public function tagCaptchatsec($tag)
    {
        return '{:config(\'xy_tencent_tsec.'.$tag['name'].'\')}';
    }
    /**
     * 手势验证码配置
     */
    public function tagCaptchavaptcha($tag)
    {
        return '{:config(\'xy_vaptcha.'.$tag['name'].'\')}';
    }
    /**
     * 即时聊天配置
     */
    public function tagXycms($tag)
    {
        return '{:config(\'xy_xycms.'.$tag['name'].'\')}';
    }
    /**
     * 即时聊天配置
     */
    public function tagImsetting($tag)
    {
        return '{:config(\'xy_im_setting.'.$tag['name'].'\')}';
    }
    /**
     * 即时聊天鉴权数据配置
     */
    public function tagImtoken($tag)
    {
        $parse  = '{php}$time=time();
        $uid=session(\'User.id\');
        $ImTokenData=[
            \'time\'  =>  $time,
            \'uid\'   =>  $uid,
            \'token\' =>  md5(config(\'xy_xycms.key\').$time.$uid.config(\'xy_xycms.secret\').config(\'xy_xycms.key\'))
        ];{/php}{:json_encode($ImTokenData,JSON_UNESCAPED_UNICODE)}';
        return $parse;
    }
    /**
     * 企业行业
     */
    public function tagIndustry($tag)
    {
        $parse = '{php}$industry=app\common\model\CompanyIndustry::getCate();{/php}';
        $serialize=empty($tag['serialize'])?'':$tag['serialize'];
        switch ($serialize) {
            case 'json':
                $parse .= '{:json_encode($industry,JSON_UNESCAPED_UNICODE)}';
                break;
        }
        return $parse;
    }
    /**
     * 职位分类
     */
    public function tagJobscate($tag)
    {
        $parse = '{php}$jobs_cate=think\facade\Cache::get(\'jobs_cate\');{/php}';
        $serialize=empty($tag['serialize'])?'':$tag['serialize'];
        switch ($serialize) {
            case 'json':
                $parse .= '{:json_encode($jobs_cate,JSON_UNESCAPED_UNICODE)}';
                break;
        }
        return $parse;
    }
    /**
     * 地区列表
     */
    public function tagArealist($tag)
    {
        $parse = '{php}$arealist=think\facade\Cache::get(\'arealist\');{/php}';
        $serialize=empty($tag['serialize'])?'':$tag['serialize'];
        switch ($serialize) {
            case 'json':
                $parse .= '{:json_encode($arealist,JSON_UNESCAPED_UNICODE)}';
                break;
        }
        return $parse;
    }
    /**
     * 城市列表
     */
    public function tagCitylist($tag)
    {
        $parse = '{php}$citylist=think\facade\Cache::get(\'citylist\');{/php}';
        $serialize=empty($tag['serialize'])?'':$tag['serialize'];
        switch ($serialize) {
            case 'json':
                $parse .= '{:json_encode($citylist,JSON_UNESCAPED_UNICODE)}';
                break;
        }
        return $parse;
    }
    /**
     * 职位分类
     */
    public function tagJobscatelist($tag,$content)
    {
        $name = $tag['name'];
        $length = empty($tag['length'])?0:$tag['length'];
        $parse = '{php}$jobs_cate=think\facade\Cache::get(\'jobs_cate\');{/php}';
        $parse .= '{notempty name="jobs_cate"}';
        $parse .= '{volist name="jobs_cate" id="'.$name.'"';
        if ($length) {
            $parse .= ' length="'.$length.'"';
        }
        $parse .= '}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= '{else/}';
        $parse .= '<div class="empty-text py-5">暂无分类</div>';
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 广告位
     */
    public function tagAds($tag,$content)
    {
        $name = $tag['name'];
        $alias = $tag['alias'];
        $length = empty($tag['length'])?1:$tag['length'];
        $parse = '{php}$ads_'.$alias.'=app\common\controller\Ads::getSelect(\''.$alias.'\','.$length.');{/php}';
        $parse .= '{notempty name="$ads_'.$alias.'"}';
        $parse .= '{volist name="$ads_'.$alias.'" id="'.$name.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 判断广告位是否有广告
     */
    public function tagHasads($tag,$content)
    {
        $alias = $tag['alias'];
        $parse = '{php}$ads_'.$alias.'=app\common\controller\Ads::getSelect(\''.$alias.'\',1);{/php}';
        $parse .= '{notempty name="$ads_'.$alias.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 文章列表-所有
     */
    public function tagArticlelist($tag,$content)
    {
        $name = $tag['name'];
        $alias=$tag['alias'];
        $length = empty($tag['length'])?10:$tag['length'];
        $parse = '{php}$article_'.$alias.'=app\common\controller\Article::getSelect("'.$alias.'",'.$length.');{/php}';
        $parse .= '{notempty name="$article_'.$alias.'"}';
        $parse .= '{volist name="$article_'.$alias.'" id="'.$name.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= '{else/}';
        $parse .= '<div class="empty-text py-5">暂无数据</div>';
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 文章列表-翻页
     */
    public function tagArticlepage($tag,$content)
    {
        $name = $tag['name'];
        $alias=$tag['alias'];
        $length = empty($tag['length'])?10:$tag['length'];
        $parse = '{php}$article_=app\common\controller\Article::getPage("'.$alias.'",'.$length.');{/php}';
        $parse .= '{notempty name="$article_"}';
        $parse .= '{volist name="$article_" id="'.$name.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= '{else/}';
        $parse .= '<div class="empty-text py-5">暂无数据</div>';
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 文章分类
     */
    public function tagArticlecatelist($tag,$content)
    {
        $name = $tag['name'];
        $alias = $tag['alias'];
        $parse = '{php}$article_cate_'.$alias.'=app\common\controller\ArticleCate::getSelect(\''.$alias.'\',\'pc\');{/php}';
        $parse .= '{notempty name="$article_cate_'.$alias.'"}';
        $parse .= '{volist name="$article_cate_'.$alias.'" id="'.$name.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 友情链接
     */
    public function tagLinks($tag,$content)
    {
        $name = $tag['name'];
        $parse = '{php}$links=think\facade\Cache::get(\'links\');{/php}';
        $parse .= '{notempty name="$links"}';
        $parse .= '{volist name="$links" id="'.$name.'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagCompanylist($tag,$content)
    {
        $name       = $tag['name'];
        $length     = empty($tag['length'])?10:$tag['length'];
        $parse  = '{php}';
        $parse .= '$where=[';
        if (!empty($tag['is_famous']))
            $parse .= "'is_famous'=>".$tag['is_famous'].',';
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
            $parse .= "'length'=>".$length;
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Company::getSelect($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagCompanypage($tag,$content)
    {
        $name       = $tag['name'];
        $parse  = '{php}';
        $parse .= '$where=[';
        if (!empty($tag['is_famous']))
            $parse .= "'is_famous'=>".$tag['is_famous'];
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Company::getCompanyList($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagCompanylistbyrand($tag,$content)
    {
        $name       = $tag['name'];
        $length     = empty($tag['length'])?10:$tag['length'];
        $parse  = '{php}';
        $parse .= '$where=[';
            $parse .= "'prop'=>'rand',";
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
            $parse .= "'length'=>".$length;
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Company::getSelect($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagResumelist($tag,$content)
    {
        $name       = $tag['name'];
        $length     = empty($tag['length'])?10:$tag['length'];
        $parse  = '{php}';
        $parse .= '$where=[';
            foreach ($tag as $k => $v) {
                if (is_numeric($v)) {
                    $parse .= "'".$k."'=>".$v.",";
                }elseif(is_string($v)){
                    $parse .= "'".$k."'=>'".$v."',";
                }
            }
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
            $parse .= "'length'=>".$length;
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Resume::getSelect($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagResumepage($tag,$content)
    {
        $name       = $tag['name'];
        $parse  = '{php}';
        $parse .= '$where=[';
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Resume::getResumeList($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagJobslist($tag,$content)
    {
        $name       = $tag['name'];
        $length     = empty($tag['length'])?10:$tag['length'];
        $parse  = '{php}';
        $parse .= '$where=[';
            if (!empty($tag['new']))
                $parse .= "'new'=>1,";
            if (!empty($tag['is_recommend']))
                $parse .= "'is_recommend'=>1,";
            if (!empty($tag['is_hot']))
                $parse .= "'is_hot'=>1,";
            if (!empty($tag['is_high_salary']))
                $parse .= "'is_high_salary'=>1,";
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
            $parse .= "'resume_id'=>think\\facade\\Session::get('User.resume_id'),";
            $parse .= "'length'=>".$length;
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Jobs::getSelect($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagJobslistbyrand($tag,$content)
    {
        $name       = $tag['name'];
        $length     = empty($tag['length'])?10:$tag['length'];
        $parse  = '{php}';
        $parse .= '$where=[';
            $parse .= "'prop'=>'rand',";
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
            $parse .= "'resume_id'=>think\\facade\\Session::get('User.resume_id'),";
            $parse .= "'length'=>".$length;
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Jobs::getSelect($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagJobspage($tag,$content)
    {
        $name   = $tag['name'];
        $parse  = '{php}';
        $parse .= '$where=[';
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Jobs::getJobsList($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 导航栏
     */
    public function tagMenu($tag,$content)
    {
        $name = $tag['name'];
        $parse = '{php}$menu_'.removePHPStr($name).'=think\facade\Cache::get(\'menu.'.$name.'\');{/php}';
        $parse .= '{notempty name="$menu_'.removePHPStr($name).'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 会员套餐
     */
    public function tagVip($tag,$content)
    {
        $name   = $tag['name'];
        $parse  = '{php}';
        $parse .= '$where=[';
            $parse .= "['vip.is_company','=',think\\facade\\Session::get('User.role_type')],";
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Vip::getSelect($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    /**
     * 增值服务
     */
    public function tagValueadded($tag,$content)
    {
        $name   = $tag['name'];
        $parse  = '{php}';
        $parse .= '$where=[';
            $parse .= "'is_company'=>think\\facade\\Session::get('User.role_type'),";
            $parse .= "'uid'=>think\\facade\\Session::get('User.id'),";
            $parse .= "'company_id'=>think\\facade\\Session::get('User.company_id'),";
            $parse .= "'resume_id'=>think\\facade\\Session::get('User.resume_id'),";
        $parse .= '];';
        $parse .= '$'.$name.'=app\common\controller\Vip::getValueAdded($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagJobfair($tag,$content)
    {
        $name   = $tag['name'];
        $parse  = '{php}';
        $parse .= '$where=request()->get();';
        $parse .= '$'.$name.'=app\common\controller\JobFair::getList($where);';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
    public function tagSubsite($tag,$content)
    {
        $name   = $tag['name'];
        $parse  = '{php}';
        $parse .= '$'.$name.'=think\\facade\\Cache::get(\'SubWebsiteList\');';
        $parse .= '{/php}';
        $parse .= '{notempty name="$'.$name.'"}';
        $parse .= $content;
        $parse .= '{/notempty}';
        return $parse;
    }
}