<?php 
namespace app\common\service\queue;
use think\facade\Cache;
use think\facade\Db;
use helper\Time;
use app\bsadmin\model\Admin as AdminModel;
use app\common\model\User as UserModel;
use app\common\model\UserDisable as UserDisableModel;
use app\common\model\UserInfo as UserInfoModel;
use app\common\model\UserVip as UserVipModel;
use app\common\model\UserVipRule as UserVipRuleModel;
use app\common\model\UserScore as UserScoreModel;
use app\common\model\Vip as VipModel;
use app\common\model\VipRule as VipRuleModel;
use app\common\model\ImContacts as ImContactsModel;
class UpdateUser
{
    public function init_user_vip_handle()
    {
        $UserInfoModel=UserInfoModel::where(['init_vip'=>0])->find();
        if($UserInfoModel){
            $VipModel=VipModel::where(['default'=>1])->find();
            if(!$VipModel) return;
            $VipRuleModel=VipRuleModel::alias('rule')->where(['rule.vid'=>$VipModel->id,'rv.status'=>1,'rv.type'=>'input'])
                ->join('vip_rule_value rv','rv.id=rule.rid')
                ->field('rule.vid,rule.rid,rule.value,rv.alias')->select()->toArray();
            $UserVipModel=UserVipModel::where(['uid'=>$UserInfoModel->uid])->find();
            if (!$UserVipModel) {
                $UserVipModel=new UserVipModel;
                $UserVipModel->uid=$UserInfoModel->uid;
            }
            $UserVipModel->update_vip=1;
            $UserVipRuleList=[];
            $UserScoreModel=null;
            if ($VipRuleModel) {
                $expiry_time=time()+3600*24*365*10;
                $UserVipRuleModel=new UserVipRuleModel;
                foreach ($VipRuleModel as $k => $v) {
                    switch ($v['alias']) {
                        case 'time-limit':
                            break;
                        case 'bonus-points':
                            $UserInfoModel->score=Db::raw('score+'.$v['value']);
                            $UserScoreModel=new UserScoreModel;
                            $UserScoreModel->uid    =   $UserInfoModel->uid;
                            $UserScoreModel->tid    =   0;
                            $UserScoreModel->score  =   $v['value'];
                            $UserScoreModel->desc   =   '注册赠送'.$v['value'].'积分';
                            Cache::set('updateUser:'.$UserInfoModel->uid,true);
                            break;
                        default:
                            $v['uid']=$UserInfoModel->uid;
                            $v['level']=$VipModel->level;
                            $v['surplus_value']=$v['value'];
                            $UserVipRuleList[]=$v;
                            break;
                    }
                }
                if (!empty($UserVipRuleList))
                    array_walk($UserVipRuleList,function(&$v,$k)use($expiry_time){
                        $v['expiry_time']=$expiry_time;
                        krsort($v);
                    });
            }
            $UserInfoModel->init_vip=1;
            Db::startTrans();
            try {
                if (!empty($UserVipRuleList)) $UserVipRuleModel->saveAll($UserVipRuleList);
                $UserInfoModel->save();
                $UserVipModel->save();
                if ($UserScoreModel) $UserScoreModel->save();
                // 提交事务
                Db::commit();
            } catch (Exception $e) {
                //回滚事务
                Db::rollback();
            }
        }
    }
    public function updateUserInfoVip()
    {
        $UserVipModel=UserVipModel::where(['update_vip'=>1])->find();
        if ($UserVipModel) {
            $levelCompany=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->field('rule.level')->where(['vip.is_company'=>1])->find();
            if ($levelCompany){
                $UserVipModel->company_vip_level=$levelCompany->level;
            }else{
                $UserVipModel->company_vip_level=0;
            }

            $release_jobs_sum=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->field('rule.level,rule.surplus_value')->where(['vip.is_company'=>1,'value.alias'=>'release-jobs'])->find();
            if ($release_jobs_sum) {
                $UserVipModel->release_jobs_sum=$release_jobs_sum->surplus_value;
            }else{
                $UserVipModel->release_jobs_sum=0;
            }

            $today_down_resume=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->field('rule.level,rule.surplus_value')->where(['vip.is_company'=>1,'value.alias'=>'today-down-resume'])->find();
            if ($today_down_resume) {
                $UserVipModel->today_down_resume=$today_down_resume->surplus_value;
            }else{
                $UserVipModel->today_down_resume=0;
            }
            $UserVipModel->download_resume=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'download-resume'])->sum('rule.surplus_value');

            $ImContactsCount=ImContactsModel::where(['uid'=>$UserVipModel->uid])->count();
            $UserVipModel->im_max_people=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'im-max-people'])->sum('rule.surplus_value')-$ImContactsCount;

            $UserVipModel->top_day=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'top-day'])->sum('rule.surplus_value');

            $UserVipModel->refresh_sum=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'refresh-sum'])->sum('rule.surplus_value');

            $UserVipModel->urgent_day=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'urgent-day'])->sum('rule.surplus_value');

            $UserVipModel->invite_aninterview=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'invite-aninterview'])->sum('rule.surplus_value');

            $UserVipModel->job_fair=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->join('vip_rule_value value','value.id=rule.rid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->where(['vip.is_company'=>1,'value.alias'=>'job-fair'])->sum('rule.surplus_value');
           
            $levelPersonal=UserVipRuleModel::alias('rule')
            ->where(['rule.uid'=>$UserVipModel->uid,'rule.status'=>1])
            ->join(config('databse.prefix').'vip vip','vip.id=rule.vid')
            ->whereTime('rule.expiry_time','>',time())->order('rule.level desc')->field('rule.level')->where(['vip.is_company'=>0])->find();
            if ($levelPersonal){
                $UserVipModel->personal_vip_level=$levelPersonal->level;
            }else{
                $UserVipModel->personal_vip_level=0;
            }
            $UserVipModel->update_vip=0;
            $UserVipModel->save();
            Cache::set('updateUser:'.$UserVipModel->uid,true);
        }
    }
    public function update_user_handle()
    {
        $UserVipRule=UserVipRuleModel::where(['status'=>1])
        ->whereTime('expiry_time','<',time())
        ->field('id,uid')->limit(10)->select();
        $RuleData=[];
        $uidArr=[];
        foreach ($UserVipRule as $item) {
            $RuleData[]=$item->id;
            if(!in_array($item->uid,$uidArr)){
	            $uidArr[]=$item->uid;
            }
        }
        if ($UserVipRule) {
        	UserVipModel::whereIn('uid',$uidArr)->update(['update_vip'=>1]);
            UserVipRuleModel::whereIn('id',$RuleData)->update(['status'=>0]);
        }
        $this->updateUserInfoVip();
    }
    public function auto_disable_handle()
    {
        $UserDisableModel=UserDisableModel::where(['status'=>0,'auto_status'=>0])->whereNotNull('auto_time')->whereTime('auto_time','<',time())->find();
        if ($UserDisableModel) {
            $UserModel=UserModel::where(['id'=>$UserDisableModel->uid])->find();
            $UserModel->status=1;
            $UserModel->disable_msg='';
            $UserDisableModel->auto_status=1;
            $UserDisableModelLog=null;
            $admin_uid=AdminModel::where(['username'=>'adminauto33'])->value('id');
            if ($admin_uid) {
                $UserDisableModelLog=new UserDisableModel;
                $UserDisableModelLog->uid=$UserModel->id;
                $UserDisableModelLog->admin_uid=$admin_uid;
                $UserDisableModelLog->disable_msg='系统自动解封';
                $UserDisableModelLog->status=1;
            }
            // 启动事务
            Db::startTrans();
            try {
                $UserModel->save();
                $UserDisableModel->save();
                if($UserDisableModelLog)$UserDisableModelLog->save();
                // 提交事务
                Db::commit();
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
            }
        }
    }
    public function delete_user_vip_rule_handle()
    {
        if(UserVipRuleModel::where(['status'=>0])->whereTime('expiry_time','<',time()-3600*24*30)->count())
        UserVipRuleModel::where(['status'=>0])->whereTime('expiry_time','<',time()-3600*24*30)->delete();
    }
}