<?php 
namespace app\common\service\queue;
use think\facade\Db;
use app\common\model\Timing as TimingModel;
use helper\URL;
use helper\Time;
class Timing
{
    public function script_handle()
    {
        Db::startTrans();
        $Model=TimingModel::where(['type'=>'script','status'=>1])->whereTime('next_time','<',time())->lock(true)->find();
        $this->runTask($Model);
    }
    public function get_url_handle()
    {
        Db::startTrans();
        $Model=TimingModel::where(['type'=>'get_url','status'=>1])->whereTime('next_time','<',time())->lock(true)->find();
        $this->runTask($Model);
    }
    public function getNextTime($Model)
    {
        $now=time();
        switch ($Model->time_type) {
            //每天
            case 0:
                return strtotime("+1 days",strtotime(date('Y-m-d ').$Model->hour.':'.$Model->minute.':00'));
            //N天
            case 1:
                return $now+Time::daysToSecond($Model->day)+($Model->hour*3600)+($Model->minute*60);
            //每小时
            case 2:
                return strtotime(date('Y-m-d H:',$now).$Model->minute.':00');
            //N小时
            case 3:
                return $now+($Model->hour*3600)+($Model->minute*60);
            //N分钟
            case 4:
                return $now+($Model->minute*60);
            //每星期
            case 5:
                $week=['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
                return strtotime(date('Y-m-d ',strtotime("next ".$week[$Model->week],$now)).$Model->hour.':'.$Model->minute.':00');
            //每月
            case 6:
                return strtotime("+1 Month",strtotime(date('Y-m-').$Model->day.' '.$Model->hour.':'.$Model->minute.':00'));
        }
    }
    public function runTask($Model)
    {
        $ret=false;
        if ($Model) {
            $Model->status=1;
            $Model->last_time=time();
            $Model->next_time=$this->getNextTime($Model);
            $Model->save();
            Db::commit();
            switch ($Model->type) {
                case 'script':
                    $task=new $Model->content;
                    $task->run();
                    $ret=true;
                    break;
                case 'get_url':
                    URL::get($Model->content);
                    $ret=true;
                    break;
            }
        }else{
            Db::commit();
        }
        return $ret;
    }
}