<?php 
namespace app\common\service\queue;
use app\common\model\Orders as OrdersModel;
use app\common\model\NotifyAlipay as NotifyAlipayModel;
use app\common\model\NotifyApplepay as NotifyApplepayModel;
use app\common\model\NotifyToutiao as NotifyToutiaoModel;
use app\common\model\NotifyBaidu as NotifyBaiduModel;
use app\common\model\NotifyWxpay as NotifyWxpayModel;
use app\common\controller\Orders as OrdersController;
class Orders
{
    /**
     * [expire_time 订单过期处理]
     * @return [type] [description]
     */
    public function expire_time()
    {
    	$orderList=OrdersModel::where(['status'=>0])
            ->whereTime('expire_time', '<=', time()+60)->field('otrade')->select();
    	foreach ($orderList as $k => $v) {
            OrdersController::cancelOrder($v);
    	}
    }
    public function notify_alipay_handle()
    {
        $D=NotifyAlipayModel::where(['status'=>0])->field('id,out_trade_no,total_amount')->limit(5)->select()->toArray();
        foreach ($D as $k => $v) {
            $data=[
                'id'        =>  $v['id'],
                'otrade'    =>  $v['out_trade_no'],
                'oprice'    =>  $v['total_amount']
            ];
            OrdersController::ordersHandle($data);
        }
    }
    public function notify_applepay_handle()
    {
        $D=NotifyApplepayModel::where(['status'=>0])->field('id,otrade,oprice')->limit(5)->select()->toArray();
        foreach ($D as $k => $v) {
            $data=[
                'id'        =>  $v['id'],
                'otrade'    =>  $v['otrade'],
                'oprice'    =>  $v['oprice']
            ];
            OrdersController::ordersHandle($data);
        }
    }
    public function notify_wxpay_handle()
    {
        $D=NotifyWxpayModel::where(['status'=>0])->field('id,out_trade_no,total_fee')->limit(5)->select()->toArray();
        foreach ($D as $k => $v) {
            $data=[
                'id'        =>  $v['id'],
                'otrade'    =>  $v['out_trade_no'],
                'oprice'    =>  round($v['total_fee']/100,2)
            ];
            OrdersController::ordersHandle($data);
        }
    }
    public function notify_toutiao_handle()
    {
        $D=NotifyToutiaoModel::where(['status'=>0])->field('id,cp_orderno,total_amount')->limit(5)->select()->toArray();
        foreach ($D as $k => $v) {
            $data=[
                'id'        =>  $v['id'],
                'otrade'    =>  $v['cp_orderno'],
                'oprice'    =>  round($v['total_amount']/100,2)
            ];
            OrdersController::ordersHandle($data);
        }
    }
    public function notify_baidu_handle()
    {
        $D=NotifyBaiduModel::where(['status'=>0])->field('id,tp_order_id,total_money')->limit(5)->select()->toArray();
        foreach ($D as $k => $v) {
            $data=[
                'id'        =>  $v['id'],
                'otrade'    =>  $v['tp_order_id'],
                'oprice'    =>  round($v['total_money']/100,2)
            ];
            OrdersController::ordersHandle($data);
        }
    }
    public function scorepay_handle()
    {
        $orderList=OrdersModel::where(['status'=>1,'pay_type'=>4])
            ->where('score','>',0)->field('otrade,pay_type,oprice')->limit(5)->select()->toArray();
        foreach ($orderList as $k => $v) {
            OrdersController::ordersHandle($v);
        }
    }
    public function rights_handle()
    {
        $orderList=OrdersModel::where(['status'=>1,'pay_type'=>5])->field('otrade,pay_type,oprice')->limit(5)->select()->toArray();
        foreach ($orderList as $k => $v) {
            OrdersController::ordersHandle($v);
        }
    }
}