<?php 
namespace app\common\service\queue;
use think\facade\Db;
use app\common\model\Jobs as JobsModel;
use app\common\model\JobsRefreshAuto as JobsRefreshAutoModel;
use app\common\model\InviteAninterview as InviteAninterviewModel;
class Jobs
{
    public function auto_refresh_handle()
    {
        $jobsAuto=JobsRefreshAutoModel::where(['status'=>1])
            ->whereTime('next_time', '<=', time())->find();
        if ($jobsAuto) {
            $jobsAuto->sum=Db::raw('sum+1');
            $jobsAuto->next_time=time()+3600*4;
            $JobsModel=JobsModel::where(['id'=>$jobsAuto->jobs_id])->find();
            $JobsModel->refresh_time=time();
            Db::startTrans();
            try {
                $jobsAuto->save();
                $JobsModel->save();
                // 提交事务
                Db::commit();
            } catch (Exception $e) {
                //回滚事务
                Db::rollback();
            }
        }
    }
    public function auto_refresh_expire_handle()
    {
        $JobsRefreshAutoModel=JobsRefreshAutoModel::where(['status'=>1])
            ->whereTime('end_time', '<=', time())->field('id,status')->select()->toArray();
        foreach ($JobsRefreshAutoModel as $k => $v) {
            $JobsRefreshAutoModel[$k]['status']=0;
        }
        (new JobsRefreshAutoModel)->saveAll($JobsRefreshAutoModel);
    }
    public function jobs_urgent_expire_handle()
    {
        $JobsModel=JobsModel::where(['urgent'=>1])
            ->whereTime('urgent_time', '<=', time())->field('id,urgent')->select()->toArray();
        foreach ($JobsModel as $k => $v) {
            $JobsModel[$k]['urgent']=0;
        }
        (new JobsModel)->saveAll($JobsModel);
    }
    public function jobs_top_expire_handle()
    {
        $JobsModel=JobsModel::where(['top'=>1])
            ->whereTime('top_time', '<=', time())->field('id,top')->select()->toArray();
        foreach ($JobsModel as $k => $v) {
            $JobsModel[$k]['top']=0;
        }
        (new JobsModel)->saveAll($JobsModel);
    }
    public function jobs_recommend_expire_handle()
    {
        $JobsModel=JobsModel::where(['recommend'=>1])
            ->whereTime('recommend_time', '<=', time())->field('id,recommend')->select()->toArray();
        foreach ($JobsModel as $k => $v) {
            $JobsModel[$k]['recommend']=0;
        }
        (new JobsModel)->saveAll($JobsModel);
    }
    public function interview_handle()
    {
        $InviteAninterviewModel=InviteAninterviewModel::where(['status'=>1])
            ->whereTime('interview_date', '<=', time())->field('id,status')->select()->toArray();
        foreach ($InviteAninterviewModel as $k => $v) {
            $InviteAninterviewModel[$k]['status']=3;
        }
        (new InviteAninterviewModel)->saveAll($InviteAninterviewModel);
    }
}