<?php 
namespace app\common\service\queue;
use think\facade\Db;
use app\common\model\Coupon as CouponModel;
use app\common\model\CouponList as CouponListModel;
class Coupon
{
    public function auto_enable_handle()
    {
        $CouponListModelObj=CouponListModel::where(['status'=>0])->whereTime('start_time', '<=', time())->whereTime('end_time','>',time());
        if ($CouponListModelObj->count()) {
            $CouponListModelObj->limit(10)->order('receive_time desc,id asc')->update(['status'=>1]);
        }
        $CouponListModelObj=CouponListModel::where(['status'=>0])->whereNull('start_time')->whereTime('end_time','>',time());
        if ($CouponListModelObj->count()) {
            $CouponListModelObj->limit(10)->order('receive_time desc,id asc')->update(['status'=>1]);
        }
    }
    public function auto_disable_null_uid_handle()
    {
        $CouponListModelObj=CouponListModel::where(['status'=>0])->whereNull('uid')->whereTime('end_time','<',time())->order('id asc');
        if ($CouponListModelObj->count()) {
            $CouponListModel=$CouponListModelObj->field('alias_id')->limit(10)->select();
            $CouponData=[];
            foreach ($CouponListModel as $item) {
                if (isset($CouponData[$item->alias_id])&&$CouponData[$item->alias_id]) {
                    $CouponData[$item->alias_id]=$CouponData[$item->alias_id]+1;
                }else{
                    $CouponData[$item->alias_id]=1;
                }
            }
            foreach ($CouponData as $id => $sum) {
                $CouponModel=CouponModel::where(['id'=>$id])->find();
                $CouponModel->surplus_stock=Db::raw('surplus_stock-'.$sum);
                Db::startTrans();
                try {
                    CouponListModel::where(['status'=>0])->whereNull('uid')->whereTime('end_time','<',time())->order('id asc')->where(['alias_id'=>$id])->limit($sum)->update(['status'=>-1]);
                    $CouponModel->save();
                    // 提交事务
                    Db::commit();
                } catch (\Exception $e) {
                    // 回滚事务
                    Db::rollback();
                }
            }
        }
        $CouponListModelObj=CouponListModel::where(['status'=>1])->whereNull('uid')->whereTime('end_time','<',time())->order('id asc');
        if ($CouponListModelObj->count()) {
            $CouponListModel=$CouponListModelObj->field('alias_id')->limit(10)->select();
            $CouponData=[];
            foreach ($CouponListModel as $item) {
                if (isset($CouponData[$item->alias_id])&&$CouponData[$item->alias_id]) {
                    $CouponData[$item->alias_id]=$CouponData[$item->alias_id]+1;
                }else{
                    $CouponData[$item->alias_id]=1;
                }
            }
            foreach ($CouponData as $id => $sum) {
                $CouponModel=CouponModel::where(['id'=>$id])->find();
                $CouponModel->surplus_stock=Db::raw('surplus_stock-'.$sum);
                Db::startTrans();
                try {
                    CouponListModel::where(['status'=>1])->whereNull('uid')->whereTime('end_time','<',time())->order('id asc')->where(['alias_id'=>$id])->limit($sum)->update(['status'=>-1]);
                    $CouponModel->save();
                    // 提交事务
                    Db::commit();
                } catch (\Exception $e) {
                    // 回滚事务
                    Db::rollback();
                    p($e->getMessage());
                }
            }
        }
    }
    public function auto_disable_notnull_uid_handle()
    {
        $CouponListModelObj=CouponListModel::where(['status'=>0])->whereNotNull('uid')->whereTime('end_time','<',time())->order('receive_time desc,id asc');
        if ($CouponListModelObj->count()) {
            $CouponListModelObj->limit(10)->update(['status'=>-1]);
        }
        $CouponListModelObj=CouponListModel::where(['status'=>1])->whereNotNull('uid')->whereTime('end_time','<',time())->order('receive_time desc,id asc');
        if ($CouponListModelObj->count()) {
            $CouponListModelObj->limit(10)->update(['status'=>-1]);
        }
    }
    public function expire_del_handle()
    {
        $CouponListModelObj=CouponListModel::where(['status'=>-1])->whereTime('end_time','<',time()-3600*24*30);
        if ($CouponListModelObj->count()) {
            $CouponListModel=$CouponListModelObj->field('alias_id')->limit(1000)->select();
            $CouponData=[];
            foreach ($CouponListModel as $item) {
                if (isset($CouponData[$item->alias_id])&&$CouponData[$item->alias_id]) {
                    $CouponData[$item->alias_id]=$CouponData[$item->alias_id]+1;
                }else{
                    $CouponData[$item->alias_id]=1;
                }
            }
            foreach ($CouponData as $id => $sum) {
                $CouponModel=CouponModel::where(['id'=>$id])->find();
                $CouponModel->del_sum=Db::raw('del_sum+'.$sum);
                Db::startTrans();
                try {
                    $CouponListModelObj->where(['alias_id'=>$id])->limit($sum)->delete();
                    $CouponModel->save();
                    // 提交事务
                    Db::commit();
                } catch (\Exception $e) {
                    // 回滚事务
                    Db::rollback();
                }
            }
        }
    }
}