<?php 
namespace app\common\service\queue;
use think\facade\Cache;
use think\facade\Db;
use helper\Time;
use app\common\model\ApiLog as ApiLogModel;
class Api
{
    public function delete_api_log_handle()
    {
        $api_log_day=Cache::get('basic.api_log_day');
        if ($api_log_day) {
            $api_log_day=intval($api_log_day);
            if(ApiLogModel::whereTime('create_time','<',time()-3600*24*$api_log_day)->count())
            ApiLogModel::whereTime('create_time','<',time()-3600*24*$api_log_day)->limit(100)->delete();
        }else{
            if (ApiLogModel::count()>=5000000) {
                $prefix=config('database.connections.mysql.prefix');
                try {
                    Db::query('CREATE TABLE IF NOT EXISTS '.$prefix.'api_log_copy (LIKE '.$prefix.'api_log);');
                } catch (\Exception $e) {
                    echo $e->getMessage();
                }
                try {
                    Db::query('RENAME TABLE '.$prefix.'api_log TO '.$prefix.'api_log_'.time().';');
                } catch (\Exception $e) {
                    echo $e->getMessage();
                }
                try {
                    Db::query('RENAME TABLE '.$prefix.'api_log_copy TO '.$prefix.'api_log;');
                } catch (\Exception $e) {
                    echo $e->getMessage();
                }
            }
        }
    }
}