<?php 
namespace app\common\service;
use think\console\Command;
use think\console\Input;
use think\console\input\Argument;
use think\console\input\Option;
use think\console\Output;
use think\console\Table;
use app\common\service\queue\Orders as OrdersQueue;
use app\common\service\queue\PushTask as PushTaskQueue;
use app\common\service\queue\UpdateUser as UpdateUserQueue;
use app\common\service\queue\Jobs as JobsQueue;
use app\common\service\queue\Timing as TimingQueue;
use app\common\service\queue\Coupon as CouponQueue;
use app\common\service\queue\Api as ApiQueue;
use EasyTask\Task as EasyTask;
class XYQueue extends Command
{
    /**
     * Version.
     *
     * @var string
     */
    const VERSION = '0.0.2';
    /**
     * [configure]
     * @return [type] [description]
     */
    protected  function configure(){
        //设置名称为task
        $this->setName('queue')
            //增加一个命令参数
            ->addArgument('action', Argument::OPTIONAL, "action", '')
            ->addArgument('data', Argument::OPTIONAL, "data", '');
    }
    protected function execute(Input $input, Output $output)
    {
        //获取输入参数
        $action = trim($input->getArgument('action'));
        $data   = trim($input->getArgument('data'));
        $usedPushTask=1;
        if (intval($data))
            $usedPushTask=intval($data);

        $task=new EasyTask;

        $task->setDaemon(true);
        $task->setAutoRecover(true);
        $task->setPrefix('XYQueue');
        $task->setRunTimePath(runtime_path());
        $task->addClass(OrdersQueue::class, 'expire_time','order_expire', 5, 1);
        $task->addClass(OrdersQueue::class, 'notify_alipay_handle','order_alipay', 5, 1);
        $task->addClass(OrdersQueue::class, 'notify_applepay_handle','order_applepay', 5, 1);
        $task->addClass(OrdersQueue::class, 'notify_wxpay_handle','order_wxpay', 5, 1);
        $task->addClass(OrdersQueue::class, 'notify_toutiao_handle','order_toutiao', 5, 1);
        $task->addClass(OrdersQueue::class, 'notify_baidu_handle','order_baidu', 5, 1);
        $task->addClass(OrdersQueue::class, 'scorepay_handle','order_scorepay', 5, 1);
        $task->addClass(OrdersQueue::class, 'rights_handle','order_rights', 5, 1);
        $task->addClass(PushTaskQueue::class, 'push_handle','push_task', 2, $usedPushTask);
        $task->addClass(PushTaskQueue::class, 'push_queue_handle','push_queue', 3, 1);
        $task->addClass(UpdateUserQueue::class, 'update_user_handle','update_user', 2, 1);
        $task->addClass(UpdateUserQueue::class, 'delete_user_vip_rule_handle','delete_user_vip_rule', 600, 1);
        $task->addClass(UpdateUserQueue::class, 'init_user_vip_handle','init_user_vip', 2, 1);
        $task->addClass(UpdateUserQueue::class, 'auto_disable_handle','auto_disable', 2, 1);
        $task->addClass(JobsQueue::class, 'auto_refresh_handle','auto_refresh_jobs', 2, 1);
        $task->addClass(JobsQueue::class, 'auto_refresh_expire_handle','auto_refresh_expire', 5, 1);
        $task->addClass(JobsQueue::class, 'jobs_top_expire_handle','jobs_top_expire', 5, 1);
        $task->addClass(JobsQueue::class, 'jobs_urgent_expire_handle','jobs_urgent_expire', 5, 1);
        $task->addClass(JobsQueue::class, 'jobs_recommend_expire_handle','jobs_recommend_expire', 5, 1);
        $task->addClass(JobsQueue::class, 'interview_handle','interview', 5, 1);
        $task->addClass(CouponQueue::class, 'auto_enable_handle','auto_enable', 5, 1);
        $task->addClass(CouponQueue::class, 'auto_disable_null_uid_handle','auto_disable_null_uid', 5, 1);
        $task->addClass(CouponQueue::class, 'auto_disable_notnull_uid_handle','auto_disable_notnull_uid', 5, 1);
        $task->addClass(CouponQueue::class, 'expire_del_handle','expire_del', 60, 1);
        $task->addClass(TimingQueue::class, 'script_handle','timing_script', 1, 1);
        $task->addClass(TimingQueue::class, 'get_url_handle','timing_get_url', 1, 1);
        $task->addClass(ApiQueue::class, 'delete_api_log_handle','delete_api_log', 600, 1);
        switch ($action) {
            case 'start':
                $output->writeln("正在启动XYCMS队列服务...");
                $output->writeln("XYQueue version:".static::VERSION);
                $task->start();
                break;
            case 'status':
                $output->writeln("XYCMS队列服务状态");
                $output->writeln("XYQueue version:".static::VERSION);
                $task->status();
                break;
            case 'stop':
                $output->writeln("正在停止XYCMS队列服务...");
                $task->stop(($data=='f'));
                break;
            default:
                if (!in_array($action, ['?']))
                    $output->writeln("<error>不存在命令:{$action}</error>");
                $output->writeln("XYQueue version:".static::VERSION);
                $Table=new Table();
                $Table->setStyle('borderless');
                $Table->setHeader(['Command','Description','Parameter description']);
                $Table->addRow(['start','启动','']);
                $Table->addRow(['start used','设置消息队列进程数启动','used为消息进程数，数字类型']);
                $Table->addRow(['status','查看队列运行状态','']);
                $Table->addRow(['stop','停止队列','']);
                $Table->addRow(['stop f','强制停止队列','']);
                $output->writeln($Table->render());
                break;
        }
    }
}