<?php 
namespace app\common\model;
use think\Model;
class CompanyDemeanor extends Model
{
	public static function getCompanyDemeanor($company_id)
	{
		$Model=self::where(['cid'=>$company_id])->field('id,title,path,status,create_time')->select()->toArray();
		$Data=[];
		foreach ($Model as $k => $v) {
			$Data[$k]=$v;
			$Data[$k]['create_time']=date('Y-m-d',strtotime($v['create_time']));
			$Data[$k]['url']=config('web.imgurl').$v['path'];
			$Data[$k]['visible']=0;
		}
		return $Data;
	}
	public static function getCompanyDemeanorIsExamine($company_id)
	{
		$where=['cid'=>$company_id];
		if(config('xy_company.demeanor_view_status'))
			$where['status']=1;
		$Model=self::where($where)->field('id,title,path,status,create_time')->select()->toArray();
		$Data=[];
		foreach ($Model as $k => $v) {
			$Data[$k]=$v;
			$Data[$k]['create_time']=date('Y-m-d',strtotime($v['create_time']));
			$Data[$k]['url']=config('web.imgurl').$v['path'];
			$Data[$k]['visible']=0;
		}
		return $Data;
	}
}