<?php 
namespace app\common\model;
use think\Model;
use app\common\model\CompanyDevelopmentHistory as CompanyDevelopmentHistoryModel;
class Company extends Model
{
	public static function getEditFind($id)
	{
        $Field=[
            'company.*',
            'user.mobile,user.email,user.status,user.disable_msg',
            'user_info.nickname,user_info.headimg',
            'vip.company_vip_level,vip.company_vip_time',
            'content.contacts,content.contacts_mobile,content.contacts_wechat,content.contacts_tel,content.contacts_email,content.contacts_address,content.contacts_area1,content.contacts_area2,content.contacts_area3,content.company_website,content.company_introduction,content.company_descript,content.template_id,content.contacts_lng,content.contacts_lat',
            'executives.executives,executives.executives_headimg,executives.executives_job_title,executives.executives_desc',
        ];
        $Find=self::alias('company')->where(['company.id'=>$id])
            ->join('user user','user.id = company.uid')
            ->join('user_info user_info','user_info.uid = company.uid','LEFT')
            ->join('user_vip vip','vip.uid = user.id','LEFT')
            ->join('company_content content','content.cid = company.id','LEFT')
            ->join('company_executives executives','executives.cid = company.id','LEFT')
            ->field(implode(',',$Field))
            ->withAttr('nickname',function($v,$d){
                return $v?base64_decode($v):'';
            })
            ->withAttr('headimg',function($v,$d){
                return $v?config('web.imgurl').$v:'';
            })
            ->withAttr('vip_time',function($v,$d){
                return $v?date('Y-m-d'):'';
            })
            ->withAttr('corporate_welfare',function($v,$d){
                return $v?arrtoint(explode(",", $v)):[];
            })->find();
        $Data=false;
        if ($Find) {
            $Data=$Find->toArray();
            $Data['contacts_area']=[$Find->contacts_area2,$Find->contacts_area1,$Find->contacts_area3];
            $Data['development_history']=CompanyDevelopmentHistoryModel::where(['cid'=>$Find->id])
                ->withAttr('time',function($v,$data){
                    return $v*1000;
                })->select()->toArray();
        }
        return $Data;
	}
    public static function getCompanyInfoAll($id)
    {
        $Field=[
            'company.*',
            'user.mobile,user.email,user.status,user.disable_msg',
            'user_info.nickname,user_info.headimg',
            'industry.title as industry',
            'content.contacts,content.contacts_mobile,content.contacts_wechat,content.contacts_tel,content.contacts_email,content.contacts_address,content.company_website,content.company_introduction,content.company_descript,content.template_id,content.contacts_lng,content.contacts_lat',
            'executives.executives,executives.executives_headimg,executives.executives_job_title,executives.executives_desc',
        ];
        $Find=self::alias('company')->where(['company.id'=>$id])
            ->join('user user','user.id = company.uid')
            ->join('user_info user_info','user_info.uid = company.uid','LEFT')
            ->join('company_industry industry','industry.id = company.industry_id')
            ->join('company_content content','content.cid = company.id','LEFT')
            ->join('company_executives executives','executives.cid = company.id','LEFT')
            ->field(implode(',',$Field))
            ->withAttr('nickname',function($v,$d){
                return $v?base64_decode($v):'';
            })
            ->withAttr('headimg',function($v,$d){
                return $v?config('web.imgurl').$v:'';
            })
            ->withAttr('business_license',function($v,$d){
                return $v?config('web.imgurl').$v:'';
            })
            ->withAttr('logo',function($v,$d){
                return $v?config('web.imgurl').$v:'';
            })
            ->withAttr('corporate_welfare',function($v,$d){
                return $v?arrtoint(explode(",", $v)):[];
            })->find();
        $Data=false;
        if ($Find) {
            $Data=$Find->toArray();
            $Data['contacts_area']=[$Find->contacts_area2,$Find->contacts_area1,$Find->contacts_area3];
            $Data['development_history']=CompanyDevelopmentHistoryModel::where(['cid'=>$Find->id])
                ->withAttr('time',function($v,$data){
                    return date('Y-m-d',$v);
                })->select()->toArray();
        }
        return $Data;
    }
    public static function getContacts($where)
    {
        $Field=[
            'content.contacts,content.contacts_mobile,content.contacts_address,content.contacts_area1,content.contacts_area2,content.contacts_area3',
        ];
        $Find=self::alias('company')->where($where)
            ->join('company_content content','content.cid = company.id','LEFT')
            ->field(implode(',',$Field))->find();
        $Data=false;
        if ($Find) {
            $Data=$Find->toArray();
            $Data['contacts_area']=[$Find->contacts_area2,$Find->contacts_area1,$Find->contacts_area3];
        }
        return $Data;
    }
}