<?php
namespace app\common\event;
use helper\Time;
use app\common\model\ScoreTaskComplete as ScoreTaskCompleteModel;
use app\common\model\UserQq as UserQqModel;
use app\common\model\UserWx as UserWxModel;
use app\common\model\Company as CompanyModel;
use app\common\model\CompanyDemeanor as CompanyDemeanorModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\ResumeReport as ResumeReportModel;
use app\common\model\JobsReport as JobsReportModel;
use app\common\model\Resume as ResumeModel;
use app\common\model\ResumeRefresh as ResumeRefreshModel;
use app\common\model\Files as FilesModel;
class ScoreTask
{
	//未完成状态值
	const COMPLETE_STATUS_0=0;
	//待领取状态值
	const COMPLETE_STATUS_1=1;
	//已完成状态值
	const COMPLETE_STATUS_2=2;
	//event
	public static $event=[[
				'value'=>'reg','text'=>'用户注册','is_company'=>null,'repeat'=>0
			],[
				'value'=>'sign_in','text'=>'签到','is_company'=>null,'repeat'=>1
			],[
				'value'=>'bind_wx','text'=>'绑定微信帐号','is_company'=>null,'repeat'=>0
			],[
				'value'=>'bind_qq','text'=>'绑定QQ帐号','is_company'=>null,'repeat'=>0
			],[
				'value'=>'update_logo','text'=>'上传Logo','is_company'=>1,'repeat'=>0
			],[
				'value'=>'company_info','text'=>'完善企业资料','is_company'=>1,'repeat'=>0
			],[
				'value'=>'company_attestation','text'=>'上传营业执照并通过认证','is_company'=>1,'repeat'=>0
			],[
				'value'=>'company_address_map','text'=>'开通电子地图','is_company'=>1,'repeat'=>0
			],[
				'value'=>'company_demeanor','text'=>'上传企业风采','is_company'=>1,'repeat'=>0
			],[
				'value'=>'handle_delivery_resume','text'=>'处理3天内收到的简历','is_company'=>1,'repeat'=>1
			],[
				'value'=>'reply_resume','text'=>'及时回复求职者咨询','is_company'=>1,'repeat'=>1
			],[
				'value'=>'report_resume','text'=>'举报简历','is_company'=>1,'repeat'=>1
			],[
				'value'=>'refresh_resume_today','text'=>'每日刷新简历','is_company'=>0,'repeat'=>1
			],[
				'value'=>'update_hredimg','text'=>'上传头像','is_company'=>0,'repeat'=>0
			],[
				'value'=>'resume_progress_60','text'=>'简历完整度达到60%','is_company'=>0,'repeat'=>0
			],[
				'value'=>'resume_progress_90','text'=>'简历完整度达到90%','is_company'=>0,'repeat'=>0
			],[
				'value'=>'delivery_resume_today','text'=>'每日投递简历','is_company'=>0,'repeat'=>1
			],[
				'value'=>'report_jobs','text'=>'举报职位','is_company'=>0,'repeat'=>1
			]];
	public static function isComplete($uid,$Task)
	{
        $Task['whereTime']='d';
        switch ($Task['repeat']) {
            case 1:
                $Task['whereTime']='today';
                break;
            case 2:
                $Task['whereTime']='week';
                break;
            case 3:
                $Task['whereTime']='month';
                break;
        }
		switch ($Task['event']) {
			case 'reg':
				return self::hasReg($uid,$Task);
				break;
			case 'sign_in':
				return self::hasSignIn($uid,$Task);
				break;
			case 'bind_wx':
				return self::hasBindWx($uid,$Task);
				break;
			case 'bind_qq':
				return self::hasBindQq($uid,$Task);
				break;
			case 'update_logo':
				return self::hasUpdateLogo($uid,$Task);
				break;
			case 'company_info':
				return self::hasCompanyInfo($uid,$Task);
				break;
			case 'company_attestation':
				return self::hasCompanyAttestation($uid,$Task);
				break;
			case 'company_address_map':
				return self::hasCompanyAddressMap($uid,$Task);
				break;
			case 'company_demeanor':
				return self::hasCompanyDemeanor($uid,$Task);
				break;
			case 'handle_delivery_resume':
				return self::hasHandleDeliveryResume($uid,$Task);
				break;
			case 'reply_resume':
				return self::hasReplyResume($uid,$Task);
				break;
			case 'report_resume':
				return self::hasReportResume($uid,$Task);
				break;
			case 'refresh_resume_today':
				return self::hasRefreshResumeToday($uid,$Task);
				break;
			case 'update_hredimg':
				return self::hasUpdateHredimg($uid,$Task);
				break;
			case 'resume_progress_60':
				return self::hasResumeProgress($uid,$Task,60);
				break;
			case 'resume_progress_90':
				return self::hasResumeProgress($uid,$Task,90);
				break;
			case 'delivery_resume_today':
				return self::hasDeliveryResumeToday($uid,$Task);
				break;
			case 'report_jobs':
				return self::hasReportJobs($uid,$Task);
				break;
		}
	}
	public static function hasReg($uid,$Task)
	{
        return ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_1;
	}
	public static function hasSignIn($uid,$Task)
	{
        if ($Task['repeat']) {
            $complete_sum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->whereTime('create_time',$Task['whereTime'])->count();
            return $complete_sum>=$Task['repeat_sum']?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }else{
            return ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }
	}
	public static function hasBindWx($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
			if (UserWxModel::where(['uid'=>$uid])->count()) {
				return self::COMPLETE_STATUS_1;
			}else{
				return self::COMPLETE_STATUS_0;
			}
		}
	}
	public static function hasBindQq($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
			if (UserQqModel::where(['uid'=>$uid])->count()) {
				return self::COMPLETE_STATUS_1;
			}else{
				return self::COMPLETE_STATUS_0;
			}
		}
	}
	public static function hasUpdateLogo($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$CompanyModel=CompanyModel::where(['uid'=>$uid])->find();
        	if ($CompanyModel && $CompanyModel->logo) {
				return self::COMPLETE_STATUS_1;
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasCompanyInfo($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$CompanyModel=CompanyModel::where(['uid'=>$uid])->find();
        	if ($CompanyModel) {
				return self::COMPLETE_STATUS_1;
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasCompanyAttestation($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$CompanyModel=CompanyModel::where(['uid'=>$uid])->find();
        	if ($CompanyModel && $CompanyModel->attestation) {
				return self::COMPLETE_STATUS_1;
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasCompanyAddressMap($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$CompanyModel=CompanyModel::alias('c')->where(['c.uid'=>$uid])
        	->join('company_content contacts','contacts.cid=c.id','LEFT')->field('c.id,contacts.contacts_lng,contacts.contacts_lat')->find();
        	if ($CompanyModel 
        		&& $CompanyModel->contacts_lng 
        		&& $CompanyModel->contacts_lat) {
				return self::COMPLETE_STATUS_1;
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasCompanyDemeanor($uid,$Task)
	{
		$CompleteSum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count();
		if ($CompleteSum>=$Task['repeat_sum']) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$CompanyModel=CompanyModel::where(['uid'=>$uid])->find();
        	if ($CompanyModel) {
        		$DemeanorSum=CompanyDemeanorModel::where(['cid'=>$CompanyModel->id,'status'=>1])->count();
        		if ($DemeanorSum>0 && $CompleteSum>=$DemeanorSum)
					return self::COMPLETE_STATUS_0;
        		if ($CompleteSum<$DemeanorSum) {
					return self::COMPLETE_STATUS_1;
        		}else{
					return self::COMPLETE_STATUS_2;
        		}
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasHandleDeliveryResume($uid,$Task)
	{
		$CompleteSum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count();
        if ($Task['repeat']) {
			if ($CompleteSum>=$Task['repeat_sum']) {
				return self::COMPLETE_STATUS_2;
			}else{
	        	$CompanyModel=CompanyModel::where(['uid'=>$uid])->find();
	        	if ($CompanyModel) {
	        		$JobsDeliveryResumeSum=JobsDeliveryResumeModel::where(['company_id'=>$CompanyModel->id])->whereRaw('status<>0')->whereTime('create_time',Time::dayToNow(3))->count();
	        		if ($JobsDeliveryResumeSum>0 && $CompleteSum>=$JobsDeliveryResumeSum)
						return self::COMPLETE_STATUS_0;
	        		if ($CompleteSum<$JobsDeliveryResumeSum) {
						return self::COMPLETE_STATUS_1;
	        		}else{
						return self::COMPLETE_STATUS_2;
	        		}
	        	}else{
					return self::COMPLETE_STATUS_0;
	        	}
			}
        }else{
            return $CompleteSum>=$Task['repeat_sum']?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }
	}
	public static function hasReplyResume($uid,$Task)
	{
		return self::COMPLETE_STATUS_0;
	}
	public static function hasReportResume($uid,$Task)
	{
        if ($Task['repeat']) {
			$CompleteSum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->whereTime('create_time',$Task['whereTime'])->count();
			if ($CompleteSum>=$Task['repeat_sum']) {
				return self::COMPLETE_STATUS_2;
			}else{
        		$ResumeReportSum=ResumeReportModel::where(['uid'=>$uid])->whereTime('create_time',$Task['whereTime'])->count();
        		if ($ResumeReportSum>0 && $CompleteSum>=$ResumeReportSum)
					return self::COMPLETE_STATUS_0;
        		if ($CompleteSum<$ResumeReportSum) {
					return self::COMPLETE_STATUS_1;
        		}else{
					return self::COMPLETE_STATUS_2;
        		}
			}
        }else{
            return ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()>=$Task['repeat_sum']?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }
	}
	public static function hasRefreshResumeToday($uid,$Task)
	{
        if ($Task['repeat']) {
			$CompleteSum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->whereTime('create_time',$Task['whereTime'])->count();
			if ($CompleteSum>=$Task['repeat_sum']) {
				return self::COMPLETE_STATUS_2;
			}else{
	        	$ResumeModel=ResumeModel::where(['uid'=>$uid])->find();
	        	if ($ResumeModel) {
	        		$ResumeRefreshSum=ResumeRefreshModel::where(['resume_id'=>$ResumeModel->id])->whereTime('create_time',$Task['whereTime'])->count();
	        		if ($ResumeRefreshSum>0 && $CompleteSum>=$ResumeRefreshSum)
						return self::COMPLETE_STATUS_0;
	        		if ($CompleteSum<$ResumeRefreshSum) {
						return self::COMPLETE_STATUS_1;
	        		}else{
						return self::COMPLETE_STATUS_2;
	        		}
	        	}else{
					return self::COMPLETE_STATUS_0;
	        	}
			}
        }else{
            return ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()>=$Task['repeat_sum']?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }
	}
	public static function hasUpdateHredimg($uid,$Task)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$UserInfoModel=FilesModel::where(['type'=>1,'uid'=>$uid])->count();
        	if ($UserInfoModel) {
				return self::COMPLETE_STATUS_1;
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasResumeProgress($uid,$Task,$progress)
	{
		if (ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()) {
			return self::COMPLETE_STATUS_2;
		}else{
        	$ResumeModel=ResumeModel::where(['uid'=>$uid])->find();
        	if ($ResumeModel) {
        		if ($ResumeModel->progress >= $progress)
					return self::COMPLETE_STATUS_1;
				return self::COMPLETE_STATUS_0;
        	}else{
				return self::COMPLETE_STATUS_0;
        	}
		}
	}
	public static function hasDeliveryResumeToday($uid,$Task)
	{
        if ($Task['repeat']) {
			$CompleteSum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->whereTime('create_time',$Task['whereTime'])->count();
			if ($CompleteSum>=$Task['repeat_sum']) {
				return self::COMPLETE_STATUS_2;
			}else{
	        	$ResumeModel=ResumeModel::where(['uid'=>$uid])->find();
	        	if ($ResumeModel) {
	        		$JobsDeliveryResumeSum=JobsDeliveryResumeModel::where(['resume_id'=>$ResumeModel->id])->whereTime('create_time',$Task['whereTime'])->count();
	        		if ($JobsDeliveryResumeSum>0 && $CompleteSum>=$JobsDeliveryResumeSum)
						return self::COMPLETE_STATUS_0;
	        		if ($CompleteSum<$JobsDeliveryResumeSum) {
						return self::COMPLETE_STATUS_1;
	        		}else{
						return self::COMPLETE_STATUS_2;
	        		}
	        	}else{
					return self::COMPLETE_STATUS_0;
	        	}
			}
        }else{
            return ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()>=$Task['repeat_sum']?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }
	}
	public static function hasReportJobs($uid,$Task)
	{
        if ($Task['repeat']) {
			$CompleteSum=ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->whereTime('create_time',$Task['whereTime'])->count();
			if ($CompleteSum>=$Task['repeat_sum']) {
				return self::COMPLETE_STATUS_2;
			}else{
        		$JobsReportSum=JobsReportModel::where(['uid'=>$uid])->whereTime('create_time',$Task['whereTime'])->count();
        		if ($JobsReportSum>0 && $CompleteSum>=$JobsReportSum)
					return self::COMPLETE_STATUS_0;
        		if ($CompleteSum<$JobsReportSum) {
					return self::COMPLETE_STATUS_1;
        		}else{
					return self::COMPLETE_STATUS_2;
        		}
			}
        }else{
            return ScoreTaskCompleteModel::where(['uid'=>$uid,'tid'=>$Task['id']])->count()>=$Task['repeat_sum']?self::COMPLETE_STATUS_2:self::COMPLETE_STATUS_0;
        }
	}
}
