<?php
namespace app\common\controller;
use app\common\variable\MsgCode;
use think\facade\Cache;
use think\facade\Db;
use helper\Time;
use app\common\model\Orders as OrdersModel;
use app\common\model\NotifyAlipay as NotifyAlipayModel;
use app\common\model\NotifyApplepay as NotifyApplepayModel;
use app\common\model\NotifyToutiao as NotifyToutiaoModel;
use app\common\model\NotifyBaidu as NotifyBaiduModel;
use app\common\model\NotifyWxpay as NotifyWxpayModel;
use app\common\model\UserInfo as UserInfoModel;
use app\common\model\UserVip as UserVipModel;
use app\common\model\UserScore as UserScoreModel;
use app\common\model\Vip as VipModel;
use app\common\model\VipRule as VipRuleModel;
use app\common\model\VipRuleValue as VipRuleValueModel;
use app\common\model\VipValueAdded as VipValueAddedModel;
use app\common\model\VipValueAddedDiscount as VipValueAddedDiscountModel;
use app\common\model\UserVipRule as UserVipRuleModel;
use app\common\model\JobsRefreshAuto as JobsRefreshAutoModel;
use app\common\model\JobsExtensionLog as JobsExtensionLogModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\ResumeDownloaded as ResumeDownloadedModel;
use app\common\model\JobFair as JobFairModel;
use app\common\model\JobFairBooth as JobFairBoothModel;
use app\common\model\JobFairCompany as JobFairCompanyModel;
use app\common\model\CrmAchievement as CrmAchievementModel;
use app\common\model\CrmCustomer as CrmCustomerModel;
/**
 * 
 */
class Orders extends Base
{
	public static function ordersHandle($D)
	{
        $OrdersModel=OrdersModel::where(['otrade'=>$D['otrade']])
                ->field('oid,otitle,otrade,type,alias_id,pay_type,uid,oprice,content')
                ->withAttr('content',function($v,$data){
                    return $v?json_decode($v,true):$v;
                })
                ->find();
        $NotifyModel=Null;
        switch ($OrdersModel->pay_type) {
            case 1:
                $NotifyModel=NotifyAlipayModel::where(['id'=>$D['id']])->find();
                break;
            case 2:
                $NotifyModel=NotifyWxpayModel::where(['id'=>$D['id']])->find();
                break;
            case 3:
                $NotifyModel=NotifyApplepayModel::where(['id'=>$D['id']])->find();
                break;
            case 6:
                $NotifyModel=NotifyToutiaoModel::where(['id'=>$D['id']])->find();
                break;
            case 7:
                $NotifyModel=NotifyBaiduModel::where(['id'=>$D['id']])->find();
                break;
        }
        if ($OrdersModel && $D['oprice']==$OrdersModel->oprice) {
            $CrmAchievementModel=null;
            if ($NotifyModel){
                $NotifyModel->status=1;
                $CrmCustomerModel=CrmCustomerModel::alias('crm')
                ->whereNotNull('company.adviser_id')
                ->where(['company.uid'=>$OrdersModel->uid])
                ->join('company company','company.id=crm.company_id')
                ->field('crm.company_id,company.adviser_id')
                ->find();
                if($CrmCustomerModel){
                    $CrmAchievementModel=new CrmAchievementModel;
                    $CrmAchievementModel->oid=$OrdersModel->oid;
                    $CrmAchievementModel->adviser_id=$CrmCustomerModel->adviser_id;
                    $CrmAchievementModel->company_id=$CrmCustomerModel->company_id;
                    if (!Cache::get('xy_crm.achievement_examine')){
                        $CrmAchievementModel->status=1;
                        $CrmAchievementModel->examine_time=time();
                    }
                    $CrmAchievementModel->price=$D['oprice'];
                }
            }
            $OrdersModel->status=2;
            $OrdersModel->finish_time=time();
            switch ($OrdersModel->type) {
                case 1:
                    $VipModel=VipModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $VipRuleModel=VipRuleModel::alias('rule')->where(['rule.vid'=>$OrdersModel->alias_id,'rv.status'=>1,'rv.type'=>'input'])
                        ->join('vip_rule_value rv','rv.id=rule.rid')
                        ->field('rule.vid,rule.rid,rule.value,rv.alias')->select()->toArray();
                    $UserInfoModel=UserInfoModel::where(['uid'=>$OrdersModel->uid])->find();
                    $UserVipModel=UserVipModel::where(['uid'=>$OrdersModel->uid])->find();
                    if (!$UserVipModel) {
                        $UserVipModel=new UserVipModel;
                        $UserVipModel->uid=$OrdersModel->uid;
                    }
                    $UserVipModel->update_vip=1;
                    $UserVipRuleList=[];
                    $UserScoreModel=null;
                    if ($VipRuleModel) {
                        list($start, $expiry_time) = Time::today();
                        $UserVipRuleModel=new UserVipRuleModel;
                        foreach ($VipRuleModel as $k => $v) {
                            switch ($v['alias']) {
                                case 'time-limit':
                                    $surplus_value=Time::daysToSecond($v['value'])+3600*24;
                                    $expiry_time=$expiry_time+$surplus_value;
                                    if ($VipModel->is_company) {
                                        if ($UserVipModel->company_vip_level>0&&$UserVipModel->company_vip_time>time()) {
                                            $UserVipModel->company_vip_time=Db::raw('company_vip_time+'.$surplus_value);
                                        }else{
                                            $UserVipModel->company_vip_time=$expiry_time;

                                        }
                                    }else{
                                        if ($UserVipModel->personal_vip_time>time()) {
                                            $UserVipModel->personal_vip_time=Db::raw('personal_vip_time+'.$surplus_value);
                                        }else{
                                            $UserVipModel->personal_vip_time=$expiry_time;

                                        }
                                    }
                                    break;
                                case 'bonus-points':
                                    $UserInfoModel->score=Db::raw('score+'.$v['value']);
                                    $UserScoreModel=new UserScoreModel;
                                    $UserScoreModel->uid    =   $OrdersModel->uid;
                                    $UserScoreModel->tid    =   0;
                                    $UserScoreModel->score  =   $v['value'];
                                    $UserScoreModel->desc   =   '开通'.$VipModel->title.'套餐赠送'.$v['value'].'积分';
                                    Cache::set('updateUser:'.$OrdersModel->uid,true);
                                    break;
                                default:
                                    $v['uid']=$OrdersModel->uid;
                                    $v['level']=$VipModel->level;
                                    $v['surplus_value']=$v['value'];
                                    $UserVipRuleList[]=$v;
                                    break;
                            }
                        }
                        if (!empty($UserVipRuleList))
                            array_walk($UserVipRuleList,function(&$v,$k)use($expiry_time){
                                $v['expiry_time']=$expiry_time;
                                krsort($v);
                            });
                    }
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
	                	if ($CrmAchievementModel) $CrmAchievementModel->save();
	                	$OrdersModel->save();
                        VipModel::where(['id'=>$OrdersModel->alias_id])->inc('sold')->update();
                        if (!empty($UserVipRuleList)) $UserVipRuleModel->saveAll($UserVipRuleList);
                        $UserInfoModel->save();
                        $UserVipModel->save();
                        if ($UserScoreModel) $UserScoreModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 2:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $VipValueAddedModel->sold=Db::raw('sold+1');
                    $UserVipRuleModel=new UserVipRuleModel;
                    $UserVipRuleModel->uid 			=	$OrdersModel->uid;
                    $UserVipRuleModel->rid 			=	$OrdersModel->alias_id;
                    $UserVipRuleModel->value 		=	$VipValueAddedModel->value;
                    $UserVipRuleModel->surplus_value=	$VipValueAddedModel->value;
                    $UserVipRuleModel->expiry_time 	=	time()+3600*24*$VipValueAddedModel->effective_day;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $UserVipRuleModel->save();
                        $VipValueAddedModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 3:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $VipValueAddedModel->sold=Db::raw('sold+1');
                    $UserVipRuleModel=new UserVipRuleModel;
                    $UserVipRuleModel->uid 			=	$OrdersModel->uid;
                    $UserVipRuleModel->rid 			=	$OrdersModel->alias_id;
                    $UserVipRuleModel->value 		=	$VipValueAddedModel->value;
                    $UserVipRuleModel->surplus_value=	$VipValueAddedModel->value;
                    $UserVipRuleModel->expiry_time 	=	time()+3600*24*$VipValueAddedModel->effective_day;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $UserVipRuleModel->save();
                        $VipValueAddedModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 4:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $JobsModel=JobsModel::where(['id'=>$OrdersModel->content['jobs_id']])->find();
                    if($JobsModel->top){
                        $JobsModel->top         =1;
                        $JobsModel->top_time    =$JobsModel->top_time+3600*24*$VipValueAddedModel->value;
                    }else{
                        $JobsModel->top         =1;
                        $JobsModel->top_time    =time()+3600*24*$VipValueAddedModel->value;
                    }
                    $JobsExtensionLogModel=new JobsExtensionLogModel;
                    $JobsExtensionLogModel->uid          =   $OrdersModel->uid;
                    $JobsExtensionLogModel->jobs_id      =   $OrdersModel->content['jobs_id'];
                    $JobsExtensionLogModel->vid          =   $OrdersModel->alias_id;
                    $JobsExtensionLogModel->type         =   $VipValueAddedModel->type;
                    $JobsExtensionLogModel->value        =   $VipValueAddedModel->value;
                    $JobsExtensionLogModel->start_time   =   time();
                    $JobsExtensionLogModel->end_time     =   time()+3600*24*$VipValueAddedModel->value;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $JobsModel->save();
                        $JobsExtensionLogModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 5:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $JobsModel=JobsModel::where(['id'=>$OrdersModel->content['jobs_id']])->find();
                    if($JobsModel->urgent){
                        $JobsModel->urgent         =1;
                        $JobsModel->urgent_time    =$JobsModel->urgent_time+3600*24*$VipValueAddedModel->value;
                    }else{
                        $JobsModel->urgent         =1;
                        $JobsModel->urgent_time    =time()+3600*24*$VipValueAddedModel->value;
                    }
                    $JobsExtensionLogModel=new JobsExtensionLogModel;
                    $JobsExtensionLogModel->uid          =   $OrdersModel->uid;
                    $JobsExtensionLogModel->jobs_id      =   $OrdersModel->content['jobs_id'];
                    $JobsExtensionLogModel->vid          =   $OrdersModel->alias_id;
                    $JobsExtensionLogModel->type         =   $VipValueAddedModel->type;
                    $JobsExtensionLogModel->value        =   $VipValueAddedModel->value;
                    $JobsExtensionLogModel->start_time   =   time();
                    $JobsExtensionLogModel->end_time     =   time()+3600*24*$VipValueAddedModel->value;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $JobsModel->save();
                        $JobsExtensionLogModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 6:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->inc('sold')->update();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 7:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $VipValueAddedModel->sold=Db::raw('sold+1');
                    $JobsRefreshAutoModel=new JobsRefreshAutoModel;
                    $JobsRefreshAutoModel->uid          =   $OrdersModel->uid;
                    $JobsRefreshAutoModel->jobs_id      =   $OrdersModel->content['jobs_id'];
                    $JobsRefreshAutoModel->vid          =   $OrdersModel->alias_id;
                    $JobsRefreshAutoModel->value        =   $VipValueAddedModel->value;
                    $JobsRefreshAutoModel->start_time   =   time()+3600*4;
                    $JobsRefreshAutoModel->next_time    =   time()+3600*4;
                    $JobsRefreshAutoModel->end_time     =   time()+3600*24*$VipValueAddedModel->value;
                    $JobsExtensionLogModel=new JobsExtensionLogModel;
                    $JobsExtensionLogModel->uid          =   $OrdersModel->uid;
                    $JobsExtensionLogModel->jobs_id      =   $OrdersModel->content['jobs_id'];
                    $JobsExtensionLogModel->vid          =   $OrdersModel->alias_id;
                    $JobsExtensionLogModel->type         =   $VipValueAddedModel->type;
                    $JobsExtensionLogModel->value        =   $VipValueAddedModel->value;
                    $JobsExtensionLogModel->start_time   =   time()+3600*4;
                    $JobsExtensionLogModel->end_time     =   time()+3600*24*$VipValueAddedModel->value;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $JobsRefreshAutoModel->save();
                        $VipValueAddedModel->save();
                        $JobsExtensionLogModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 8:
                    $VipValueAddedModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->inc('sold')->update();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 10:
                    $UserScoreModel=new UserScoreModel;
                    $UserScoreModel->uid    =   $OrdersModel->alias_id;
                    $UserScoreModel->tid    =   0;
                    $UserScoreModel->score  =   $OrdersModel->content['value'];
                    $UserScoreModel->desc   =   $OrdersModel->otitle;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $UserScoreModel->save();
                        UserInfoModel::where(['uid'=>$OrdersModel->alias_id])->inc('score',$OrdersModel->content['value'])->update();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 11:
                    $ResumeDownloadedModel=ResumeDownloadedModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $ResumeDownloadedModel->status=1;
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $ResumeDownloadedModel->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
                case 12:
                    $JobFairBoothModel=JobFairBoothModel::where(['id'=>$OrdersModel->alias_id])->find();
                    $JobFairBoothModel->company_id=$OrdersModel->content['company_id'];
                    $JobFairBoothModel->status=2;
                    $JobFairBoothModel->lock_time=time();
                    $JobFairCompanyModel=JobFairCompanyModel::where(['jid'=>$JobFairBoothModel->jid,'company_id'=>$OrdersModel->content['company_id']])->find();
                    $JobFairModel=null;
                    $JobFairCompany=null;
                    if (!$JobFairCompanyModel) {
                        $JobFairModel=JobFairModel::where(['id'=>$JobFairBoothModel->jid])->find();
                        $JobFairModel->company_sum=Db::raw('company_sum+1');
                        $JobFairCompany=new JobFairCompanyModel;
                        $JobFairCompany->jid=$JobFairBoothModel->jid;
                        $JobFairCompany->company_id=$OrdersModel->content['company_id'];
                    }elseif($JobFairCompanyModel->bid>$JobFairBoothModel->id){
                        $JobFairCompanyModel->bid=$JobFairBoothModel->id;
                        $JobFairCompany=$JobFairCompanyModel;
                    }
                    Db::startTrans();
                    try {
                        if ($NotifyModel) $NotifyModel->save();
                        if ($CrmAchievementModel) $CrmAchievementModel->save();
                        $OrdersModel->save();
                        $JobFairBoothModel->save();
                        if($JobFairModel)$JobFairModel->save();
                        if($JobFairCompany)$JobFairCompany->save();
                        // 提交事务
                        Db::commit();
                    } catch (Exception $e) {
                        //回滚事务
                        Db::rollback();
                    }
                break;
            }
        }else{
        	if ($NotifyModel) {
	        	$NotifyModel->status=2;
	        	$NotifyModel->save();
        	}
        }
	}
    public static function cancelOrder($D,$is_del=false,$is_queue=true)
    {
        $where=[];
        if (!$is_queue)
            $where[]=['uid','=',$D['uid']];
        $where[]=['otrade','=',$D['otrade']];
        if (!$is_del)
            $where[]=['status','=',0];
        $OrdersModel=OrdersModel::where($where)->find();
        if (!$OrdersModel)
            return parent::ajaxReturn('订单不存在',MsgCode::$error);
        if ($is_del) {
            $OrdersModel->status=-1;
            $OrdersModel->cancel_time=time();
            $OrdersModel->delete_time=time();
        }else{
            $OrdersModel->status=-1;
            $OrdersModel->cancel_time=time();
        }
        $UserInfoModel=null;
        $UserScoreModel=null;
        if ($OrdersModel->score>0) {
            $UserInfoModel=UserInfoModel::where(['uid'=>$OrdersModel->uid])->find();
            $UserInfoModel->score=Db::raw('score+'.$OrdersModel->score);
            $UserScoreModel=new UserScoreModel;
            $UserScoreModel->uid    =   $OrdersModel->uid;
            $UserScoreModel->tid    =   0;
            $UserScoreModel->score  =   $OrdersModel->score;
            $UserScoreModel->desc   =   $OrdersModel->otitle.'订单过期返还积分。';
        }
        $StockModel=null;
        $JobFairBoothModel=null;
        switch ($OrdersModel->type) {
            case 1:
                $StockModel=VipModel::where(['id'=>$OrdersModel->alias_id])->find();
                break;
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
                $StockModel=VipValueAddedModel::where(['id'=>$OrdersModel->alias_id])->find();
                break;
            case 12:
                $JobFairBoothModel=JobFairBoothModel::where(['id'=>$OrdersModel->alias_id])->find();
                $JobFairBoothModel->status=0;
                break;
        }
        if ($StockModel) {
            if ($StockModel->stock) {
                $StockModel->surplus_stock  = Db::raw('surplus_stock+1');
            }else{
                $StockModel=null;
            }
        }
        Db::startTrans();
        try {
            $OrdersModel->save();
            if ($StockModel)$StockModel->save();
            if ($JobFairBoothModel)$JobFairBoothModel->save();
            if ($UserInfoModel)$UserInfoModel->save();
            if ($UserScoreModel)$UserScoreModel->save();
            // 提交事务
            Db::commit();
            return parent::ajaxReturn();
        } catch (Exception $e) {
            //回滚事务
            Db::rollback();
            return parent::ajaxReturn($is_del?'删除失败，请重试':'取消失败，请重试',MsgCode::$error);
        }
    }
    public static function getOrderInfoStatus($D)
    {
        $OrdersModel=OrdersModel::where(['uid'=>$D['uid'],'otrade'=>$D['otrade']])->field('otrade,status')->find();
        if ($OrdersModel) {
            switch ($OrdersModel->status) {
                case 1:
                case 2:
                    return parent::ajaxReturn('订单已支付',MsgCode::$pay_success);
                default:
                    return parent::ajaxReturn('订单未支付',MsgCode::$success,$OrdersModel);
            }
        }else{
            return parent::ajaxReturn('订单不存在',MsgCode::$error);
        }
    }
    public static function getSelect($G)
    {
        $where=[];
        $where[]=['o.uid','=',$G['uid']];
        if (!empty($G['type']) && $G['type']!='all') {
            switch ($G['type']) {
                case 'vip':
                    $where[]=['o.type','=',1];
                    break;
                case 'value-added':
                    $where[]=['o.type','in',[2,3,4,5,6,7,8,9]];
                    break;
                case 'score':
                    $where[]=['o.type','=',10];
                    break;
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                    $where[]=['o.type','=',intval($G['type'])];
                    break;
            }
        }
        if (isset($G['status']) && $G['status']!='all')
            $where[]=['o.status','=',intval($G['status'])];
        $whereTime=[];
        if (!empty($G['time'])) {
            $whereTime[]=$G['time'][0].' 00:00:00';
            $whereTime[]=$G['time'][1].'23:59:59';
        }
        $DataModel=OrdersModel::alias('o')->where($where);
        if (!empty($whereTime))
            $DataModel->whereTime('o.create_time','between',$whereTime);
        $Data=$DataModel->where(['type.alias'=>'vip/type'])
            ->whereNull('o.delete_time')
            ->join('status_alias type','type.value=o.type')
            ->order('o.oid desc')->field('o.*,type.title as type_text')->paginate(15)->each(function($v){
                $v['expire_time']=$v['expire_time']?date('Y-m-d H:i:s',$v['expire_time']):'';
                $v['pay_time']=$v['pay_time']?date('Y-m-d H:i:s',$v['pay_time']):'';
                $v['finish_time']=$v['finish_time']?date('Y-m-d H:i:s',$v['finish_time']):'';
                $v['cancel_time']=$v['cancel_time']?date('Y-m-d H:i:s',$v['cancel_time']):'';
                return $v;
            });
        if ($Data->items()) {
            return parent::ajaxReturn('',0,$Data);
        }else{
            return parent::ajaxReturn('暂无数据~',MsgCode::$error);
        }
    }
    public static function getInvoiceSelect($uid,$is_all=false)
    {
        $where=[];
        $where[]=['o.uid','=',$uid];
        $where[]=['o.invoice_status','=',0];
        $where[]=['o.status','=',2];
        $where[]=['o.pay_type','in',[1,2,3]];
        $DataModel=OrdersModel::alias('o')->where($where);
        $Data=$DataModel->where(['type.alias'=>'vip/type'])
            ->whereNull('o.delete_time')
            ->join('status_alias type','type.value=o.type')
            ->order('o.oid desc')->field('o.*,type.title as type_text')->paginate($is_all?1000:15)->each(function($v){
                $v['expire_time']=$v['expire_time']?date('Y-m-d H:i:s',$v['expire_time']):'';
                $v['pay_time']=$v['pay_time']?date('Y-m-d H:i:s',$v['pay_time']):'';
                $v['finish_time']=$v['finish_time']?date('Y-m-d H:i:s',$v['finish_time']):'';
                $v['cancel_time']=$v['cancel_time']?date('Y-m-d H:i:s',$v['cancel_time']):'';
                return $v;
            });
        if ($Data->items()) {
            $price=OrdersModel::alias('o')->where($where)->whereNull('o.delete_time')->sum('oprice');
            return parent::ajaxReturn($price,0,$Data);
        }else{
            return parent::ajaxReturn('暂无数据~',MsgCode::$error);
        }
    }
}