<?php
namespace app\common\controller;
use think\facade\View;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\validate\Jobs as JobsValidate;
use app\common\validate\JobsContact as JobsContactValidate;
use think\exception\ValidateException;
use app\common\model\Jobs as JobsModel;
use app\common\model\JobsContacts as JobsContactsModel;
use app\common\model\Company as CompanyModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\InviteAninterview as InviteAninterviewModel;
use app\common\model\CompanyContent as CompanyContentModel;
/**
 * 
 */
class JobsDeliveryResume extends Base
{
    public static function getPersonalJobsDeliveryResume($uid,$where=[])
    {
        $JobsDeliveryResumeModel=JobsDeliveryResumeModel::alias('d')->where(['d.uid'=>$uid])
            ->where($where)
            ->whereNull('d.personal_delete_time')
            ->join('jobs jobs','jobs.id=d.jobs_id')
            ->join('area city','city.id = jobs.jobs_area2')
            ->join('company company','company.id=jobs.company_id')
            ->order('d.id desc')
            ->field('d.id,jobs.title,d.jobs_id,d.status,d.create_time,d.update_time,company.id as company_id,company.title as company_name,company.logo as company_logo,city.title as jobs_city,jobs.salary_min,jobs.salary_max,jobs.salary_year')->paginate(15)
            ->each(function($item, $key){
                $item->company_logo=$item->company_logo?config('web.imgurl').$item->company_logo:config('web.imgurl').config('xy_default_avatar.company_logo');
                $item->time=date('Y年m月d日',strtotime($item->create_time));
                $item->InviteAninterview=InviteAninterviewModel::where(['delivery_id'=>$item['id']])
                    ->withAttr('interview_date',function($v,$data){
                        return date('Y年m月d日',$v);
                    })
                    ->withAttr('interview_start_time',function($v,$data){
                        return date('H:i',$v);
                    })
                    ->withAttr('interview_end_time',function($v,$data){
                        return date('H:i',$v);
                    })->find();
                $item->jobs_salary_show_type=config('xy_company.jobs_salary_show_type');
            });
        return $JobsDeliveryResumeModel;
    }
    public static function getCompanyJobsDeliveryResume($D=[])
    {
        $where=[];
        if (!empty($D['status'])&&$D['status']!='all'){
            $delivery=StatusAliasModel::where(['alias'=>'jobs/delivery'])
                ->field('value')
                ->select();
            foreach ($delivery as $k => $v) {
                if ('status'.$v['value']==$D['status']) {
                    $where[]=['d.status','=',$v['value']];
                    break;
                }
            }
        }
        if ((isset($D['salary_min'])&&isset($D['salary_max']))
            &&(is_numeric($D['salary_min'])&&is_numeric($D['salary_max']))) {
            if ($D['salary_min']>0&&$D['salary_max']<=100) {
                $where[]=['e.salary_min','>',0];
                $where[]=['e.salary_min','>=',intval($D['salary_min'])];
                $where[]=['e.salary_max','<=',intval($D['salary_max'])];
            }else{
                $where[]=['e.salary_min','=',0];
                $where[]=['e.salary_max','=',100];
            }
        }elseif(isset($D['salary_min'])&&is_numeric($D['salary_min'])){
            if($D['salary_min']>0){
                $where[]=['e.salary_min','>=',intval($D['salary_min'])];
            }else{
                $where[]=['e.salary_min','=',0];
                $where[]=['e.salary_max','=',100];
            }
        }elseif(isset($D['salary_max'])&&is_numeric($D['salary_min'])){
            $where[]=['e.salary_max','<=',intval($D['salary_max'])];
        }
        if (!empty($D['educational_background']))
            $where[]=['resume.educational_background','=',intval($D['educational_background'])];
        if (!empty($D['age'])) {
            switch ($D['age']) {
                case 20:
                    $where[]=['resume.age','>=',time()-3600*24*365*20];
                    break;
                case 25:
                    $where[]=['resume.age','<=',time()-3600*24*365*20];
                    $where[]=['resume.age','>=',time()-3600*24*365*25];
                    break;
                case 35:
                    $where[]=['resume.age','<=',time()-3600*24*365*25];
                    $where[]=['resume.age','>=',time()-3600*24*365*35];
                    break;
                case 45:
                    $where[]=['resume.age','<=',time()-3600*24*365*35];
                    $where[]=['resume.age','>=',time()-3600*24*365*45];
                    break;
                case 46:
                    $where[]=['resume.age','<=',time()-3600*24*365*45];
                    break;
            }
        }
        if (!empty($D['exp_level'])&&$D['exp_level']!=0) {
            $time=time();
            $yearTime=3600*24*365;
            switch ($D['exp_level']) {
                case 1:
                    $where[]=['resume.work_experience_time','between',[$time-$yearTime*4,$time-$yearTime*1]];
                    break;
                case 3:
                    $where[]=['resume.work_experience_time','between',[$time-$yearTime*6,$time-$yearTime*3]];
                    break;
                case 5:
                    $where[]=['resume.work_experience_time','between',[$time-$yearTime*11,$time-$yearTime*5]];
                    break;
                case 10:
                    $where[]=['resume.work_experience_time','<=',$time-$yearTime*10];
                    break;
            }
        }
        if (!empty($D['jobs_id']))
            $where[]=['d.jobs_id','=',$D['jobs_id']];
        if (!empty($D['app_id']))
            $where[]=['d.app_id','=',$D['app_id']];
        if (!empty($D['resume_name']))
            $where[]=['resume.name','=',$D['resume_name']];
        $JobsDeliveryResumeModel=JobsDeliveryResumeModel::alias('d')->where(['d.company_id'=>$D['company_id']])
            ->where($where)
            ->whereNull('d.company_delete_time')
            ->where(['edu.alias'=>'resume/educational_background'])
            ->join('jobs jobs','jobs.id=d.jobs_id')
            ->join('resume resume','resume.id=d.resume_id')
            ->join('resume_employment_intention e','e.resume_id=resume.id AND e.default=1','LEFT')
            ->join('status_alias edu','edu.value=resume.educational_background')
            ->order('d.id desc')
            ->field('d.id,d.resume_id,jobs.title,d.jobs_id,d.status,d.create_time,d.update_time,resume.name,resume.sex,resume.age,resume.work_experience_time,edu.title as educational_background,e.salary_min,e.salary_max')->paginate(15)
            ->each(function($item, $key)use($D){
                $create_time=date('Y年m月d日',strtotime($item['create_time']));
                $item->time=$create_time;
                $item->contacts=JobsContactsModel::where(['jobs_id'=>$item['jobs_id']])->field('contacts,contacts_mobile,contacts_tel,contacts_email,contacts_address,contacts_type')->find();
                if ($item->contacts->contacts_type)
                    $item->contacts=CompanyContentModel::where(['cid'=>$D['company_id']])->field('contacts,contacts_mobile,contacts_tel,contacts_email,contacts_address')->find();
                $item->jobs_salary_show_type=config('xy_company.jobs_salary_show_type');
            });
        return $JobsDeliveryResumeModel;
    }
    public static function getCompanyJobsDeliveryResumeFind($company_id,$where=[])
    {
        $JobsDeliveryResumeModel=JobsDeliveryResumeModel::alias('d')
            ->where($where)
            ->whereNull('d.company_delete_time')
            ->where(['edu.alias'=>'resume/educational_background'])
            ->join('jobs jobs','jobs.id=d.jobs_id')
            ->join('resume resume','resume.id=d.resume_id')
            ->join('status_alias edu','edu.value=resume.educational_background')
            ->field('d.id,d.resume_id,jobs.title,d.jobs_id,d.status,d.create_time,d.update_time,resume.name,resume.sex,resume.age,resume.work_experience_time,edu.title as educational_background')->find();
        if($JobsDeliveryResumeModel){
            $create_time=date('Y年m月d日',strtotime($JobsDeliveryResumeModel->create_time));
            $JobsDeliveryResumeModel->time=$create_time;
            $JobsDeliveryResumeModel->contacts=JobsContactsModel::where(['jobs_id'=>$JobsDeliveryResumeModel->jobs_id])->field('contacts,contacts_mobile,contacts_tel,contacts_email,contacts_address,contacts_type')->find();
            if ($JobsDeliveryResumeModel->contacts->contacts_type)
                $JobsDeliveryResumeModel->contacts=CompanyContentModel::where(['cid'=>$company_id])->field('contacts,contacts_mobile,contacts_tel,contacts_email,contacts_address')->find();
            $JobsDeliveryResumeModel->jobs_salary_show_type=config('xy_company.jobs_salary_show_type');
        }
        return $JobsDeliveryResumeModel;
    }
    public static function delDeliveryResume($D)
    {
        $where[]=['id','=',$D['id']];
        if ($D['role_type']) {
            $where[]=['company_id','=',$D['company_id']];
        }else{
            $where[]=['resume_id','=',$D['resume_id']];
        }
        $JobsDeliveryResumeModel=JobsDeliveryResumeModel::where($where)->find();
        if ($JobsDeliveryResumeModel) {
            if ($D['role_type']){
                $JobsDeliveryResumeModel->company_delete_time=time();
            }else{
                $JobsDeliveryResumeModel->personal_delete_time=time();
            }
            if ($JobsDeliveryResumeModel->save()) {
                return parent::ajaxReturn();
            }else return parent::ajaxReturn('保存失败，请重试',MsgCode::$error);
        }else return parent::ajaxReturn('投递不存在，请刷新重试',MsgCode::$error);
    }
}