<?php
namespace app\common\controller;
use think\facade\View;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\model\JobsCollection as JobsCollectionModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\StatusAlias as StatusAliasModel;

/**
 * 
 */
class JobsCollection extends Base
{
    public static function getPersonalJobsCollection($resume_id,$uid)
    {
        $Field=[
            'c.*',
            'jobs.title,jobs.update_time,jobs.create_time,jobs.salary_min,jobs.salary_max,jobs.salary_year,jobs.jobs_welfare,jobs.company_id,jobs.refresh_time,jobs.status',
            'company.title as company_name,company.stitle as scompany_name,company.logo',
            'industry.title as industry',
            'city.title as jobs_city',
            'education.title as education',
            'exp_level.title as exp_level'
        ];
        $JobsCollectionModel=JobsCollectionModel::alias('c')->where(['c.resume_id'=>$resume_id])
            ->where(['education.alias'=>'jobs/education_level'])
            ->where(['exp_level.alias'=>'jobs/exp_level'])
            ->join('jobs jobs','jobs.id=c.jobs_id')
            ->join('status_alias education','education.value=jobs.education_level')
            ->join('status_alias exp_level','exp_level.value=jobs.exp_level')
            ->join('company company','company.id=jobs.company_id')
            ->join('company_industry industry','industry.id=company.industry_id')
            ->join('area city','city.id = jobs.jobs_area2')
            ->order('c.id desc')
            ->field(implode(',',$Field))->paginate(15)
            ->each(function($item, $key)use($resume_id,$uid){
                $item->friendly_create_time=friendly_time($item['refresh_time']);
                $item->welfare=$item['jobs_welfare']?StatusAliasModel::where(['alias'=>'company/corporate_welfare'])->where('value','in',explode(',',$item['jobs_welfare']))->column('title'):[];
                $item->is_delivery=JobsDeliveryResumeModel::where(['jobs_id'=>$item->jobs_id,'resume_id'=>$resume_id])->count();
                $item->logo=$item['logo']?config('web.imgurl').$item['logo']:config('web.imgurl').config('xy_default_avatar.company_logo');
                $item->jobs_salary_show_type=config('xy_company.jobs_salary_show_type');
            });
        return $JobsCollectionModel;
    }
}