<?php
namespace app\common\controller;
use think\facade\Cookie;
use app\common\variable\MsgCode;
use app\common\model\JobFair as JobFairModel;
use app\common\model\JobFairBoothCate as JobFairBoothCateModel;
use app\common\model\JobFairBooth as JobFairBoothModel;
use app\common\model\JobFairCompany as JobFairCompanyModel;
use app\common\model\JobFairContacts as JobFairContactsModel;
use app\common\model\JobFairContent as JobFairContentModel;
use app\common\model\JobFairResume as JobFairResumeModel;
use app\common\model\JobFairVip as JobFairVipModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\JobsCollection as JobsCollectionModel;
use app\common\model\ResumeSpecialtyLabel as ResumeSpecialtyLabelModel;
use app\common\model\ResumeCollection as ResumeCollectionModel;

class JobFair extends Base
{
    public static function getList($G=[])
    {
        $where=[];
        if (!empty($G['title'])) {
            $where[]=['job.title','like','%'.$G['title'].'%'];
        }
        if (!empty($G['status'])&&$G['status']!='all') {
            $where[]=['job.status','=',$G['status']];
        }
        $DataObj=JobFairModel::alias('job')->where($where);
        if (!empty($G['city'])) {
            $DataObj->where(['content.job_fair_area2'=>$G['city']]);
        }
        $Data=$DataObj
            ->join('job_fair_content content','content.jid=job.id')
            ->join('area province','province.id = content.job_fair_area1','LEFT')
            ->join('area city','city.id = content.job_fair_area2','LEFT')
            ->join('area area','area.id = content.job_fair_area3','LEFT')
            ->field('job.*,province.title as job_fair_province,city.title as job_fair_city,area.title as job_fair_area,content.address')
            ->order('job.id desc')->paginate(10)
            ->each(function($v){
                if($v->sign_up_start_time&&$v->sign_up_end_time){
                    if($v->sign_up_start_time<=time()&&$v->sign_up_end_time>=time()){
                        $v->status=1;
                    }else{
                        $v->status=0;
                    }
                }elseif ($v->sign_up_start_time) {
                    if($v->sign_up_start_time<=time()){
                        $v->status=1;
                    }else{
                        $v->status=0;
                    }
                }elseif ($v->sign_up_end_time) {
                    if($v->sign_up_end_time>=time()){
                        $v->status=1;
                    }else{
                        $v->status=0;
                    }
                }
                if($v->start_time&&$v->end_time){
                    if($v->start_time<=time()&&$v->end_time>=time()){
                        $v->status=2;
                    }else{
                        $v->status=3;
                    }
                }
                $v->sign_up_start_time=$v['sign_up_start_time']?date('Y-m-d',$v['sign_up_start_time']):'';
                $v->sign_up_end_time=$v['sign_up_end_time']?date('Y-m-d',$v['sign_up_end_time']):'';
                $v->start_time=$v['start_time']?date('Y-m-d',$v['start_time']):'';
                $v->end_time=$v['end_time']?date('Y-m-d',$v['end_time']):'';
                $v->thumb=$v['thumb']?config('web.imgurl').$v['thumb']:'';
                $v->banner=$v['banner']?config('web.imgurl').$v['banner']:'';
            });
        return $Data;
    }
    public static function getFind($where=[])
    {
        $Find=JobFairModel::alias('job')->where($where)
            ->join('job_fair_content content','content.jid=job.id')
            ->join('area province','province.id = content.job_fair_area1','LEFT')
            ->join('area city','city.id = content.job_fair_area2','LEFT')
            ->join('area area','area.id = content.job_fair_area3','LEFT')
            ->field('job.*,content.content,content.about,province.title as job_fair_province,city.title as job_fair_city,area.title as job_fair_area,content.address,content.lng,content.lat,content.transit')
            ->order('job.id desc')->find();
        if($Find){
            if($Find->sign_up_start_time&&$Find->sign_up_end_time){
                if($Find->sign_up_start_time<=time()&&$Find->sign_up_end_time>=time()){
                    $Find->status=1;
                }else{
                    $Find->status=0;
                }
            }elseif ($Find->sign_up_start_time) {
                if($Find->sign_up_start_time<=time()){
                    $Find->status=1;
                }else{
                    $Find->status=0;
                }
            }elseif ($Find->sign_up_end_time) {
                if($Find->sign_up_end_time>=time()){
                    $Find->status=1;
                }else{
                    $Find->status=0;
                }
            }
            if($Find->start_time&&$Find->end_time){
                if($Find->start_time<=time()&&$Find->end_time>=time()){
                    $Find->status=2;
                }else{
                    $Find->status=3;
                }
            }
            $Find->sign_up_start_time=$Find['sign_up_start_time']?date('Y-m-d H:m:s',$Find['sign_up_start_time']):'';
            $Find->sign_up_end_time=$Find['sign_up_end_time']?date('Y-m-d H:m:s',$Find['sign_up_end_time']):'';
            $Find->start_time=$Find['start_time']?date('Y-m-d H:m:s',$Find['start_time']):'';
            $Find->end_time=$Find['end_time']?date('Y-m-d H:m:s',$Find['end_time']):'';
            $Find->thumb=$Find['thumb']?config('web.imgurl').$Find['thumb']:'';
            $Find->banner=$Find['banner']?config('web.imgurl').$Find['banner']:'';
            $Find->booth_img=$Find['booth_img']?config('web.imgurl').$Find['booth_img']:'';
            $Booth=[];
            $JobFairBoothCateModel=JobFairBoothCateModel::where(['jid'=>$Find->id])->select()->toArray();
            foreach ($JobFairBoothCateModel as $k => $v) {
                $Booth[$k]=$v;
                $Booth[$k]['show']=0;
                $Booth[$k]['boothCate']=JobFairBoothModel::alias('booth')->where(['booth.jid'=>$Find->id,'booth.identifier'=>$v['identifier']])
                ->join('company company','company.id=booth.company_id','LEFT')
                ->field('booth.*,company.logo,company.title,company.stitle')->select()->toArray();
            }
            $Find->booth=$Booth;
            $jobs_sum=self::getJobsSum($Find->id);
            $Find->jobs_sum=$jobs_sum;
            $view=rand(1,9);
            $viewUpdateObj=JobFairModel::where(['id'=>$Find->id])->inc('view_sum',$view);
            $Find->view_sum=$Find->view_sum+$view;
            if (!Cookie::has('JobFairPeople'.$Find->id)) {
                $viewUpdateObj->inc('view_people_sum',1);
                $Find->view_people_sum=$Find->view_people_sum+1;
                Cookie::set('JobFairPeople'.$Find->id,$Find->id);
            }
            if($Find->status!==3)
                $Find->contacts=JobFairContactsModel::where(['jid'=>$Find->id])->select();
            if($jobs_sum-$Find->jobs_sum)
            $viewUpdateObj->inc('jobs_sum',$jobs_sum-$Find->jobs_sum);
            $viewUpdateObj->update();
        }
        return $Find;
    }
    public static function getJobsSum($jid)
    {
        $company_id=self::getJobFairCompanyId($jid);
        $where=[];
        $where[]=['company_id','in',$company_id];
        $where[]=['status','=',1];
        if(config('xy_company.jobs_view_status'))
            $where[]=['examine','=',1];
        $jobs_sum=JobsModel::where($where)->count();
        return $jobs_sum;
    }
    public static function getJobFairCompanyId($jid)
    {
        return JobFairCompanyModel::where(['jid'=>$jid])->column('company_id');
    }
    public static function getJobFairCompanyBooth($company_id)
    {
        return JobFairBoothModel::alias('booth')->where(['company_id'=>$company_id])
            ->join('job_fair job','job.id=booth.jid')
            ->order('booth.lock_time desc')->field('booth.*,job.title')->paginate(10)->each(function($v){
                $v->lock_time=date('Y-m-d H:m:s',$v->lock_time);
            });
    }
    public static function getCompanyList($where)
    {
        $Field=[
            'c.id,c.title as company_name,c.stitle as scompany_name,c.logo',
            'industry.title as industry',
            'area.title as contacts_area',
            'size_type.title as size_type',
            'nature.title as nature'
        ];
        $Data=JobFairCompanyModel::alias('job')->where($where)
        ->join('job_fair_booth booth','booth.id=job.bid','LEFT')
        ->join('company c','c.id=job.company_id')
        ->where(['size_type.alias'=>'company/size_type'])
        ->where(['nature.alias'=>'company/nature'])
        ->join('user user','user.id=c.uid')
        ->join('company_content content','content.cid=c.id')
        ->join('company_industry industry','industry.id=c.industry_id')
        ->join('status_alias size_type','size_type.value=c.size_type')
        ->join('status_alias nature','nature.value=c.nature')
        ->join('area area','area.id = content.contacts_area2')
        ->orderRaw('IF(ISNULL(`job`.`bid`),1,0)')
        ->order('job.bid asc')
        ->field(implode(",",$Field))->paginate(12)
        ->each(function($item, $key){
            $item['jobs_sum']=JobsModel::where(['company_id'=>$item['id'],'status'=>1])->count();
            $item['logo']=$item['logo']?config('web.imgurl').$item['logo']:config('web.imgurl').config('xy_default_avatar.company_logo');
            return $item;
        });
        if($Data->items()){
            return parent::ajaxReturn('',MsgCode::$success,$Data);
        }else{
            return parent::ajaxReturn('',MsgCode::$error);
        }
    }
    public static function getJobsList($G)
    {
        if(empty($G['id']))
            return $this->ajaxReturn('',-100);
        $where=[];
        if (!empty($G['key']))
            $where[]=['jobs.title','like','%'.$G['key'].'%'];
        if (!empty($G['company_id'])){
            $where[]=['jobs.company_id','=',$G['company_id']];
        }else{
            $company_id=self::getJobFairCompanyId($G['id']);
            $where[]=['jobs.company_id','in',$company_id];
        }
        $Field=[
            'jobs.id,jobs.title,jobs.update_time,jobs.create_time,jobs.salary_min,jobs.salary_max,jobs.salary_year,jobs.jobs_welfare,jobs.company_id,jobs.refresh_time',
            'c.title as company_name,c.stitle as scompany_name,c.logo',
            'industry.title as industry',
            'city.title as jobs_city',
            'size_type.title as size_type',
            'education.title as education',
            'exp_level.title as exp_level'
        ];
        if(config('xy_company.jobs_view_status'))
            $where[]=['jobs.examine','=',1];
        $sort='jobs.refresh_time desc,jobs.id desc';

        $JobsModel=JobsModel::alias('jobs')
            ->where(['jobs.status'=>1,'c.attestation'=>3])
            ->whereNull('jobs.delete_time')
            ->where($where);
        $Data=$JobsModel->where(['size_type.alias'=>'company/size_type'])
            ->where(['education.alias'=>'jobs/education_level'])
            ->where(['exp_level.alias'=>'jobs/exp_level'])
            ->join('company c','c.id=jobs.company_id')
            ->join('company_industry industry','industry.id=c.industry_id')
            ->join('status_alias size_type','size_type.value=c.size_type')
            ->join('status_alias education','education.value=jobs.education_level')
            ->join('status_alias exp_level','exp_level.value=jobs.exp_level')
            ->join('area city','city.id = jobs.jobs_area2')
            ->order($sort)
            ->field(implode(',',$Field))->paginate(10)
            ->each(function($item, $key)use($G){
                $item->friendly_create_time=friendly_time($item['refresh_time']);
                $item->welfare=$item['jobs_welfare']?StatusAliasModel::where(['alias'=>'company/corporate_welfare'])->where('value','in',explode(',',$item['jobs_welfare']))->column('title'):[];
                $item->is_delivery=JobsDeliveryResumeModel::where(['jobs_id'=>$item['id'],'uid'=>$G['uid']])->count();
                if (!empty($G['resume_id']))
                    $item->is_collection=JobsCollectionModel::where(['jobs_id'=>$item['id'],'resume_id'=>$G['resume_id']])->count();
                $item->logo=$item['logo']?config('web.imgurl').$item['logo']:config('web.imgurl').config('xy_default_avatar.company_logo');
                $item->jobs_salary_show_type=config('xy_company.jobs_salary_show_type');
            });
        if($Data->items()){
            return parent::ajaxReturn('',MsgCode::$success,$Data);
        }else{
            return parent::ajaxReturn('',MsgCode::$error);
        }
    }
    public static function getResumeList($D)
    {
        $where=[];
        $sort='resume.refresh_time desc,resume.id desc';
        $Field=[
            'resume.id,resume.name,resume.sex,resume.age,resume.educational_background,resume.work_experience_time,resume.refresh_time,resume.progress,resume.headimg_status,resume.privacy',
            'e.salary_min,e.salary_max',
            'nature_of_work.title as nature_of_work',
            'job_status.title as job_status',
            'industry.title as industry',
            'province.title as job_province,city.title as job_city,area.title as job_area',
            'educational_background.title as educational_background',
            'self_description.self_description',
            'user_info.headimg'
        ];
        $where[]=['job.jid','=',$D['id']];
        if(config('xy_resume.resume_view_status'))
            $where[]=['resume.examine','=',1];
        $Data=JobFairResumeModel::alias('job')
            ->join('resume resume','resume.id=job.resume_id')
            ->where(['user.status'=>1,'resume.privacy'=>1])
            ->where($where)
            ->where(['educational_background.alias'=>'resume/educational_background'])
            ->where(['job_status.alias'=>'resume/job_status'])
            ->join('user user','user.id=resume.uid')
            ->join('user_info user_info','user_info.uid=user.id')
            ->join('resume_employment_intention e','e.resume_id=resume.id AND e.default=1','LEFT')
            ->join('resume_self_description self_description','self_description.resume_id=resume.id','LEFT')
            ->join('company_industry industry','industry.id=e.industry_id','LEFT')
            ->join('status_alias educational_background','educational_background.value=resume.educational_background','LEFT')
            ->join('status_alias nature_of_work','nature_of_work.value=e.nature_of_work AND nature_of_work.alias=\'resume/nature_of_work\'','LEFT')
            ->join('status_alias job_status','job_status.value=resume.job_status')
            ->join('area province','province.id = e.job_area1','LEFT')
            ->join('area city','city.id = e.job_area2','LEFT')
            ->join('area area','area.id = e.job_area3','LEFT')
            ->order($sort)
            ->field(implode(',',$Field))->paginate(12)
            ->each(function($item, $key)use($D){
                $name=mb_substr($item['name'],0,1,'utf-8');
                switch ($item['sex']) {
                    case 1:
                        $nickname='先生';
                        break;
                    case 2:
                        $nickname='女士';
                        break;
                }
                switch (config('xy_resume.resume_name_view')) {
                    case 1:
                        $item['name']=$name.$nickname;
                        break;
                    case 2:
                        break;
                    default:
                        if (!$item['privacy'])
                            $item['name']=$name.$nickname;
                        break;
                }
                $item['age']=getWorkExpYear($item['age']);
                $item['work_experience_time']=getWorkExpYear($item['work_experience_time']);
                $item['friendly_time']=friendly_time($item['refresh_time'],'friendly');
                $item['specialty_label']=ResumeSpecialtyLabelModel::where(['resume_id'=>$item['id']])->column('specialty_label');
                if ($item['headimg_status']) {
                    $item['headimg']=config('web.imgurl').config('xy_default_avatar.user');
                }else{
                    $item['headimg']=$item['headimg']?config('web.imgurl').$item['headimg']:config('web.imgurl').config('xy_default_avatar.user');
                }
                $item['is_collection']=0;
                if (!empty($D['company_id']))
                    $item['is_collection']=ResumeCollectionModel::where(['company_id'=>$D['company_id'],'resume_id'=>$item->id])->count();
                $item->jobs_salary_show_type=config('xy_company.jobs_salary_show_type');
                return $item;
            });
        if($Data->items()){
            return parent::ajaxReturn('',MsgCode::$success,$Data);
        }else{
            return parent::ajaxReturn('',MsgCode::$error);
        }
    }
}
