<?php
namespace app\common\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\model\InviteAninterview as InviteAninterviewModel;
use app\common\model\InviteAninterviewVideo as InviteAninterviewVideoModel;
/**
 * 
 */
class InviteAninterview extends Base
{
    public static function getInviteAninterviewList($D)
    {
        $where=[];
        $where[]=['i.company_id','=',$D['company_id']];
        if (!empty($D['jobs_id']))
            $where[]=['i.jobs_id','=',$D['jobs_id']];
        if (!empty($D['app_id']))
            $where[]=['d.app_id','=',$D['app_id']];
        if (!empty($D['resume_name']))
            $where[]=['resume.name','=',$D['resume_name']];
        $InviteAninterviewModel=InviteAninterviewModel::alias('i')
            ->where($where)
            ->where(['edu.alias'=>'resume/educational_background'])
            ->join('jobs jobs','jobs.id=i.jobs_id')
            ->join('jobs_delivery_resume d','d.id=i.delivery_id')
            ->join('company company','company.id=i.company_id')
            ->join('resume resume','resume.id=i.resume_id')
            ->join('resume_employment_intention e','e.resume_id=resume.id AND e.default=1','LEFT')
            ->join('status_alias edu','edu.value=resume.educational_background','LEFT')
            ->order('i.id desc')
            ->field('i.*,jobs.title,company.title as company_name,company.stitle as scompany_name,resume.name,resume.sex,resume.age,resume.work_experience_time,edu.title as educational_background,e.salary_min,e.salary_max')->paginate(15)
            ->each(function($item, $key){
                $item['interview_date']=date('Y年m月d日',$item['interview_date']);
                $item['interview_start_time']=date('H:i',$item['interview_start_time']);
                $item['interview_end_time']=date('H:i',$item['interview_end_time']);
                return $item;
            });
        return $InviteAninterviewModel;
    }
    public static function getInviteAninterviewVideoList($D)
    {
        $where=[];
        $where[]=['v.company_id','=',$D['company_id']];
        if (!empty($D['jobs_id']))
            $where[]=['i.jobs_id','=',$D['jobs_id']];
        if (!empty($D['app_id']))
            $where[]=['d.app_id','=',$D['app_id']];
        if (!empty($D['resume_name']))
            $where[]=['resume.name','=',$D['resume_name']];
        $InviteAninterviewVideoModel=InviteAninterviewVideoModel::alias('v')
            ->where($where)
            ->where(['edu.alias'=>'resume/educational_background'])
            ->join('invite_aninterview i','i.id=v.ia_id')
            ->join('jobs_delivery_resume d','d.id=i.delivery_id')
            ->join('jobs jobs','jobs.id=i.jobs_id')
            ->join('company company','company.id=i.company_id')
            ->join('resume resume','resume.id=i.resume_id')
            ->join('resume_employment_intention e','e.resume_id=resume.id AND e.default=1','LEFT')
            ->join('status_alias edu','edu.value=resume.educational_background')
            ->order('v.id desc')
            ->field('v.*,i.resume_id,i.contacts,i.contacts_tel,i.contacts_mobile,i.contacts_email,i.address,i.interview_date,i.interview_start_time,i.interview_end_time,i.remarks,jobs.title,company.title as company_name,company.stitle as scompany_name,resume.name,resume.sex,resume.age,resume.work_experience_time,edu.title as educational_background,e.salary_min,e.salary_max')->paginate(15)
            ->each(function($item, $key){
                $item['interview_date']=date('Y年m月d日',$item['interview_date']);
                $item['interview_start_time']=date('H:i',$item['interview_start_time']);
                $item['interview_end_time']=date('H:i',$item['interview_end_time']);
                return $item;
            });
        return $InviteAninterviewVideoModel;
    }
}