<?php
namespace app\common\controller;
use think\facade\View;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\InviteAninterview as InviteAninterviewModel;
use app\common\model\InviteOffer as InviteOfferModel;
use app\common\model\PushTask as PushTaskModel;
use app\common\model\Resume as ResumeModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\Company as CompanyModel;
/**
 * 
 */
class Interview extends Base
{
    public static function acceptInterviewInvitation($D)
    {
        $InviteAninterviewModel=InviteAninterviewModel::where(['delivery_id'=>$D['id'],'uid'=>$D['uid'],'status'=>0])->find();
        if ($InviteAninterviewModel) {
            $InviteAninterviewModel->status=1;
            $JobsDeliveryResumeModel=JobsDeliveryResumeModel::where(['id'=>$D['id'],'uid'=>$D['uid'],'status'=>3])->find();
            $JobsDeliveryResumeModel->status=4;
            // 启动事务
            Db::startTrans();
            try {
                $InviteAninterviewModel->save();
                $JobsDeliveryResumeModel->save();
                // 提交事务
                Db::commit();
                return parent::ajaxReturn('已接受');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return parent::ajaxReturn('接受失败，请重试',MsgCode::$error);
            }
        }else return parent::ajaxReturn('当前没有可接受的面试邀请',MsgCode::$error);
    }
    public static function refuseInterviewInvitation($D)
    {
        $InviteAninterviewModel=InviteAninterviewModel::where(['delivery_id'=>$D['id'],'uid'=>$D['uid'],'status'=>0])->find();
        if ($InviteAninterviewModel) {
            $InviteAninterviewModel->status=2;
            $JobsDeliveryResumeModel=JobsDeliveryResumeModel::where(['id'=>$D['id'],'uid'=>$D['uid'],'status'=>3])->find();
            $JobsDeliveryResumeModel->status=2;
            // 启动事务
            Db::startTrans();
            try {
                $InviteAninterviewModel->save();
                $JobsDeliveryResumeModel->save();
                // 提交事务
                Db::commit();
                return parent::ajaxReturn('已拒绝');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return parent::ajaxReturn('拒绝失败，请重试',MsgCode::$error);
            }
        }else return parent::ajaxReturn('当前没有可拒绝的面试邀请',MsgCode::$error);
    }
    public static function offerInterviewInvitation($D)
    {
        $InviteAninterviewModel=InviteAninterviewModel::where(['id'=>$D['id'],'company_id'=>$D['company_id']])->find();
        if ($InviteAninterviewModel) {
            $InviteAninterviewModel->status=4;
            $JobsDeliveryResumeModel=JobsDeliveryResumeModel::where(['id'=>$InviteAninterviewModel->delivery_id])->find();
            $JobsDeliveryResumeModel->status=5;
            $InviteOfferModel=new InviteOfferModel;
            $InviteOfferModel->iid=$InviteAninterviewModel->id;
            $InviteOfferModel->delivery_id=$InviteAninterviewModel->delivery_id;
            $InviteOfferModel->company_id=$InviteAninterviewModel->company_id;
            $InviteOfferModel->uid=$InviteAninterviewModel->uid;
            $InviteOfferModel->resume_id=$InviteAninterviewModel->resume_id;
            $InviteOfferModel->jobs_id=$InviteAninterviewModel->jobs_id;
            $ResumeModel=ResumeModel::where(['id'=>$InviteAninterviewModel->resume_id])->find();
            $JobsModel=JobsModel::where(['id'=>$InviteAninterviewModel->jobs_id])->find();
            $CompanyModel=CompanyModel::where(['id'=>$InviteAninterviewModel->company_id])->find();
            $PushTaskModel=new PushTaskModel;
            $PushTaskModel->event       =   'SendOffer';
            $PushTaskModel->uid         =   $ResumeModel->uid;
            $PushData=[
                'name'          =>  $ResumeModel->name,
                'jobs_name'     =>  $JobsModel->title,
                'company_name'  =>  $CompanyModel->title,
            ];
            $PushTaskModel->data        =   json_encode($PushData,JSON_UNESCAPED_UNICODE);
            // 启动事务
            Db::startTrans();
            try {
                $InviteAninterviewModel->save();
                $JobsDeliveryResumeModel->save();
                $InviteOfferModel->save();
                $PushTaskModel->save();
                // 提交事务
                Db::commit();
                return parent::ajaxReturn('已处理');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return parent::ajaxReturn('处理失败，请重试',MsgCode::$error);
            }
        }else return parent::ajaxReturn('当前没有可处理的面试邀请',MsgCode::$error);
    }
    public static function inappropriateInterviewInvitation($D)
    {
        $InviteAninterviewModel=InviteAninterviewModel::where(['id'=>$D['id'],'company_id'=>$D['company_id']])->find();
        if ($InviteAninterviewModel) {
            $InviteAninterviewModel->status=4;
            $JobsDeliveryResumeModel=JobsDeliveryResumeModel::where(['id'=>$InviteAninterviewModel->delivery_id])->find();
            $JobsDeliveryResumeModel->status=2;
            // 启动事务
            Db::startTrans();
            try {
                $InviteAninterviewModel->save();
                $JobsDeliveryResumeModel->save();
                // 提交事务
                Db::commit();
                return parent::ajaxReturn('已处理');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return parent::ajaxReturn('处理失败，请重试',MsgCode::$error);
            }
        }else return parent::ajaxReturn('当前没有可处理的面试邀请',MsgCode::$error);
    }
}