<?php
namespace app\common\controller;
use think\facade\Db;
use think\helper\Str;
use app\common\variable\MsgCode;
use app\common\model\Feedback as FeedbackModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\PushTask as PushTaskModel;
/**
 * 
 */
class Index extends Base
{
    public static function saveFeedback($D)
    {
        if (empty($D['type']))
            return parent::ajaxReturn('请选择反馈类型',MsgCode::$error);
        if (empty($D['contacts']))
            return parent::ajaxReturn('请输入联系方式',MsgCode::$error);
        if (empty($D['content']))
            return parent::ajaxReturn('请输入反馈内容',MsgCode::$error);
        $FeedbackModel=new FeedbackModel;
        $FeedbackModel->uid             =   $D['uid'];
        $FeedbackModel->type            =   $D['type'];
        $FeedbackModel->contacts        =   $D['contacts'];
        $FeedbackModel->content         =   $D['content'];
        $FeedbackModel->app_id          =   $D['app_id'];
        $FeedbackModel->alias_id        =   empty($D['alias_id'])?null:$D['alias_id'];
        $FeedbackModel->js_error        =   empty($D['js_error'])?'':json_encode($D['js_error']);
        $FeedbackModel->app_version     =   empty($D['app_version'])?'':$D['app_version'];
        $FeedbackModel->system_type     =   empty($D['system_type'])?'':$D['system_type'];
        $FeedbackModel->system_version  =   empty($D['system_version'])?'':$D['system_version'];
        $FeedbackModel->uuid            =   empty($D['uuid'])?'':$D['uuid'];
        $FeedbackModel->device_model    =   empty($D['device_model'])?'':$D['device_model'];
        $FeedbackModel->ui_mode         =   empty($D['ui_mode'])?'':$D['ui_mode'];
        $FeedbackModel->connection_type =   empty($D['connection_type'])?'':$D['connection_type'];
        $FeedbackModel->ip              =   request()->ip();
        $StatusAliasModel=StatusAliasModel::where(['alias'=>'feedback/type','value'=>$D['type']])->find();
        $AdminPushTaskModel=new PushTaskModel;
        $AdminPushTaskModel->event       =   'SystemWarning';
        switch ($D['type']) {
            case 6:
                $PushData=[
                    'tpl'       =>'report_resume',
                    'level'     =>'举报简历',
                    'range'     =>'后台',
                    'time'      =>date('Y-m-d H:i:s'),
                    'msg'       =>'举报简历ID:'.$FeedbackModel->alias_id
                ];
                break;
            case 7:
                $PushData=[
                    'tpl'       =>'report_jobs',
                    'level'     =>'举报职位',
                    'range'     =>'后台',
                    'time'      =>date('Y-m-d H:i:s'),
                    'msg'       =>'举报职位ID:'.$FeedbackModel->alias_id
                ];
                break;
            default:
                $PushData=[
                    'tpl'       =>'feedback',
                    'level'     =>'用户反馈',
                    'range'     =>'后台',
                    'time'      =>date('Y-m-d H:i:s'),
                    'msg'       =>'类型：'.$StatusAliasModel->title
                ];
                break;
        }
        $AdminPushTaskModel->data        =   json_encode($PushData,JSON_UNESCAPED_UNICODE);
        // 启动事务
        Db::startTrans();
        try {
            $FeedbackModel->save();
            $AdminPushTaskModel->save();
            // 提交事务
            Db::commit();
            return parent::ajaxReturn('提交成功，请等待管理员处理');
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return parent::ajaxReturn('提交失败，请重试',MsgCode::$error);
        }
    }
}