<?php
namespace app\common\controller;
use think\facade\Cache;
use think\facade\Session;
use think\facade\View;
use think\facade\Db;
use think\Validate;
use app\common\model\Coupon as CouponModel;
use app\common\model\CouponList as CouponListModel;
use app\common\model\StatusAlias as StatusAliasModel;
class Coupon extends Base
{
    public static function getList($D)
    {
        $where=[];
        $where[]=['list.uid','=',$D['uid']];
        if ($D['status']!='all')
            $where[]=['list.status','=',$D['status']];
        $where[]=['c.status','=',1];
        $sort='list.receive_time desc,list.end_time asc';
        $Data=CouponListModel::alias('list')->where($where)
            ->join('coupon c','c.id=list.alias_id')
            ->join('vip vip','vip.level = c.vip_level AND vip.is_company=1')
            ->field('list.alias,list.start_time,list.receive_time,list.use_time,list.end_time,list.status,c.type,c.alias_type,c.title,c.price,c.discount,c.satisfy_price,c.superposition,c.limit_sum,c.vip_level,vip.title as vip_name')
            ->order($sort)->paginate(10)
            ->each(function($v){
                $v->cate=$v->type?'折扣券':'满减券';
                $v->alias_type=json_decode($v->alias_type,true);
                $v->alias_list=StatusAliasModel::where(['alias'=>'vip/type'])->whereIn('value',$v->alias_type)->column('title');
                if($v->start_time)
                $v->start_time=date('Y-m-d H:i:s',$v->start_time);
                if($v->receive_time)
                $v->receive_time=date('Y-m-d H:i:s',$v->receive_time);
                if($v->use_time)
                $v->use_time=date('Y-m-d H:i:s',$v->use_time);
                $v->end_time=date('Y-m-d',$v->end_time);
                $v->price=(float)$v->price;
                $v->satisfy_price=(float)$v->satisfy_price;
            });
        if ($Data->items()) {
            return parent::ajaxReturn('',0,$Data);
        }else{
            return parent::ajaxReturn('暂无数据~',-100);
        }
    }
}
