<?php
namespace app\common\controller;
use app\common\model\AppVersion as AppVersionModel;
/**
 * 
 */
class Config extends Base
{
    public static function appDefaultConfig()
    {
        $IosData=AppVersionModel::where(['status'=>1,'is_ios'=>1,'wgt'=>0])->order('version_code desc')->find();
        $Data=[
            'appName'           =>  config('web.name'),
            'shareUrl'          =>  config('web.h5'),
            'wxpayStatus'       =>  config('wxpay.status'),
            'alipayStatus'      =>  config('alipay.status'),
            'downUrl'           =>  config('web.downUrl'),
            'webtel'           	=>  config('web.tel'),
            'message_address'   =>  config('xycms_message.im_address'),
            'jobs_salary_show_type'=>  config('xy_company.jobs_salary_show_type'),
            'IMKEY'             =>  config('xy_xycms.key'),
            'applepay_product_id'=>  config('applepay.product_id'),           
            'h5_map_key'=>  config('xy_map.js_key'),           
            'mp_map_key'=>  config('xy_map.wechat_key'),           
            'AppStoreUrl'       =>  $IosData?$IosData->ios_url:'',
            'xy_score'          =>  [
                'recharge_rate' =>  config('xy_score.recharge_rate'),
                'is_integer'    =>  config('xy_score.is_integer'),
                'proportion'    =>  config('xy_score.proportion'),
            ]
        ];
        return $Data;
    }
}