<?php
namespace app\common\controller;
use think\facade\View;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\model\CompanyCollection as CompanyCollectionModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\StatusAlias as StatusAliasModel;

/**
 * 
 */
class CompanyCollection extends Base
{
    public static function getPersonalCompanyCollection($resume_id)
    {
        $Field=[
            'c.*',
            'company.title as company_name,company.stitle as scompany_name,company.logo,company.corporate_welfare',
            'industry.title as industry',
            'city.title as city',
            'nature.title as nature,finance.title as finance,size_type.title as size_type'
        ];
        $CompanyCollectionModel=CompanyCollectionModel::alias('c')->where(['c.resume_id'=>$resume_id])
            ->where(['nature.alias'=>'company/nature'])
            ->where(['finance.alias'=>'company/finance'])
            ->where(['size_type.alias'=>'company/size_type'])
            ->join('company company','company.id=c.company_id')
            ->join('company_content content','content.cid=c.company_id')
            ->join('company_industry industry','industry.id=company.industry_id')
            ->join('area city','city.id = content.contacts_area2')
            ->join('status_alias nature','nature.value=company.nature')
            ->join('status_alias finance','finance.value=company.finance')
            ->join('status_alias size_type','size_type.value=company.size_type')
            ->order('c.id desc')
            ->field(implode(',',$Field))->paginate(15)
            ->each(function($item, $key){
                $item->corporate_welfare=StatusAliasModel::where([['alias','=','company/corporate_welfare'],['value','in',arrtoint(explode(",", $item->corporate_welfare))]])->column('title');
                $item->jobs_sum=JobsModel::where(['company_id'=>$item['company_id'],'status'=>1])->count();
                $item->logo=$item['logo']?config('web.imgurl').$item['logo']:config('web.imgurl').config('xy_default_avatar.company_logo');
            });
        return $CompanyCollectionModel;
    }
}