<?php
namespace app\common\controller;
use app\common\variable\MsgCode;
use think\captcha\facade\Captcha as TPCaptcha;
use helper\URL;
use geetest\CheckGeetestStatus;
use geetest\GeetestLib;
use vaptcha\Vaptcha;
use TencentCloud\Common\Credential;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Captcha\V20190722\CaptchaClient;
use TencentCloud\Captcha\V20190722\Models\DescribeCaptchaResultRequest;
/**
 * 
 */
class Captcha extends Base
{
    public static function captcha_check($D)
    {
        switch (config('captcha.type')) {
            case 1:
                if(empty($D['geetest']))
                    return false;
                if(empty($D['geetest'][GeetestLib::GEETEST_CHALLENGE]))
                    return false;
                if(empty($D['geetest'][GeetestLib::GEETEST_VALIDATE]))
                    return false;
                if(empty($D['geetest'][GeetestLib::GEETEST_SECCODE]))
                    return false;
                $gtLib = new GeetestLib(config('xy_geetest.id'), config('xy_geetest.key'));
                $challenge = $D['geetest'][GeetestLib::GEETEST_CHALLENGE];
                $validate = $D['geetest'][GeetestLib::GEETEST_VALIDATE];
                $seccode = $D['geetest'][GeetestLib::GEETEST_SECCODE];
                $result = null;
                if (CheckGeetestStatus::getGeetestStatus()) {
                    $result = $gtLib->successValidate($challenge, $validate, $seccode, null);
                } else {
                    $result = $gtLib->failValidate($challenge, $validate, $seccode);
                }
                // 注意，不要更改返回的结构和值类型
                if ($result->getStatus() === 1) {
                    return true;
                } else {
                    return true;
                }
            case 2:
                if(empty($D['vaptcha']))
                    return false;
                try {
                    $ret=json_decode(Vaptcha::validate($D['vaptcha']),true);
                    if (!empty($ret['success'])&&$ret['success']==1)
                        return true;
                } catch (Exception $e) {
                    
                }
                return false;
            case 3:
                break;
            case 4:
                if(empty($D['tsec']))
                    return false;
                if(empty($D['tsec']['appid']))
                    return false;
                if(empty($D['tsec']['ticket']))
                    return false;
                if(empty($D['tsec']['randstr']))
                    return false;
                try {
                    $cred = new Credential(config('xy_tencent_tsec.SecretId'), config('xy_tencent_tsec.SecretKey'));
                    $httpProfile = new HttpProfile();
                    $httpProfile->setEndpoint("captcha.tencentcloudapi.com");
                    $clientProfile = new ClientProfile();
                    $clientProfile->setHttpProfile($httpProfile);
                    $client = new CaptchaClient($cred, "", $clientProfile);
                    $req = new DescribeCaptchaResultRequest();
                    $params = [
                        "CaptchaType" => 9,
                        "Ticket" => $D['tsec']['ticket'],
                        "UserIp" => request()->ip(),
                        "Randstr" => $D['tsec']['randstr'],
                        "CaptchaAppId" => config('xy_tencent_tsec.appid'),
                        "AppSecretKey" => config('xy_tencent_tsec.sk')
                    ];
                    $req->fromJsonString(json_encode($params));
                    $resp = $client->DescribeCaptchaResult($req);
                    if($resp->CaptchaCode==1)
                        return true;
                } catch(TencentCloudSDKException $e) {
                }
                return false;
            default:
                return captcha_check($D['imgcode']);
        }
    }
    public static function captcha()
    {
        switch (config('captcha.type')) {
            case 1:
                $gtLib = new GeetestLib(config('xy_geetest.id'), config('xy_geetest.key'));
                $userId = "test";
                $digestmod = "md5";
                $params = [
                    "digestmod" => $digestmod,
                    "user_id" => $userId,
                    "client_type" => "web",
                    "ip_address" => "127.0.0.1"
                ];
                if(CheckGeetestStatus::getGeetestStatus()){
                    $result = $gtLib->register($digestmod, $params);
                }else{
                    $result = $gtLib->localInit();
                }
                // 注意，不要更改返回的结构和值类型
                return response($result->getData())->header(['Content-Type' => 'application/json;charset=UTF-8']);
            case 2:
                break;
            case 3:
                break;
            case 4:
                break;
            default:
                return TPCaptcha::create(); 
        }   
    }
}