<?php
namespace app\common\controller;
use app\common\variable\MsgCode;
use app\common\model\School as SchoolModel;
use app\common\model\Specialities as SpecialitiesModel;
use app\common\model\CompanyView as CompanyViewModel;
use app\bsadmin\model\ApiApp as ApiAppModel;
class Ajax extends Base
{
    public static function get($type,$G)
    {
        switch ($type) {
            case 'getSpecialities':
                return self::getSpecialities($G);
            case 'getSchool':
                return self::getSchool($G);
            case 'getClientApp':
                return self::getClientApp();
            case 'charts_statistics':
                return self::getChartsStatistics($G);
        }
    }
    public static function getSpecialities($G)
    {
        $where=[];
        $where[]=['specialities','like','%'.$G['key'].'%'];
        $SpecialitiesModel=SpecialitiesModel::where($where)->field('specialities as value')->limit(100)->select();
        if (!$SpecialitiesModel->isEmpty()) {
            return parent::ajaxReturn('',MsgCode::$success,$SpecialitiesModel);
        }else{
            return parent::ajaxReturn('',MsgCode::$error);
        }
    }
    public static function getSchool($G)
    {
        $where=[];
        $where[]=['school_name','like','%'.$G['key'].'%'];
        $SchoolModel=SchoolModel::where($where)->field('school_name as value')->limit(100)->select();
        if (!$SchoolModel->isEmpty()) {
            return parent::ajaxReturn('',MsgCode::$success,$SchoolModel);
        }else{
            return parent::ajaxReturn('',MsgCode::$error);
        }
    }
    public static function getClientApp()
    {
        $ApiAppModel=ApiAppModel::where('app_modul','in',['index','appapiv1','mobile','wechatminiprogram'])->field('app_id,app_name')->select();
        return parent::ajaxReturn('',MsgCode::$success,$ApiAppModel);
    }
    public static function getChartsStatistics($G)
    {
        if(empty($G['company_id']))
            return parent::ajaxReturn('',MsgCode::$error);
        $time=0;
        switch (intval($G['key'])) {
            case 1:
                $time=time()-3600*24*7;
                break;
            case 2:
                $time=time()-3600*24*15;
                break;
            case 3:
                $time=time()-3600*24*30;
                break;
        }
        $StatisticsModel=CompanyViewModel::where(['company_id'=>$G['company_id']])->whereTime('create_time', '>=',$time)->withoutField('id,company_id')->order('create_time asc')->select();
        $Statistics=[];
        $time=[];
        $series=[];
        $legend=['总浏览', '注册用户', '个人用户', '企业用户'];
        if(!$StatisticsModel->isEmpty()){
            foreach ($StatisticsModel as $item) {
                $Statistics[0][]=$item->view;
                $Statistics[1][]=$item->user_view;
                $Statistics[2][]=$item->personal_view;
                $Statistics[3][]=$item->company_view;
                $time[]=date('m-d',strtotime($item->create_time));
            }
            foreach ($legend as $k => $v) {
                $series[]=[
                    'type'  =>'line',
                    'data'  =>$Statistics[$k],
                    'name'  =>$v,
                ];
            }
        }
        $Data=[
            'time'      =>  $time,
            'legend'    =>  $legend,
            'series'    =>  $series,
        ];
        return parent::ajaxReturn('',MsgCode::$success,$Data);
    }
}
