<?php
namespace app\common\controller;
use think\facade\View;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\model\Ads as AdsModel;
use app\common\model\AdsPosition as AdsPositionModel;
/**
 * 
 */
class Ads extends Base
{
    public static function getSelect($alias,$length)
    {
        $whereSubSiteSql='';
        $whereSubSite=[];
        if (isset(request()->sub_province)){
            if (config('xy_sub_website.data_is_all'))
                $whereSubSite[]='province IS NULL';
            $whereSubSite[]='province = '.request()->sub_province;
        }
        if (isset(request()->sub_city)){
            if (config('xy_sub_website.data_is_all'))
                $whereSubSite[]='city IS NULL';
            $whereSubSite[]='city = '.request()->sub_city;
        }
        if (isset(request()->sub_area)){
            if (config('xy_sub_website.data_is_all'))
                $whereSubSite[]='area IS NULL';
            $whereSubSite[]='area = '.request()->sub_area;
        }
        if (isset(request()->sub_industry)){
            if (config('xy_sub_website.data_is_all'))
                $whereSubSite[]='industry IS NULL';
            $whereSubSite[]='industry = '.request()->sub_industry;
        }
        if(!empty($whereSubSite))
            $whereSubSiteSql=implode(' OR ', $whereSubSite);
        $now=time();
        $whreTime='(`start_time` IS NULL AND `end_time` IS NULL)  OR (`start_time` < '.$now.' AND `end_time` IS NULL)  OR (`start_time` IS NULL AND `end_time` > '.$now.')  OR (`start_time` < '.$now.' AND `end_time` > '.$now.')';
        $app_id=request()->ApiInfo['app_id'];
        $AdsPositionModel=AdsPositionModel::where(['app_id'=>$app_id,'alias'=>$alias,'status'=>1])->whereRaw($whreTime)->find();
        if ($AdsPositionModel) {
            $AdsModelObj=AdsModel::where(['pid'=>$AdsPositionModel->id,'status'=>1]);
            if ($whereSubSiteSql)
                $AdsModelObj->whereRaw($whereSubSiteSql);
            $AdsModel=$AdsModelObj->whereRaw($whreTime)->limit($length)->order('sort asc,id desc')->field('title,path,url,url as imgurl,ads_icon,col')->withAttr('imgurl',function($v){
                return config('web.imgurl');
            })->select();
            return $AdsModel->toArray();
        }else{
            return [];
        }
    }
}