<?php
use helper\Time;
// 应用公共文件
function p($d)
{
	echo "<pre>";
	print_r($d);
	echo "</pre>";
}
/**
 * 递归实现无限极分类
 * @param $array 分类数据
 * @param $pid 父ID
 * @param $level 分类级别
 * @return $list 分好类的数组 直接遍历即可 $level可以用来遍历缩进
 */

function getTree($array,$id='id',$pid='pid',$key='data'){
    //第一步 构造数据
    $items = array();
    foreach($array as $value){
        $items[$value[$id]] = $value;
    }
    //第二部 遍历数据 生成树状结构
    $tree = array();
    foreach($items as $k => $value){
        if(isset($items[$value[$pid]])){
        	if (!isset($items[$value[$pid]][$key])) {
        		$items[$value[$pid]][$key]=[];
        	}
            $items[$value[$pid]][$key][] = &$items[$k];
        }else{
            if(!$value[$pid]){
                $tree[] = &$items[$k];
            }else{
                unset($items[$k]);
            }
        }
    }
    return $tree;
}
/**
 * 生成随机数
 * @param $sum 位数
 * @return 随机随机数
 */
function GetRand($sum = 6)
{
    $rand = '';
    for ($i = 1;$i<=$sum;$i++)
    {
        $rand .= rand(0,9);
    }
    return $rand;
}
/**
 * 验证中文姓名
 * @param $name 姓名
 * @return 
 */
function checkTrueName($name='')
{
    if (!preg_match('/^[\x{4e00}-\x{9fa5}]+[·•]?[\x{4e00}-\x{9fa5}]+$/u', $name)) {
        return false;
    }
    $strLen = mb_strlen($name);
    if ($strLen < 2 || $strLen > 20) {
        return false;
    }
 
    return true;
}
/**
 * 删除字符串中空格
 * @param $str 字符串
 * @return 无空格字符串
 */
function trimall($str)
{
    $qian=array(" ","　","\t","\n","\r");
    $hou=array("","","","","");
    return str_replace($qian,$hou,$str); 
}
function formatFileSize($size=0)
{
    $type=['K','KB','MB','GB','TB'];
    $i=0;
    while ($size>1024) {
        $i++;
        $size=$size/1024;
    }
    return round($size).$type[$i];
}
function arrtoint($data=[],$key='')
{
    foreach ($data as $k => $v) {
        if ($key) {
            if (is_numeric($v[$key])) {
                $data[$k][$key]=(float) $v[$key];
            }else{
                $data[$k][$key]=$v[$key];
            }
        }else{
            if (is_numeric($v)) {
                $data[$k]=(float) $v;
            }else{
                $data[$k]=$v;
            }
        }
    }
    return $data;
}
function default_str($str,$default)
{
    if ($str) {
        return $str;
    }else{
        return $default;
    }
}
function friendly_time($time='',$type='basic')
{
    if (!is_numeric($time)) {
        $time=strtotime($time);
    }
    if ($time) {
        if ($type=='friendly') {
            list($todayStart, $todayEnd) = Time::today();
            list($yesterdayStart, $yesterdayEnd) = Time::yesterday();
            list($day7Start, $day7End) = Time::dayToNow(7);
            list($monthStart, $monthEnd) = Time::month();
            list($yearStart, $yearEnd) = Time::year();
            switch (true) {
                case $time>time()-300:
                    $text='刚刚';
                    break;
                case $time>time()-3600:
                    $text='一小时内';
                    break;
                case $time>$todayStart:
                    $text='今日 '.date('H:i',$time);
                    break;
                case $time>$yesterdayStart && $time<$yesterdayEnd:
                    $text='昨日'.date('H:i',$time);
                    break;
                case $time>$day7Start && $time<$day7End:
                    $text='一周内';
                    break;
                case $time>$monthStart && $time<$monthEnd:
                    $text=date('m月d日',$time);
                    break;
                case $time>$yearStart && $time<$yearEnd:
                    $text=date('m月d日',$time);
                    break;
                default:
                    $text=date('Y年m月d日',$time);
                    break;
            }
            return $text;
        }else{
            if (date('Y',$time)==date('Y')) {
                return date('m月d日',$time);
            }else{
                return date('Y年m月d日',$time);
            }
        }
    }else return '';
}
function getWorkExpYear($time=0)
{
    if ($time) {
        return floor((time()-$time)/(3600*24*365));
    }else return 0;
}
function removePHPStr($str='')
{
    if ($str)
        return str_replace(['/','&'],'_',$str);
    return $str;
}
function substr_cut($str='',$start='{',$end='}')
{
    if(!$str) return $str;
    $start_index= (strpos($str,$start));
    $end_index= (strpos($str,$end));
    if ($start_index===false||$end_index===false)
        return false;
    return substr($str,$start_index+1,$end_index-1);
}
function getTimeIntervaText($time=0)
{
    $arr=[
        ['title'=>'深夜','max'=>21],
        ['title'=>'晚上','max'=>17],
        ['title'=>'下午','max'=>13],
        ['title'=>'中午','max'=>11],
        ['title'=>'上午','max'=>8],
        ['title'=>'早上','max'=>6],
        ['title'=>'凌晨','max'=>0],
    ];
    if ($time) {
        $time=intval(date('H',$time));
    }else{
        $time=intval(date('H'));
    }
    foreach ($arr as $k => $v)
        if ($time>=$v['max']) return $v['title'];
}
function socketMsg($type,$data=[])
{
    $D=[
        'type'      =>  $type,
        'data'      =>  $data
    ];
    return json_encode($D);
}
function formatTime($time)
{
    if(is_numeric($time)){
        $years=0;
        $days=0;
        $hours=0;
        $minutes=0;
        $seconds=0;
        if($time >= 31556926){
          $years = floor($time/31556926);
          $time = ($time%31556926);
        }
        if($time >= 86400){
          $days = floor($time/86400);
          $time = ($time%86400);
        }
        if($time >= 3600){
          $hours = floor($time/3600);
          $time = ($time%3600);
        }
        if($time >= 60){
          $minutes = floor($time/60);
          $time = ($time%60);
        }
        $value["seconds"] = floor($time);
        $t='';
        $years>0&&$t=$years."年";
        $days>0&&$t.=$days."天";
        $hours>0&&$t.=$hours."小时";
        $minutes>0&&$t.=$minutes."分钟";
        $seconds>0&&$t.=$seconds."秒";
        return $t;
    }else{
        return '';
    }
}
/**
 * 二维数组根据某个字段排序
 * @param array $array 要排序的数组
 * @param string $keys   要排序的键字段
 * @param string $sort  排序类型  SORT_ASC     SORT_DESC 
 * @return array 排序后的数组
 */
function arraySort($array, $keys, $sort = SORT_DESC) {
    $keysValue = [];
    foreach ($array as $k => $v) {
        $keysValue[$k] = $v[$keys];
    }
    array_multisort($keysValue, $sort, $array);
    return $array;
}
function fromRobot($except = '') {
   $ua = strtolower ( $_SERVER ['HTTP_USER_AGENT'] );
   $botchar = "/(baidu|google|spider|soso|yahoo|sohu-search|yodao|robozilla|AhrefsBot)/i";
   $except ? $botchar = str_replace ( $except . '|', '', $botchar ) : '';
   if (preg_match ( $botchar, $ua )) {
      return true;
   }
   return false;
}
function htmltostring($html){
    if($html){
        //把一些预定义的 HTML 实体转换为字符
        $html_string = htmlspecialchars_decode($html);
        //函数剥去字符串中的 HTML、XML 以及 PHP 的标签,获取纯文本内容
        return strip_tags($html_string);
    }else{
        return $html;
    }
}