<?php
use think\facade\Route;
//无权访问
Route::rule('/unauthorized','bsadmin/Login/unauthorized');
//验证码
Route::rule('/captcha','bsadmin/Login/captcha');
//登录
Route::rule('/login','bsadmin/Login/index');
//数据概览
Route::get('/','bsadmin/Index/index');
//权限列表
Route::rule('auth','bsadmin/Auth/index');
//添加权限
Route::rule('addAuth','bsadmin/Auth/addAuth');
//更改权限状态
Route::get('setAuthStatus/:id/:status','bsadmin/Auth/setAuthStatus');
//更改权限是否显示
Route::get('setAuthShow/:id/:show','bsadmin/Auth/setAuthShow');
//角色列表
Route::rule('role','bsadmin/Role/index');
//添加角色
Route::rule('addRole','bsadmin/Role/addRole');
//编辑角色
Route::rule('editRole/:id','bsadmin/Role/editRole');
//删除角色
Route::rule('delRole/:id','bsadmin/Role/delRole');
//管理员列表
Route::rule('admin','bsadmin/Admin/index');
//添加管理员
Route::rule('addAdmin','bsadmin/Admin/addAdmin');
//编辑管理员
Route::rule('editAdmin/:id','bsadmin/Admin/editAdmin');
//设置管理员状态
Route::get('setAdminStatus/:id/:status','bsadmin/Admin/setAdminStatus');
//编辑权限
Route::rule('editAuth/:id','bsadmin/Auth/editAuth');
//异步更新权限
Route::rule('updateRouteFileAjax','bsadmin/Auth/updateRouteFileAjax');
//退出登录
Route::get('outLogin','bsadmin/Base/outLogin');
//获取管理员日志
Route::get('getAdminLog','bsadmin/Admin/getAdminLog');
//异步更新角色缓存
Route::rule('updateRoleFileAjax/[:id]','bsadmin/Role/updateRoleFileAjax');
//基础配置
Route::rule('setting/basic','bsadmin/Setting/basic');
//域名配置
Route::rule('setting/web','bsadmin/Setting/web');
//添加配置
Route::rule('setting/add','bsadmin/Setting/add');
//上传文件
Route::rule('uploadFiles','bsadmin/Publics/uploads');
//编辑配置
Route::post('setting/edit','bsadmin/Setting/editConfig');
//文件列表
Route::rule('files','bsadmin/Files/index');
//上传文件
Route::rule('files/uploads','bsadmin/Files/uploads');
//分类列表
Route::rule('article/cate','bsadmin/Article/cate');
//添加分类
Route::rule('article/addCate','bsadmin/Article/addCate');
//文章列表
Route::rule('article','bsadmin/Article/index');
//发布文章
Route::rule('addArticle','bsadmin/Article/addArticle');
//设置文章状态
Route::rule('setArticleStatus/:id/:status','bsadmin/Article/setArticleStatus');
//编辑分类
Route::rule('article/editCate/:id','bsadmin/Article/editCate');
//编辑文章
Route::rule('editArticle/:id','bsadmin/Article/editArticle');
//获取编辑器配置
Route::rule('ueditor/getConfig','bsadmin/Ueditor/getConfig');
//企业列表
Route::rule('company','bsadmin/Company/index');
//职位列表
Route::rule('jobs','bsadmin/Jobs/index');
//企业相册
Route::rule('company/demeanor','bsadmin/Company/demeanor');
//企业设置
Route::rule('company/setting','bsadmin/Company/setting');
//用户列表
Route::rule('user','bsadmin/User/index');
//设置权限排序
Route::rule('setAuthSort/:id/:sort','bsadmin/Auth/setAuthSort');
//获取用户信息
Route::rule('getUserInfo/:id','bsadmin/User/getUserInfo');
//微信用户
Route::rule('wxUser','bsadmin/User/wxUser');
//手动添加企业
Route::rule('company/addCompany','bsadmin/Company/addCompany');
//判断用户是否存在
Route::post('hasUser','bsadmin/User/hasUser');
//编辑企业
Route::rule('company/editCompany/:id','bsadmin/Company/editCompany');
//获取企业信息
Route::get('getCompanyInfo/:id','bsadmin/Company/getCompanyInfo');
//添加职位分类
Route::rule('jobs/addCate','bsadmin/Jobs/addJobsCate');
//职位分类列表
Route::rule('jobs/cate','bsadmin/Jobs/cate');
//编辑职位分类
Route::rule('jobs/editCate/:id','bsadmin/Jobs/editJobsCate');
//简历列表
Route::rule('resume','bsadmin/Resume/index');
//删除分类
Route::rule('article/delCate/:id','bsadmin/Article/delCate');
//应用
Route::rule('client/app','bsadmin/Client/index');
//添加应用
Route::rule('client/addApp','bsadmin/Client/addApp');
//编辑应用
Route::rule('client/editApp/:id','bsadmin/Client/editApp');
//设置应用状态
Route::rule('client/setAppStatus/:id/:status/[:msg]','bsadmin/Client/setAppStatus');
//添加API
Route::rule('client/addApi/:id','bsadmin/Client/addApi');
//编辑API
Route::rule('client/editApi/:id','bsadmin/Client/editApi');
//设置Api状态
Route::rule('client/setApiStatus/:id/:status/[:msg]','bsadmin/Client/setApiStatus');
//设置API跨域
Route::rule('client/setApiAllow/:id/:status','bsadmin/Client/setApiAllow');
//异步更新缓存
Route::rule('client/updateApiCacheAjax/[:id]','bsadmin/Client/updateApiCacheAjax');
//更新应用KEY
Route::rule('client/updateAppKeyAjax/:id','bsadmin/Client/updateAppKeyAjax');
//设置Api是否需要登录
Route::rule('client/setApiIsLogin/:id/:status','bsadmin/Client/setApiIsLogin');
//短信限制
Route::rule('setting/sms','bsadmin/Setting/sms');
//广告位
Route::get('ads/position','bsadmin/Ads/adsPosition');
//创建广告位
Route::rule('ads/addPosition','bsadmin/Ads/addAdsPosition');
//编辑广告位
Route::rule('ads/editPosition/:id','bsadmin/Ads/editAdsPosition');
//编辑广告位状态
Route::get('ads/setAdsPositionStatus/:id/:status','bsadmin/Ads/setAdsPositionStatus');
//删除广告位
Route::get('ads/delPosition/:id','bsadmin/Ads/delAdsPosition');
//添加广告图片
Route::rule('ads/add/:id','bsadmin/Ads/add');
//编辑广告图片
Route::rule('ads/edit/:id','bsadmin/Ads/edit');
//编辑广告图片状态
Route::get('ads/setAdsStatus/:id/:status','bsadmin/Ads/setAdsStatus');
//删除广告图片
Route::get('ads/del/:id','bsadmin/Ads/del');
//链接列表
Route::get('links','bsadmin/Links/index');
//创建链接
Route::rule('links/add','bsadmin/Links/add');
//编辑链接
Route::rule('links/edit/:id','bsadmin/Links/edit');
//设置链接状态
Route::get('links/setStatus/:id/:status','bsadmin/Links/setStatus');
//删除链接
Route::get('links/del/:id','bsadmin/Links/del');
//地区列表
Route::rule('area','bsadmin/Area/index');
//添加地区
Route::rule('area/add','bsadmin/Area/add');
//编辑地区
Route::rule('area/edit/:id','bsadmin/Area/edit');
//设置地区状态
Route::rule('area/setAreaStatus/:id/:status','bsadmin/Area/setAreaStatus');
//缓存地区
Route::rule('area/updateFileAjax','bsadmin/Area/updateFileAjax');
//设置地区为热门
Route::get('area/setAreaHot/:id/:status','bsadmin/Area/setAreaHot');
//审核企业风采
Route::rule('company/demeanor/setStatus/:id/:status','bsadmin/Company/setCompanyDemeanor');
//企业认证
Route::rule('company/attestation','bsadmin/Company/companyAttestation');
//企业认证申请
Route::rule('company/attestation/setStatus/:id/:status/[:msg]','bsadmin/Company/setCompanyAttestationStatus');
//导航栏
Route::rule('menu','bsadmin/Menu/index');
//添加导航栏
Route::rule('menu/add','bsadmin/Menu/add');
//编辑导航栏
Route::rule('menu/edit/:id','bsadmin/Menu/edit');
//设置导航栏状态
Route::get('menu/setStatus/:id/:status','bsadmin/Menu/setStatus');
//删除导航栏
Route::get('menu/del/:id','bsadmin/Menu/del');
//更新导航缓存
Route::get('menu/updateFileAjax','bsadmin/Menu/updateFileAjax');
//主套餐
Route::rule('vip','bsadmin/Vip/index');
//增值套餐
Route::rule('vip/value-added','bsadmin/Vip/valueAdded');
//添加套餐
Route::rule('vip/add','bsadmin/Vip/add');
//编辑套餐
Route::rule('vip/edit/:id','bsadmin/Vip/edit');
//设置套餐状态
Route::get('vip/setStatus/:id/:status','bsadmin/Vip/setStatus');
//添加增值服务
Route::rule('vip/addValueAdded','bsadmin/Vip/addValueAdded');
//编辑增值服务
Route::rule('vip/editValueAdded/:id','bsadmin/Vip/editValueAdded');
//设置增值服务状态
Route::get('vip/setValueAddedStatus/:id/:status','bsadmin/Vip/setValueAddedStatus');
//套餐规则
Route::rule('vip/rule','bsadmin/Vip/vipRule');
//添加套餐规则
Route::rule('vip/addVipRule','bsadmin/Vip/addVipRule');
//编辑套餐规则
Route::rule('vip/editVipRule/:id','bsadmin/Vip/editVipRule');
//设置套餐规则状态
Route::get('vip/setVipRuleStatus/:id/:status','bsadmin/Vip/setVipRuleStatus');
//支付宝支付
Route::rule('setting/alipay','bsadmin/Setting/alipay');
//微信支付
Route::rule('setting/wxpay','bsadmin/Setting/wxpay');
//全部订单
Route::rule('orders','bsadmin/Orders/index');
//查看支付信息
Route::rule('orders/getPayInfo/:pay_type/:otrade','bsadmin/Orders/getPayInfo');
//QQ登录
Route::rule('setting/qqlogin','bsadmin/Setting/qqlogin');
//微信登录
Route::rule('setting/wxlogin','bsadmin/Setting/wxlogin');
//推送配置
Route::rule('message/setConfig','bsadmin/Message/setMessage');
//积分配置
Route::rule('score/set','bsadmin/Score/set');
//积分任务
Route::rule('score/task','bsadmin/Score/task');
//创建积分任务
Route::rule('score/add','bsadmin/Score/add');
//编辑积分任务
Route::rule('score/edit/:id','bsadmin/Score/edit');
//设置积分任务状态
Route::rule('score/setStatus/:id/:status','bsadmin/Score/setStatus');
//面试邀请记录
Route::rule('jobs/inviteAnInterview','bsadmin/Jobs/inviteAnInterview');
//简历下载记录
Route::rule('resume/resume-downloaded','bsadmin/Resume/downloadResumeLog');
//行为日志
Route::rule('user/apiLog','bsadmin/User/userApiLog');
//登录日志
Route::rule('user/loginLog','bsadmin/User/userLoginLog');
//作品附件
Route::rule('resume/works','bsadmin/Resume/works');
//审核作品附件
Route::rule('resume/works/setStatus/:id/:status','bsadmin/Resume/setResumeWorksStatus');
//个人设置
Route::rule('resume/setting','bsadmin/Resume/setting');
//站内信
Route::rule('message','bsadmin/Message/index');
//新建队列
Route::rule('message/send','bsadmin/Message/sendMessage');
//获取消息内容
Route::rule('message/getMessageContent/:id','bsadmin/Message/getMessageContent');
//设置消息状态
Route::rule('message/setStatus/:id/:status','bsadmin/Message/setStatus');
//设置消息已读
Route::rule('message/setIsRead/:id/:is_read','bsadmin/Message/setIsRead');
//队列列表
Route::rule('message/queueList','bsadmin/Message/queueList');
//推送列表
Route::rule('message/pushList','bsadmin/Message/pushList');
//搜索用户
Route::get('user/searchUser','bsadmin/User/searchUser');
//委托列表
Route::rule('resume/consignment','bsadmin/Resume/consignment');
//委托匹配
Route::rule('resume/matching/:resume_id','bsadmin/Resume/matching');
//投递简历
Route::rule('resume/deliveryResume/:resume_id/:id','bsadmin/Resume/deliveryResume');
//取消委托
Route::rule('resume/cancelConsignment/:id','bsadmin/Resume/cancelConsignment');
//发票列表
Route::rule('invoice','bsadmin/Invoice/index');
//发票设置
Route::rule('invoice/setting','bsadmin/Invoice/setting');
//处理发票
Route::post('invoice/setStatus','bsadmin/Invoice/setStatus');
//SMTP邮件
Route::rule('setting/email','bsadmin/Setting/email');
//地图设置
Route::rule('setting/map','bsadmin/Setting/map');
//对象存储
Route::rule('setting/oss','bsadmin/Setting/oss');
//反馈列表
Route::rule('feedback','bsadmin/Feedback/index');
//处理用户反馈
Route::get('feedback/setStatus/:id/:status','bsadmin/Feedback/setStatus');
//反馈回复
Route::post('feedback/reply','bsadmin/Feedback/reply');
//菜单栏
Route::rule('wechat/menu','bsadmin/Wechat/menu');
//菜单栏保存
Route::post('wechat/saveMenu','bsadmin/Wechat/saveMenu');
//发布菜单栏
Route::get('wechat/releaseMenu','bsadmin/Wechat/releaseMenu');
//关键词回复
Route::rule('wechat/keywords','bsadmin/Wechat/keywords');
//设置关键词状态
Route::get('wechat/setKeywordsStatus/:id/:status','bsadmin/Wechat/setKeywordsStatus');
//添加关键词
Route::rule('wechat/addKeywords','bsadmin/Wechat/addKeywords');
//删除关键词
Route::get('wechat/delKeywords/:id','bsadmin/Wechat/delKeywords');
//公众号模板
Route::rule('wechat/pushTpl','bsadmin/Wechat/pushTpl');
//添加公众号模板
Route::rule('wechat/addPushTpl','bsadmin/Wechat/addPushTpl');
//编辑公众号模板
Route::rule('wechat/editPushTpl/:id','bsadmin/Wechat/editPushTpl');
//设置公众号模板状态
Route::get('wechat/setPushTplStatus/:id/:status','bsadmin/Wechat/setPushTplStatus');
//公众号配置
Route::rule('setting/wechatMp','bsadmin/Setting/wechatMp');
//编辑关键词
Route::rule('wechat/editKeywords/:id','bsadmin/Wechat/editKeywords');
//设置默认关键词
Route::rule('wechat/setKeywordsDefault/:id/:default','bsadmin/Wechat/setKeywordsDefault');
//异步缓存职位分类
Route::get('jobs/cate/setCacheJobsCate','bsadmin/Jobs/setCacheJobsCate');
//异步缓存友情链接
Route::get('links/cacheLink','bsadmin/Links/cacheLink');
//新云Cloud
Route::rule('setting/xycms','bsadmin/Setting/xycms');
//苹果支付
Route::rule('setting/applepay','bsadmin/Setting/applepay');
//获取苹果支付项目
Route::rule('getApplePayProductList','bsadmin/Setting/getApplePayProductList');
//微信小程序
Route::rule('setting/wechatminiprogram','bsadmin/Setting/wechatminiprogram');
//上传配置
Route::rule('setting/upconfig','bsadmin/Setting/upconfig');
//APP配置
Route::rule('setting/appConfig','bsadmin/Client/appConfig');
//APP版本
Route::rule('client/app/version','bsadmin/Client/appVersion');
//H5配置
Route::rule('setting/h5Config','bsadmin/Client/h5Config');
//头条小程序
Route::rule('setting/toutiao','bsadmin/Setting/toutiao');
//更新APP版本
Route::rule('client/app/add_version','bsadmin/Client/addAppVersion');
//删除更新
Route::get('client/app/del_version/:id','bsadmin/Client/delAppVersion');
//设置APP更新状态
Route::get('client/app/setVersionStatus/:id/:status','bsadmin/Client/setAppVersionStatus');
//设置APP强制更新状态
Route::get('client/app/setVersionForce/:id/:status','bsadmin/Client/setAppVersionForce');
//聊天设置
Route::rule('setting/im_setting','bsadmin/Setting/im_setting');
//QQ用户
Route::rule('qqUser','bsadmin/User/qqUser');
//协议
Route::rule('article/agreement','bsadmin/Article/agreement');
//单页
Route::rule('article/publics','bsadmin/Article/publicsArticle');
//公告
Route::rule('article/notice','bsadmin/Article/notice');
//职位投诉
Route::rule('jobs/complaints','bsadmin/Jobs/job_complaints');
//简历投诉
Route::rule('resume/complaints','bsadmin/Resume/resume_complaints');
//设置广告标识符
Route::get('ads/setAdsIcon/:id/:status','bsadmin/Ads/setAdsIcon');
//免登录跳转
Route::rule('user/exemptLoginRedirect/:uid','bsadmin/User/exemptLoginRedirect');
//极验
Route::rule('setting/geetest','bsadmin/Setting/geetest');
//验证码
Route::rule('setting/captcha','bsadmin/Setting/captcha');
//VAPTCHA手势验证
Route::rule('setting/vaptcha','bsadmin/Setting/vaptcha');
//T-Sec 天御
Route::rule('setting/tencent_tsec','bsadmin/Setting/tencentTSec');
//用户设置
Route::rule('setting/user','bsadmin/Setting/setting');
//默认头像
Route::rule('setting/default_avatar','bsadmin/Setting/default_avatar');
//招聘会列表
Route::rule('job-fair','bsadmin/JobFair/index');
//发布招聘会
Route::rule('job-fair/add','bsadmin/JobFair/add');
//编辑招聘会
Route::rule('job-fair/edit/:id','bsadmin/JobFair/edit');
//设置招聘会状态
Route::get('job-fair/setStatus/:id/:status','bsadmin/JobFair/setJobFairStatus');
//删除招聘会展位
Route::rule('job-fair/delJobFairBooth/:id/:is_cate','bsadmin/JobFair/delJobFairBooth');
//删除招聘会联系人
Route::rule('job-fair/delJobFairContacts/:id','bsadmin/JobFair/delJobFairContacts');
//展位管理
Route::rule('job-fair/boothManage','bsadmin/JobFair/boothManage');
//获取展位修改记录
Route::get('job-fair/getBoothStatusLog','bsadmin/JobFair/getBoothStatusLog');
//人才管理
Route::rule('job-fair/resumeManage','bsadmin/JobFair/resumeManage');
//删除已参加招聘会的人才
Route::get('job-fair/delResume/:id','bsadmin/JobFair/delResume');
//检查系统更新
Route::rule('system/version/inspect','bsadmin/Packages/inspectSystemVersion');
//系统更新
Route::rule('system/version/update','bsadmin/Packages/updateSystemVersion');
//系统版本
Route::rule('packages','bsadmin/Packages/index');
//回滚版本
Route::get('packages/rollBackup/:filename','bsadmin/Packages/rollBackup');
//删除安装文件
Route::get('packages/delInstallPackage/:filename','bsadmin/Packages/delInstallPackage');
//安装版本
Route::get('packages/installPackage/:filename','bsadmin/Packages/installPackageAjax');
//主题
Route::rule('theme','bsadmin/Theme/index');
//获取图片
Route::rule('getImgByPath','bsadmin/Publics/getImgByPath');
//SEO设置
Route::rule('setting/seo','bsadmin/Setting/seo');
//设置顾问
Route::get('company/setAdviser/:id/:adviser_id','bsadmin/Company/setAdviser');
//设置顾问
Route::get('resume/setAdviser/:id/:adviser_id','bsadmin/Resume/setAdviser');
//获取简历信息
Route::rule('getResumeInfo/:id','bsadmin/Resume/getResumeInfo');
//实名申请
Route::rule('user/real_name','bsadmin/User/RealName');
//实名审核
Route::rule('user/real_name/setStatus/:id/:status/[:msg]','bsadmin/User/setRealNameStatus');
//编辑简历
Route::rule('resume/editResume/:id','bsadmin/Resume/editResume');
//编辑用户
Route::rule('user/editUser/:id','bsadmin/User/editUser');
//行业列表
Route::rule('industry','bsadmin/Company/industry');
//添加行业
Route::rule('industry/add','bsadmin/Company/addIndustry');
//编辑行业
Route::rule('industry/edit/:id','bsadmin/Company/editIndustry');
//异步缓存行业
Route::get('industry/setCacheIndustry','bsadmin/Company/setCacheIndustry');
//删除行业
Route::get('industry/del/:id','bsadmin/Company/delIndustry');
//短信模板
Route::rule('template/sms','bsadmin/Template/sms');
//邮件模板
Route::rule('template/email','bsadmin/Template/email');
//创建短信模板
Route::rule('template/sms/add','bsadmin/Template/addSms');
//编辑短信模板
Route::rule('template/sms/edit/:id','bsadmin/Template/editSms');
//设置短信模板状态
Route::get('template/sms/setStatus/:id/:status','bsadmin/Template/setSmsStatus');
//创建邮件模板
Route::rule('template/email/add','bsadmin/Template/addEmail');
//编辑邮件模板
Route::rule('template/email/edit/:id','bsadmin/Template/editEmail');
//设置邮件模板状态
Route::get('template/email/setStatus/:id/:status','bsadmin/Template/setEmailStatus');
//个推设置
Route::rule('setting/getui','bsadmin/Setting/getui');
//测试页面
Route::rule('test','bsadmin/Test/index');
//站内信模板
Route::rule('template/website','bsadmin/Template/website');
//创建站内信模板
Route::rule('template/website/add','bsadmin/Template/addWebsite');
//编辑站内信模板
Route::rule('template/website/edit/:id','bsadmin/Template/editWebsite');
//设置站内信模板状态
Route::get('template/website/setStatus/:id/:status','bsadmin/Template/setWebsiteStatus');
//删除公众号模板
Route::get('wechat/delPushTpl/:id','bsadmin/Wechat/delPushTpl');
//删除短信模板
Route::get('template/sms/delSms/:id','bsadmin/Template/delSms');
//删除邮件模板
Route::get('template/email/delEmail/:id','bsadmin/Template/delEmail');
//删除站内信模板
Route::get('template/website/delWebsite/:id','bsadmin/Template/delWebsite');
//编辑职位状态
Route::get('jobs/setJobsStatus/:id/:status','bsadmin/Jobs/setJobsStatus');
//业务管理
Route::rule('business','bsadmin/Business/index');
//积分明细
Route::rule('user/score','bsadmin/User/score');
//自动刷新
Route::rule('jobs/getJobsRefresh','bsadmin/Jobs/jobsRefresh');
//用户推广记录
Route::get('business/getExtension','bsadmin/Business/getExtension');
//简历投递记录
Route::rule('jobs/delivery_resume','bsadmin/Jobs/delivery_resume');
//审核职位
Route::rule('jobs/setJobsExamine/:id/:status/[:msg]','bsadmin/Jobs/setJobsExamine');
//审核简历
Route::rule('resume/setResumeExamine/:id/:status/[:msg]','bsadmin/Resume/setResumeExamine');
//学校
Route::rule('school','bsadmin/School/index');
//专业
Route::rule('school/specialities','bsadmin/School/specialities');
//添加学校
Route::rule('school/add','bsadmin/School/add');
//编辑学校
Route::rule('school/edit/:id','bsadmin/School/edit');
//删除学校
Route::get('school/del/:id','bsadmin/School/del');
//添加专业
Route::rule('school/addSpecialities','bsadmin/School/addSpecialities');
//编辑专业
Route::rule('school/editSpecialities/:id','bsadmin/School/editSpecialities');
//删除专业
Route::get('school/delSpecialities/:id','bsadmin/School/delSpecialities');
//设置职位置顶
Route::post('jobs/setJobsTop','bsadmin/Jobs/setJobsTop');
//设置职位推荐
Route::post('jobs/setJobsRecommend','bsadmin/Jobs/setJobsRecommend');
//获取统计信息
Route::get('ajax/statistics','bsadmin/Index/statistics');
//统计今日待办
Route::get('ajax/todo_statistics','bsadmin/Index/todoStatistics');
//图表统计
Route::get('ajax/charts_statistics','bsadmin/Index/chartsStatistics');
//设置职位紧急招聘
Route::post('jobs/setJobsUrgent','bsadmin/Jobs/setJobsUrgent');
//发布职位
Route::rule('jobs/addJobs/:company_id','bsadmin/Jobs/addJobs');
//编辑职位
Route::rule('jobs/editJobs/:company_id/:id','bsadmin/Jobs/editJobs');
//设置企业名企
Route::get('company/setIsFamous/:id/:status','bsadmin/Company/setIsFamous');
//状态别名
Route::rule('status_alias','bsadmin/StatusAlias/index');
//添加别名
Route::rule('status_alias/add','bsadmin/StatusAlias/add');
//编辑别名
Route::rule('status_alias/edit/:id','bsadmin/StatusAlias/edit');
//设置默认套餐
Route::rule('vip/setDefault/:id','bsadmin/Vip/setDefault');
//任务列表
Route::rule('timing','bsadmin/Timing/index');
//创建计划任务
Route::rule('timing/add','bsadmin/Timing/add');
//编辑计划任务
Route::rule('timing/edit/:id','bsadmin/Timing/edit');
//删除计划任务
Route::get('timing/del/:id','bsadmin/Timing/del');
//设置计划任务状态
Route::get('timing/setStatus/:id/:status','bsadmin/Timing/setStatus');
//设置广告列
Route::rule('ads/setAdsCol/:id/:col','bsadmin/Ads/setAdsCol');
//海报设置
Route::rule('vip/poster','bsadmin/Posters/index');
//添加海报
Route::rule('vip/poster/add','bsadmin/Posters/add');
//编辑海报
Route::rule('vip/poster/edit/:id','bsadmin/Posters/edit');
//设置海报状态
Route::get('vip/poster/setStatus/:id/:status','bsadmin/Posters/setStatus');
//删除海报
Route::rule('vip/poster/del/:id','bsadmin/Posters/del');
//管理员信息
Route::rule('admin/editMy','bsadmin/Admin/editMy');
//管理员通知
Route::rule('admin/notice','bsadmin/Admin/adminNotice');
//公众号推文助手
Route::rule('wechat/tweets','bsadmin/Wechat/tweets');
//社群推文助手
Route::rule('wechat/community_tweets','bsadmin/Wechat/community_tweets');
//删除权限
Route::rule('auth/del/:aid','bsadmin/Auth/delAuth');
//删除配置
Route::rule('setting/del/:id','bsadmin/Setting/del');
//编辑配置
Route::rule('setting/edit/:id','bsadmin/Setting/edit');
//数据看板
Route::rule('crm','bsadmin/Crm/index');
//全部客户
Route::rule('crm/customer','bsadmin/Crm/customer');
//我的客户
Route::rule('crm/my_customer','bsadmin/Crm/my_customer');
//公共客户
Route::rule('crm/public_customer','bsadmin/Crm/public_customer');
//全部跟进
Route::rule('crm/follow_up','bsadmin/Crm/follow_up');
//我的跟进
Route::rule('crm/my_follow_up','bsadmin/Crm/my_follow_up');
//自定义标签
Route::rule('crm/tag','bsadmin/Crm/crm_tag');
//CRM设置
Route::rule('setting/crm','bsadmin/Setting/crm');
//跟进结果
Route::rule('crm/follow_up_status','bsadmin/Crm/crm_follow_up_status');
//设置客户所有者
Route::rule('crm/setAdviser/:id/:adviser_id','bsadmin/Crm/setAdviser');
//编辑客户信息
Route::rule('crm/edit_customer','bsadmin/Crm/edit_customer');
//释放客户
Route::get('crm/cancelAdviser/:company_id','bsadmin/Crm/cancelAdviser');
//所有业绩
Route::rule('crm/achievement','bsadmin/Crm/achievement');
//我的业绩
Route::rule('crm/my_achievement','bsadmin/Crm/my_achievement');
//业绩结算
Route::rule('crm/achievement_settlement','bsadmin/Crm/achievement_settlement');
//录入业绩
Route::rule('crm/input_achievement','bsadmin/Crm/input_achievement');
//编辑业绩
Route::rule('crm/edit_achievement/:id','bsadmin/Crm/edit_achievement');
//审核业绩
Route::post('crm/examine_achievement','bsadmin/Crm/examine_achievement');
//重新提交业绩
Route::get('crm/reset_achievement/:id','bsadmin/Crm/reset_achievement');
//删除业绩
Route::get('crm/del_achievement/:id','bsadmin/Crm/del_achievement');
//获取统计信息
Route::get('ajax/crm/statistics','bsadmin/Crm/statistics');
//今日待办
Route::get('ajax/crm/todo_statistics','bsadmin/Crm/todo_statistics');
//获取图表统计
Route::get('ajax/crm/charts_statistics','bsadmin/Crm/charts_statistics');
//业绩图表统计
Route::get('ajax/crm/charts_achievement_settlement','bsadmin/Crm/charts_achievement_settlement');
//抖音支付
Route::rule('setting/toutiaopay','bsadmin/Setting/toutiaopay');
//百度支付
Route::rule('setting/baidupay','bsadmin/Setting/baidupay');
//支付宝小程序
Route::rule('setting/alipay_mp','bsadmin/Setting/alipayMp');
//百度小程序
Route::rule('setting/baidump','bsadmin/Setting/baidump');
//SEO页面设置
Route::rule('client/seo/index','bsadmin/Client/seo_index');
//编辑SEO页面
Route::rule('client/editSeo/:id','bsadmin/Client/editSeoApi');
//分站列表
Route::rule('city/website','bsadmin/CityWebsite/index');
//创建分站
Route::rule('city/website/add','bsadmin/CityWebsite/addCityWebsite');
//编辑分站
Route::rule('city/website/edit/:id','bsadmin/CityWebsite/editCityWebsite');
//设置分站状态
Route::get('city/website/setStatus/:id/:status','bsadmin/CityWebsite/setCityWebsiteStatus');
//删除分站
Route::get('city/website/del/:id','bsadmin/CityWebsite/delCityWebsite');
//分站配置
Route::rule('setting/sub_website','bsadmin/Setting/sub_website');
//浏览简历
Route::rule('resume/find/:id','bsadmin/Resume/getFind');
//优惠券列表
Route::rule('coupon/list','bsadmin/Coupon/index');
//优惠券
Route::rule('coupon','bsadmin/Coupon/coupon');
//创建优惠券
Route::rule('coupon/add','bsadmin/Coupon/add');
//编辑优惠券
Route::rule('coupon/edit/:id','bsadmin/Coupon/edit');
//设置优惠券状态
Route::rule('coupon/setStatus/:id/:status','bsadmin/Coupon/setStatus');
//删除优惠券
Route::rule('coupon/del/:id','bsadmin/Coupon/del');
//增发优惠券
Route::post('coupon/raise','bsadmin/Coupon/raise');
//赠送优惠券
Route::post('coupon/giveUserCoupon','bsadmin/Coupon/giveUserCoupon');
//发放优惠券
Route::rule('coupon/give','bsadmin/Coupon/giveCoupon');
//用户权益
Route::rule('user/vip/getRights','bsadmin/User/getRights');
//赠送权益
Route::rule('user/vip/giveRights','bsadmin/User/giveRights');
//编辑用户权益
Route::rule('user/vip/editRights/:id','bsadmin/User/editRights');
//设置用户权益状态
Route::get('user/vip/invalidRights/:id','bsadmin/User/invalidRights');
//添加简历
Route::rule('resume/addResume','bsadmin/Resume/addResume');
//删除简历经历
Route::get('resume/delExperience/:type/:id/:uid/:resume_id','bsadmin/Resume/delExperience');
//发送短信
Route::rule('sendSmsMessage','bsadmin/Message/sendSmsMessage');
//发送邮件
Route::rule('sendEmail','bsadmin/Message/sendEmail');
//设置用户状态
Route::rule('user/setStatus/:id','bsadmin/User/setStatus');
//添加用户
Route::rule('user/addUser','bsadmin/User/addUser');
//刷新企业
Route::rule('company/refreshCompany/:id','bsadmin/Company/refreshCompany');
//刷新职位
Route::rule('jobs/refreshJobs/:id','bsadmin/Jobs/refreshJobs');
//刷新简历
Route::rule('resume/refreshResume/:id','bsadmin/Resume/refreshResume');
//导出企业
Route::rule('company/exportCompany','bsadmin/Company/exportCompany');
//导出职位
Route::rule('jobs/exportJobs','bsadmin/Jobs/exportJobs');
//导出简历
Route::rule('resume/exportResume','bsadmin/Resume/exportResume');
//导入企业
Route::rule('company/importCompany','bsadmin/Company/importCompany');
//导入职位
Route::rule('jobs/importJobs','bsadmin/Jobs/importJobs');
//导入简历
Route::rule('resume/importResume','bsadmin/Resume/importResume');
//导出访问日志
Route::get('user/exportApiLog','bsadmin/User/exportApiLog');
//导出登录日志
Route::get('user/exportLoginLog','bsadmin/User/exportLoginLog');
//刷新简历
Route::rule('resume/refreshResume/:id','bsadmin/Resume/refreshResume');
//设置状态别名状态
Route::get('status_alias/setStatus/:id/:status','bsadmin/StatusAlias/setStatus');
//设置职位分类状态
Route::get('jobs/setJobsCateStatus/:id/:status','bsadmin/Jobs/setJobsCateStatus');
//设置行业分类状态
Route::get('company/setCompanyIndustryStatus/:id/:status','bsadmin/Company/setCompanyIndustryStatus');
//设置文章分类
Route::get('article/setArticleCid/:id/:cid','bsadmin/Article/setArticleCid');
