<?php 
namespace app\bsadmin\model;

use think\facade\Cache;
use think\Model;

class Config extends Model
{
	public static function getList($where=[])
	{
	    $data=self::where($where)->withoutField('update_time,create_time')->order('id asc')->select();
        $D=[];
        if ($data) {
            foreach ($data->toArray() as $k => $v) {
                switch ($v['type']) {
                    case 'upload':
                        $v['url']=$v['value']?config('web.imgurl').$v['value']:'';
                        break;
                    case 'array':
                        $v['value']=json_decode($v['value'],true);
                        break;
                    case 'checkbox':
                        $v['value']=explode(",", $v['value']);
                        break;
                }
                if ($v['options']) {
                    $options=json_decode($v['options'],true);
                    $v['options']=[];
                    if(!empty($options))
                    $v['options']=arrtoint($options,'value');
                }
                if (is_numeric($v['value']))
                    $v['value']=(float) $v['value'];
                $D[$v['ctype']][$v['key']]=$v;
            }
        }
        return $D;
	}
}