<?php 
namespace app\bsadmin\model;

use think\Model;

class Auth extends Model
{
	/**
	 * 获取单个
	 */
	public static function getAuth($where='',$field='*')
	{
		$auth=self::where($where)->field($field)->find();
		if ($auth['pid']) {
			$auth['ppid']=self::where(['aid'=>$auth['pid']])->value('pid');
		}
		return $auth;
	}
	/**
	 * 获取所有
	 */
	public static function getSelect($where=[])
	{
		$auth=self::where($where)->order('sort asc,aid asc')->select();
		foreach ($auth as $k => $v) {
			$auth[$k]['hasChildren']=self::where(['pid'=>$v['aid']])->count();
		}
		return $auth;
	}
	/**
	 * 获取所有权限
	 */
	public static function getList()
	{
        $auth=self::field('pid,aid,title')->order('sort asc,aid asc')->select();
        return $auth;
	}
	/**
	 * 获取菜单权限
	 */
	public static function getMenuList($where=[])
	{
        $auth=self::where($where)->where(['status'=>1,'show'=>1])->field('pid,aid,title,icon,url')->order('sort asc,aid asc')->select();
        return $auth;
	}
	/**
	 * 作为分类使用
	 * @return 返回标题和ID
	 */
    public static function getCateList()
    {
        $auth=self::where('pid',0)->field('aid,title')->order('sort asc,aid asc')->order('sort asc,aid asc')->select();
        foreach ($auth as $k => $v) {
            $auth[$k]['data']=self::where('pid',$v['aid'])->field('aid,title')->order('sort asc,aid asc')->select();
        }
        return $auth;
    }
}