<?php
namespace app\bsadmin\controller;
use think\facade\Db;
use think\facade\Cache;
use think\facade\View;
use think\Validate;
use app\common\model\Timing as TimingModel;
use app\common\service\queue\Timing as TimingQueue;
class Timing extends Base
{
    public function index()
    {
        if (request()->isPost()) {
            $D=request()->post();
            Db::startTrans();
            $TimingModel=TimingModel::lock(true)->find($D['id']);
            if(!$TimingModel){
                Db::rollback();
                return $this->ajaxReturn('执行失败',-100);
            }
            if((new TimingQueue)->runTask($TimingModel)){
                return $this->ajaxReturn();
            }else{
                return $this->ajaxReturn('执行失败',-100);
            }
        }
        if (request()->isAjax()) {
            $Data=TimingModel::order('id desc')->withAttr('last_time',function($v,$data){
                return $v?date('Y-m-d H:i:s',$v):'';
            })->withAttr('next_time',function($v,$data){
                return $v?date('Y-m-d H:i:s',$v):'';
            })->select();
            if ($Data) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    /**
     * 编辑地区
     */
    public function edit($id)
    {
        $D=request()->post();
        if(empty($D['title']))
            return $this->ajaxReturn('任务名称不能为空',-100);
        if(empty($D['content']))
            return $this->ajaxReturn('请输入任务内容',-100);
        $TimingModel=TimingModel::find($id);
        $TimingModel->title     = $D['title'];
        $TimingModel->type      = $D['type'];
        $TimingModel->time_type = $D['time_type'];
        $TimingModel->status    = $D['status'];
        $TimingModel->day       = $D['day'];
        $TimingModel->week      = $D['week'];
        $TimingModel->day_sum   = $D['day_sum'];
        $TimingModel->hour      = $D['hour'];
        $TimingModel->minute    = $D['minute'];
        $TimingModel->content   = $D['content'];
        $TimingModel->status    = 1;
        $TimingModel->next_time = (new TimingQueue)->getNextTime($TimingModel);
        if($TimingModel->save()){
            return $this->ajaxReturn('保存成功');
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function add()
    {
        $D=request()->post();
        if(empty($D['title']))
            return $this->ajaxReturn('任务名称不能为空',-100);
        if(empty($D['content']))
            return $this->ajaxReturn('请输入任务内容',-100);
        $TimingModel=new TimingModel;
        $TimingModel->title     = $D['title'];
        $TimingModel->type      = $D['type'];
        $TimingModel->time_type = $D['time_type'];
        $TimingModel->status    = $D['status'];
        $TimingModel->day       = $D['day'];
        $TimingModel->week      = $D['week'];
        $TimingModel->day_sum   = $D['day_sum'];
        $TimingModel->hour      = $D['hour'];
        $TimingModel->minute    = $D['minute'];
        $TimingModel->content   = $D['content'];
        if(empty($D['run'])){
            $TimingModel->next_time = (new TimingQueue)->getNextTime($TimingModel);
        }else{
            $TimingModel->next_time = time();
        }
        if($TimingModel->save()){
            return $this->ajaxReturn('保存成功');
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function setStatus($id,$status)
    {
        $TimingModel=TimingModel::where(['id'=>$id])->find();
        $TimingModel->status=$status;
        if ($TimingModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function del($id)
    {
        $TimingModel=TimingModel::where(['id'=>$id])->find();
        if ($TimingModel->delete()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
}
