<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Db;
use think\facade\Config;
use helper\URL;
use helper\Dir;

class Theme extends Base
{
	public function index()
	{
		if (request()->isAjax()) {
            if (request()->isGet()) {
                $Data=Dir::tree(root_path().'html');
                foreach ($Data as $k => $v) {
                    $Data[$k]['create_time']=date('Y/m/d H:i:s',$v['filemtime']);
                    $Data[$k]['update_time']=date('Y/m/d H:i:s',$v['fileatime']);
                    $Data[$k]['app']=@file_exists($v['path'].'app');
                    $Data[$k]['bsadmin']=@file_exists($v['path'].'bsadmin');
                    $Data[$k]['index']=@file_exists($v['path'].'index');
                    $Data[$k]['mobile']=@file_exists($v['path'].'mobile');
                    $Data[$k]['is_app']=false;
                    $Data[$k]['is_bsadmin']=false;
                    $Data[$k]['is_index']=false;
                    $Data[$k]['is_mobile']=false;
                    if(@file_exists($v['path'].'_theme')&&@file_exists(base_path().'app/config/view.php')){
                        $app_config=include base_path().'app/config/view.php';
                        $Data[$k]['is_app']=$app_config['view_dir_name']=='html/'.$v['filename'];
                    }
                    if(@file_exists($v['path'].'_theme')&&@file_exists(base_path().'bsadmin/config/view.php')){
                        $app_config=include base_path().'bsadmin/config/view.php';
                        $Data[$k]['is_bsadmin']=$app_config['view_dir_name']=='html/'.$v['filename'];
                    }
                    if(@file_exists($v['path'].'_theme')&&@file_exists(base_path().'index/config/view.php')){
                        $app_config=include base_path().'index/config/view.php';
                        $Data[$k]['is_index']=$app_config['view_dir_name']=='html/'.$v['filename'];
                    }
                    if(@file_exists($v['path'].'_theme')&&@file_exists(base_path().'mobile/config/view.php')){
                        $app_config=include base_path().'mobile/config/view.php';
                        $Data[$k]['is_mobile']=$app_config['view_dir_name']=='html/'.$v['filename'];
                    }
                    if(@file_exists($v['path'].'_theme')){
                        if (@file_exists($v['path'].'_theme/img'))
                            $Data[$k]['theme']=Dir::tree($v['path'].'_theme/img');
                        if (@file_exists($v['path'].'_theme/info.json'))
                            $Data[$k]['info']=json_decode(file_get_contents($v['path'].'_theme/info.json'),true);
                    }
                }
                return $this->ajaxReturn('',0,$Data);
            }
            if(request()->isPost()){
                $D=request()->post();
                $_config_text="<?php
return [
    'view_dir_name' => 'html/".$D['filename']."',
    'taglib_pre_load'=> 'app\\common\\tag\\XYCms',
    'tpl_replace_string'    =>  [
        '__PLUGIN_SRC__'=>'/static/plugin',
        '__TEMPLATE_STATIC__'=>'/static/".$D['filename']."/".$D['client']."',
    ],
];
";
                try {
                    //写入配置文件
                    $ConfigPath=base_path().$D['client'].'/config/view.php';
                    $ConfigFile = fopen($ConfigPath, "w") or die("Unable to open file!");
                    fwrite($ConfigFile, $_config_text);
                    fclose($ConfigFile);
                    return $this->ajaxReturn('已切换');
                } catch (Exception $e) {
                    return $this->ajaxReturn('切换失败',-100);
                }
            }
		}else{
	    	return View::fetch();
		}
	}
}
