<?php
namespace app\bsadmin\controller;
use think\facade\Cache;
use think\facade\View;
use think\facade\Validate;
use app\common\model\SmsTemplate as SmsTemplateModel;
use app\common\model\EmailTemplate as EmailTemplateModel;
use app\common\model\WebsiteTemplate as WebsiteTemplateModel;
class Template extends Base
{
    public function sms()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            if(!empty($G['action'])&&$G['action']=='cache'){
                $SmsTemplateModel=SmsTemplateModel::field('id')->select();
                foreach ($SmsTemplateModel as $v) {
                    $this->setSmsTplCache($v->id);
                }
                return $this->ajaxReturn();
            }
            $Data=SmsTemplateModel::paginate(1000);
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function editSms($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'       => 'require|max:50|unique:wechat_template',
                'title'       => 'require|max:100',
                'content'     => 'require|max:250',
            ];
            $msg  =   [
                'alias.require'       => 'Alias不能为空', 
                'alias.max'           => 'Alias不能超过50个字符',
                'alias.unique'        => 'Alias已存在',
                'title.require'       => '名称不能为空',
                'title.max'           => '名称不能超过100个字符',
                'content.require'     => '内容不能为空',
                'content.max'         => '内容不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $SmsTemplateModel=SmsTemplateModel::find($id);
            $alias='';
            if($SmsTemplateModel->alias!=$D['alias'])
                $alias=$SmsTemplateModel->alias;
            $SmsTemplateModel->alias         = $D['alias'];
            $SmsTemplateModel->title         = $D['title'];
            $SmsTemplateModel->content       = $D['content'];
            $SmsTemplateModel->status        = $D['status'];
            if ($SmsTemplateModel->save()) {
                if($alias)
                $this->delSmsCache($SmsTemplateModel->alias);
                $this->setSmsTplCache($SmsTemplateModel->id);
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=SmsTemplateModel::where(['id'=>$id])->find();
            if (request()->isAjax())
                return $this->ajaxReturn('',0,$Find);
            View::assign('Find',$Find);
            return View::fetch('add_sms');
        }
    }
    public function addSms()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'       => 'require|max:50|unique:sms_template',
                'title'       => 'require|max:100',
                'content'     => 'require|max:250',
            ];
            $msg  =   [
                'alias.require'       => 'Alias不能为空', 
                'alias.max'           => 'Alias不能超过50个字符',
                'alias.unique'        => 'Alias已存在',
                'title.require'       => '名称不能为空',
                'title.max'           => '名称不能超过100个字符',
                'content.require'     => '内容不能为空',
                'content.max'         => '内容不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $SmsTemplateModel=new SmsTemplateModel;
            $SmsTemplateModel->alias         = $D['alias'];
            $SmsTemplateModel->title         = $D['title'];
            $SmsTemplateModel->content       = $D['content'];
            $SmsTemplateModel->status        = $D['status'];
            if ($SmsTemplateModel->save()) {
                $this->setSmsTplCache($SmsTemplateModel->id);
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    /**
     * 设置套餐状态
     */
    public function setSmsStatus($id,$status)
    {
        $SmsTemplateModel=SmsTemplateModel::find($id);
        $SmsTemplateModel->status=$status;
        if ($SmsTemplateModel->save()) {
            $this->setSmsTplCache($id);
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setSmsTplCache($id)
    {
        $SmsTemplateModel=SmsTemplateModel::where(['id'=>$id])->withAttr('item_data',function($v){
            return json_decode($v,true);
        })->find();
        if ($SmsTemplateModel)
            Cache::set('SmsTemplate.'.$SmsTemplateModel->alias,$SmsTemplateModel->toArray());
    }
    public function delSms($id)
    {
        $SmsTemplateModel=SmsTemplateModel::find($id);
        if ($SmsTemplateModel->delete()) {
            $this->delSmsCache($SmsTemplateModel->alias);
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function delSmsCache($alias)
    {
        Cache::delete('SmsTemplate.'.$alias);
    }
    public function email()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            if(!empty($G['action'])&&$G['action']=='cache'){
                $EmailTemplateModel=EmailTemplateModel::field('id')->select();
                foreach ($EmailTemplateModel as $v) {
                    $this->setEmailTplCache($v->id);
                }
                return $this->ajaxReturn();
            }
            $Data=EmailTemplateModel::paginate(1000);
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function editEmail($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'       => 'require|max:50|unique:wechat_template',
                'name'        => 'require',
                'title'       => 'require|max:100',
                'content'     => 'require|max:250',
            ];
            $msg  =   [
                'alias.require'       => 'Alias不能为空', 
                'alias.max'           => 'Alias不能超过50个字符',
                'alias.unique'        => 'Alias已存在',
                'name.require'        => '名称不能为空',
                'title.require'       => '标题不能为空',
                'title.max'           => '标题不能超过100个字符',
                'content.require'     => '内容不能为空',
                'content.max'         => '内容不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $EmailTemplateModel=EmailTemplateModel::find($id);
            $alias='';
            if($EmailTemplateModel->alias!=$D['alias'])
                $alias=$EmailTemplateModel->alias;
            $EmailTemplateModel->alias         = $D['alias'];
            $EmailTemplateModel->name          = $D['name'];
            $EmailTemplateModel->title         = $D['title'];
            $EmailTemplateModel->content       = $D['content'];
            $EmailTemplateModel->status        = $D['status'];
            if ($EmailTemplateModel->save()) {
                if($alias)
                $this->delEmailCache($alias);
                $this->setEmailTplCache($EmailTemplateModel->id);
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=EmailTemplateModel::where(['id'=>$id])->find();
            if (request()->isAjax())
                return $this->ajaxReturn('',0,$Find);
            View::assign('Find',$Find);
            return View::fetch('add_email');
        }
    }
    public function addEmail()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'       => 'require|max:50|unique:sms_template',
                'name'        => 'require',
                'title'       => 'require|max:100',
                'content'     => 'require|max:250',
            ];
            $msg  =   [
                'alias.require'       => 'Alias不能为空', 
                'alias.max'           => 'Alias不能超过50个字符',
                'alias.unique'        => 'Alias已存在',
                'name.require'        => '名称不能为空',
                'title.require'       => '标题不能为空',
                'title.max'           => '标题不能超过100个字符',
                'content.require'     => '内容不能为空',
                'content.max'         => '内容不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $EmailTemplateModel=new EmailTemplateModel;
            $EmailTemplateModel->alias         = $D['alias'];
            $EmailTemplateModel->name          = $D['name'];
            $EmailTemplateModel->title         = $D['title'];
            $EmailTemplateModel->content       = $D['content'];
            $EmailTemplateModel->status        = $D['status'];
            if ($EmailTemplateModel->save()) {
                $this->setEmailTplCache($EmailTemplateModel->id);
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    /**
     * 设置套餐状态
     */
    public function setEmailStatus($id,$status)
    {
        $EmailTemplateModel=EmailTemplateModel::find($id);
        $EmailTemplateModel->status=$status;
        if ($EmailTemplateModel->save()) {
            $this->setEmailTplCache($id);
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setEmailTplCache($id)
    {
        $EmailTemplateModel=EmailTemplateModel::where(['id'=>$id])->withAttr('item_data',function($v){
            return json_decode($v,true);
        })->find();
        if ($EmailTemplateModel)
            Cache::set('EmailTemplate.'.$EmailTemplateModel->alias,$EmailTemplateModel->toArray());
    }
    public function delEmail($id)
    {
        $EmailTemplateModel=EmailTemplateModel::find($id);
        if ($EmailTemplateModel->delete()) {
            $this->delEmailCache($EmailTemplateModel->alias);
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function delEmailCache($alias)
    {
        Cache::delete('EmailTemplate.'.$alias);
    }
    public function website()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            if(!empty($G['action'])&&$G['action']=='cache'){
                $WebsiteTemplateModel=WebsiteTemplateModel::field('id')->select();
                foreach ($WebsiteTemplateModel as $v) {
                    $this->setWebsiteTplCache($v->id);
                }
                return $this->ajaxReturn();
            }
            $Data=WebsiteTemplateModel::paginate(1000);
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function editWebsite($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'       => 'require|max:50|unique:wechat_template',
                'name'        => 'require',
                'title'       => 'require|max:100',
                'desc'        => 'max:200',
                'content'     => 'require|max:250',
            ];
            $msg  =   [
                'alias.require'       => 'Alias不能为空', 
                'alias.max'           => 'Alias不能超过50个字符',
                'alias.unique'        => 'Alias已存在',
                'name.require'        => '名称不能为空',
                'title.require'       => '标题不能为空',
                'title.max'           => '标题不能超过100个字符',
                'desc.max'            => '描述不能超过250个字符',
                'content.require'     => '内容不能为空',
                'content.max'         => '内容不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $WebsiteTemplateModel=WebsiteTemplateModel::find($id);
            $alias='';
            if($WebsiteTemplateModel->alias!=$D['alias'])
                $alias=$WebsiteTemplateModel->alias;
            $WebsiteTemplateModel->alias         = $D['alias'];
            $WebsiteTemplateModel->name          = $D['name'];
            $WebsiteTemplateModel->title         = $D['title'];
            $WebsiteTemplateModel->desc          = $D['desc'];
            $WebsiteTemplateModel->content       = $D['content'];
            $WebsiteTemplateModel->status        = $D['status'];
            if ($WebsiteTemplateModel->save()) {
                if($alias)
                $this->delWebsiteCache($alias);
                $this->setWebsiteTplCache($WebsiteTemplateModel->id);
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=WebsiteTemplateModel::where(['id'=>$id])->find();
            if (request()->isAjax())
                return $this->ajaxReturn('',0,$Find);
            View::assign('Find',$Find);
            return View::fetch('add_website');
        }
    }
    public function addWebsite()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'       => 'require|max:50|unique:sms_template',
                'name'        => 'require',
                'title'       => 'require|max:100',
                'desc'        => 'max:200',
                'content'     => 'require|max:250',
            ];
            $msg  =   [
                'alias.require'       => 'Alias不能为空', 
                'alias.max'           => 'Alias不能超过50个字符',
                'alias.unique'        => 'Alias已存在',
                'name.require'        => '名称不能为空',
                'title.require'       => '标题不能为空',
                'title.max'           => '标题不能超过100个字符',
                'desc.max'            => '描述不能超过250个字符',
                'content.require'     => '内容不能为空',
                'content.max'         => '内容不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $WebsiteTemplateModel=new WebsiteTemplateModel;
            $WebsiteTemplateModel->alias         = $D['alias'];
            $WebsiteTemplateModel->name          = $D['name'];
            $WebsiteTemplateModel->title         = $D['title'];
            $WebsiteTemplateModel->desc          = $D['desc'];
            $WebsiteTemplateModel->content       = $D['content'];
            $WebsiteTemplateModel->status        = $D['status'];
            if ($WebsiteTemplateModel->save()) {
                $this->setWebsiteTplCache($WebsiteTemplateModel->id);
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    /**
     * 设置套餐状态
     */
    public function setWebsiteStatus($id,$status)
    {
        $WebsiteTemplateModel=WebsiteTemplateModel::find($id);
        $WebsiteTemplateModel->status=$status;
        if ($WebsiteTemplateModel->save()) {
        	$this->setWebsiteTplCache($id);
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setWebsiteTplCache($id)
    {
    	$WebsiteTemplateModel=WebsiteTemplateModel::where(['id'=>$id])->withAttr('item_data',function($v){
    		return json_decode($v,true);
    	})->find();
    	if ($WebsiteTemplateModel)
			Cache::set('WebsiteTemplate.'.$WebsiteTemplateModel->alias,$WebsiteTemplateModel->toArray());
    }
    public function delWebsite($id)
    {
        $WebsiteTemplateModel=WebsiteTemplateModel::find($id);
        if ($WebsiteTemplateModel->delete()) {
            $this->delWebsiteCache($WebsiteTemplateModel->alias);
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function delWebsiteCache($alias)
    {
        Cache::delete('WebsiteTemplate.'.$alias);
    }
}
