<?php
namespace app\bsadmin\controller;
use think\facade\Cache;
use think\facade\Session;
use think\facade\View;
use think\facade\Db;
use think\facade\Validate;
use app\common\model\StatusAlias as StatusAliasModel;
class StatusAlias extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['alias']) {
                $where[]=['alias','=',urldecode($G['alias'])];
            }
            $Data=StatusAliasModel::where($where)->paginate($G['pageSize']);
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function edit($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'      => 'require',
                'title'      => 'require',
                'value'      => 'require',
            ];
            $msg  =   [
                'alias.require'  => '别名必填', 
                'title.require'  => '名称必填', 
                'value.require'  => '值必填', 
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $StatusAliasModel=StatusAliasModel::find($id);
            $StatusAliasModel->alias    = $D['alias'];
            $StatusAliasModel->title    = $D['title'];
            $StatusAliasModel->value     = $D['value'];
            $StatusAliasModel->type     = $D['type'];
            if (isset($D['is_company'])){
                $StatusAliasModel->is_company     = intval($D['is_company']);
            }else{
                $StatusAliasModel->is_company     = null;
            }
            if($StatusAliasModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=StatusAliasModel::where(['id'=>$id])->find();
            View::assign('Find',$Find);
            return View::fetch('add');
        }
    }
    public function add()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'alias'      => 'require',
                'title'      => 'require',
                'value'      => 'require',
            ];
            $msg  =   [
                'alias.require'  => '别名必填', 
                'title.require'  => '名称必填', 
                'value.require'  => '值必填', 
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $StatusAliasModel=new StatusAliasModel;
            $StatusAliasModel->alias    = $D['alias'];
            $StatusAliasModel->title    = $D['title'];
            $StatusAliasModel->value     = $D['value'];
            $StatusAliasModel->type     = $D['type'];
            if (isset($D['is_company']))
                $StatusAliasModel->is_company     = intval($D['is_company']);
            if($StatusAliasModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    /**
     * 设置状态
     */
    public function setStatus($id,$status)
    {
        $StatusAliasModel=StatusAliasModel::find($id);
        $StatusAliasModel->status=$status;
        if ($StatusAliasModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
}
