<?php
namespace app\bsadmin\controller;
use think\facade\Cache;
use think\facade\View;
use think\facade\Db;
use think\facade\Validate;
use app\common\model\ScoreTask as ScoreTaskModel;
use app\bsadmin\model\Config as ConfigModel;
use app\common\event\ScoreTask as ScoreTaskEvent;
class Score extends Base
{
    public function set()
    {
        $Data=ConfigModel::getList(['ctype'=>'xy_score']);
        View::assign('Data',$Data);
        View::assign('ctype','xy_score');
        return View::fetch('setting/basic');
    }
    public function task()
    {
        if (request()->isAjax()) {
            $Data=ScoreTaskModel::alias('score')
                ->field('score.*')
                ->order('id desc')->paginate(1000)->each(function($v){
                    $v['start_time']=$v['start_time']?date('Y-m-d',$v['start_time']):'';
                    $v['end_time']=$v['end_time']?date('Y-m-d',$v['end_time']):'';
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            $ScoreTaskEvent=ScoreTaskEvent::$event;
            View::assign('ScoreTaskEvent',$ScoreTaskEvent);
	    	return View::fetch();
        }
    }
    /**
     * 编辑套餐
     */
    public function edit($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'title'         => 'require|max:50',
                'status'        => 'require',
                'score'         => 'require',
                'event'         => 'require',
                'repeat'        => 'require',
                'repeat_sum'    => 'require',
                'stock'         => 'require',
            ];
            $msg  =   [
                'title.require'     => '名称不能为空', 
                'title.max'         => '名称不能超过30个字符',
                'status.require'    => '请选择套餐状态',
                'score.require'     => '请输入奖励积分',
                'event.require'     => '请选择事件',
                'repeat.require'    => '请选择重复模式',
                'repeat_sum.require'=> '请输入重复次数',
                'stock.require'     => '请输入库存',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $ScoreTaskModel=ScoreTaskModel::find($id);
            $ScoreTaskModel->title        = $D['title'];
            $ScoreTaskModel->tips         = $D['tips'];
            if (isset($D['is_company']) && is_numeric($D['is_company'])){
                $ScoreTaskModel->is_company= $D['is_company'];
            }else{
                $ScoreTaskModel->is_company= null;
            }
            $ScoreTaskModel->status       = $D['status'];
            $ScoreTaskModel->sort         = $D['sort'];
            $ScoreTaskModel->event        = $D['event'];
            $ScoreTaskModel->score        = $D['score'];
            $ScoreTaskModel->url          = $D['url'];
            $ScoreTaskModel->repeat       = $D['repeat'];
            $ScoreTaskModel->repeat_sum   = $D['repeat_sum'];
            $ScoreTaskModel->complete_sum = 0;
            if (intval($D['add_stock'])) {
                $ScoreTaskModel->stock        = $ScoreTaskModel->stock+intval($D['add_stock']);
                $ScoreTaskModel->surplus_stock= $ScoreTaskModel->surplus_stock+intval($D['add_stock']);
            }
            if ($D['cancel_stock']) {
                $ScoreTaskModel->stock        = 0;
                $ScoreTaskModel->surplus_stock= 0;
            } 
            if (intval($D['complete_sum']))
                $ScoreTaskModel->complete_sum        = intval($D['complete_sum']);

            if (strtotime($D['start_time'])){
                $ScoreTaskModel->start_time= strtotime($D['start_time'].' 08:00:00');
            }else{
                $ScoreTaskModel->start_time= null;
            }
            if (strtotime($D['end_time'])){
                $ScoreTaskModel->end_time= strtotime($D['end_time'].' 23:59:59');
            }else{
                $ScoreTaskModel->end_time= null;
            }
            if ($ScoreTaskModel->save()) {
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $ScoreTaskEvent=ScoreTaskEvent::$event;
            View::assign('ScoreTaskEvent',$ScoreTaskEvent);
            $Find=ScoreTaskModel::where(['id'=>$id])
                ->withAttr('start_time',function($v,$d){
                    return $v?date('Y-m-d',$v):'';
                })
                ->withAttr('end_time',function($v,$d){
                    return $v?date('Y-m-d',$v):'';
                })->find();
            $Find->add_stock='';
            $Find->cancel_stock=0;
            if (request()->isAjax())
                return $this->ajaxReturn('',0,$Find);
            View::assign('Find',$Find);
            return View::fetch('add');
        }
    }
    /**
     * 创建套餐
     */
    public function add()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'title'         => 'require|max:50',
                'status'        => 'require',
                'score'         => 'require',
                'event'         => 'require',
                'repeat'        => 'require',
                'repeat_sum'    => 'require',
                'stock'         => 'require',
            ];
            $msg  =   [
                'title.require'     => '名称不能为空', 
                'title.max'         => '名称不能超过30个字符',
                'status.require'    => '请选择套餐状态',
                'score.require'     => '请输入奖励积分',
                'event.require'     => '请选择事件',
                'repeat.require'    => '请选择重复模式',
                'repeat_sum.require'=> '请输入重复次数',
                'stock.require'     => '请输入库存',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $ScoreTaskModel=new ScoreTaskModel;
            $ScoreTaskModel->title        = $D['title'];
            $ScoreTaskModel->tips         = $D['tips'];
            if (isset($D['is_company']) && is_numeric($D['is_company']))
                $ScoreTaskModel->is_company= $D['is_company'];
            $ScoreTaskModel->status       = $D['status'];
            $ScoreTaskModel->sort   	  = $D['sort'];
            $ScoreTaskModel->event   	  = $D['event'];
            $ScoreTaskModel->score        = $D['score'];
            $ScoreTaskModel->url          = $D['url'];
            $ScoreTaskModel->repeat       = $D['repeat'];
            $ScoreTaskModel->repeat_sum   = $D['repeat_sum'];
            $ScoreTaskModel->stock        = intval($D['stock']);
            $ScoreTaskModel->surplus_stock= intval($D['stock']);
            $ScoreTaskModel->complete_sum = 0;
            if (intval($D['surplus_stock']))
                $ScoreTaskModel->surplus_stock        = intval($D['surplus_stock']);
            if (intval($D['stock'])&&intval($D['surplus_stock']))
                $ScoreTaskModel->complete_sum        = intval($D['stock'])-intval($D['surplus_stock']);
            if (strtotime($D['start_time']))
                $ScoreTaskModel->start_time= strtotime($D['start_time'].' 08:00:00');
            if (strtotime($D['end_time']))
                $ScoreTaskModel->end_time= strtotime($D['end_time'].' 23:59:59');
            if ($ScoreTaskModel->save()) {
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $ScoreTaskEvent=ScoreTaskEvent::$event;
            View::assign('ScoreTaskEvent',$ScoreTaskEvent);
            return View::fetch();
        }
    }
    /**
     * 设置套餐状态
     */
    public function setStatus($id,$status)
    {
        $ScoreTaskModel=ScoreTaskModel::find($id);
        $ScoreTaskModel->status=$status;
        if ($ScoreTaskModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
}
