<?php
namespace app\bsadmin\controller;
use think\facade\Cache;
use think\facade\Session;
use think\facade\View;
use think\facade\Db;
use think\facade\Validate;
use app\common\model\School as SchoolModel;
use app\common\model\Specialities as SpecialitiesModel;
class School extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['name']) {
                $where[]=['school_name','like','%'.$G['name'].'%'];
            }
            if ($G['code']) {
                $where[]=['school_code','=',$G['code']];
            }
            $Data=SchoolModel::where($where)->paginate($G['pageSize']);
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function edit($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'school_name'      => 'require',
                'school_code'   => 'unique:school',
            ];
            $msg  =   [
                'school_name.require'  => '名称不能为空', 
                'school_code.unique'    => '学校代码已存在',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $SchoolModel=SchoolModel::find($id);
            $SchoolModel->school_name    = $D['school_name'];
            $SchoolModel->school_code    = $D['school_code'];
            $SchoolModel->university     = $D['university'];
            if($SchoolModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=SchoolModel::where(['id'=>$id])->find();
            View::assign('Find',$Find);
            return View::fetch('add');
        }
    }
    public function add()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'school_name'      => 'require',
                'school_code'      => 'unique:school',
            ];
            $msg  =   [
                'school_name.require'  => '名称不能为空', 
                'school_code.unique'   => '学校代码已存在',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $SchoolModel=new SchoolModel;
            $SchoolModel->school_name    = $D['school_name'];
            $SchoolModel->school_code    = $D['school_code'];
            $SchoolModel->university     = $D['university'];
            if($SchoolModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    public function del($id)
    {
        $SchoolModel=SchoolModel::find($id);
        if($SchoolModel->delete()){
            return $this->ajaxReturn('已删除');
        }else{
            return $this->ajaxReturn('删除失败，请重试',-200);
        }
    }
    public function specialities()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['name']) {
                $where[]=['specialities','like','%'.$G['name'].'%'];
            }
            if ($G['code']) {
                $where[]=['code','=',$G['code']];
            }
            $Data=SpecialitiesModel::where($where)->paginate($G['pageSize']);
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function editSpecialities($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'specialities'      => 'require',
                'code'   => 'unique:specialities',
            ];
            $msg  =   [
                'specialities.require'  => '名称不能为空', 
                'code.unique'    => '学校代码已存在',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $SpecialitiesModel=SpecialitiesModel::find($id);
            $SpecialitiesModel->specialities    = $D['specialities'];
            $SpecialitiesModel->code    = $D['code'];
            $SpecialitiesModel->university     = $D['university'];
            if($SpecialitiesModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=SpecialitiesModel::where(['id'=>$id])->find();
            View::assign('Find',$Find);
            return View::fetch('add');
        }
    }
    public function addSpecialities()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'specialities'      => 'require',
                'code'      => 'unique:specialities',
            ];
            $msg  =   [
                'specialities.require'  => '名称不能为空', 
                'code.unique'   => '专业代码已存在',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $SpecialitiesModel=new SpecialitiesModel;
            $SpecialitiesModel->specialities    = $D['specialities'];
            $SpecialitiesModel->code    = $D['code'];
            $SpecialitiesModel->university     = $D['university'];
            if($SpecialitiesModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    public function delSpecialities($id)
    {
        $SpecialitiesModel=SpecialitiesModel::find($id);
        if($SpecialitiesModel->delete()){
            return $this->ajaxReturn('已删除');
        }else{
            return $this->ajaxReturn('删除失败，请重试',-200);
        }
    }
}
