<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Validate;
use app\common\model\Posters as PostersModel;
use app\common\controller\Vip as VipController;
class Posters extends Base
{
    public function index()
    {
        if(request()->isAjax()){
            $G=request()->get();
            $where=[];
            if (!empty($G['key'])) 
                $where[]=['poster.title','like','%'.$G['key'].'%'];
            if ($G['status']!='all') 
                $where[]=['poster.status','=',$G['status']];
            if ($G['vip']!='all') 
                $where[]=['poster.vip','=',$G['vip']];
            $Data=PostersModel::alias('poster')->where($where)
                ->join('vip vip','vip.level=poster.level AND vip.is_company=1')
                ->order('poster.id desc')->field('poster.*,vip.title as vip_name')->paginate($G['pageSize'])->each(function($v){
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            $VipController=VipController::getCate([['vip.is_company','=',1]]);
            View::assign('vip',$VipController);
            return View::fetch();
        }
    }
    public function add()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'status'        => 'require',
                'path'          => 'require',
                'position_x'    => 'require',
                'position_y'    => 'require',
                'size'          => 'require',
            ];
            $msg  =   [
                'status.require'    => '请选择状态',
                'path.require'      => '请上传海报',
                'position_x.require'=> '请输入职位信息坐标',
                'position_y.require'=> '请输入职位信息坐标',
                'size.require'      => '请输入二维码尺寸',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $PostersModel=new PostersModel;
            $PostersModel->title            =   $D['title'];
            $PostersModel->tips             =   $D['tips'];
            $PostersModel->is_company       =   $D['is_company'];
            $PostersModel->path             =   $D['path'];
            $PostersModel->status           =   $D['status'];
            if($D['sort'])
            $PostersModel->sort             =   $D['sort'];
            $PostersModel->level            =   $D['level'];
            $PostersModel->position_x       =   $D['position_x'];
            $PostersModel->position_y       =   $D['position_y'];
            $PostersModel->size             =   $D['size'];
            if($PostersModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $VipController=VipController::getCate([['vip.is_company','=',1]]);
            View::assign('vip',$VipController);
            return View::fetch('add');
        }
    }
    public function edit($id)
    {
        if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'status'        => 'require',
                'path'          => 'require',
                'position_x'    => 'require',
                'position_y'    => 'require',
                'size'          => 'require',
            ];
            $msg  =   [
                'status.require'    => '请选择状态',
                'path.require'      => '请上传海报',
                'position_x.require'=> '请输入职位信息坐标',
                'position_y.require'=> '请输入职位信息坐标',
                'size.require'      => '请输入二维码尺寸',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $PostersModel=PostersModel::where(['id'=>$id])->find();
            $PostersModel->title            =   $D['title'];
            $PostersModel->tips             =   $D['tips'];
            $PostersModel->is_company       =   $D['is_company'];
            $PostersModel->path             =   $D['path'];
            $PostersModel->status           =   $D['status'];
            if($D['sort'])
            $PostersModel->sort             =   $D['sort'];
            $PostersModel->level            =   $D['level'];
            $PostersModel->position_x       =   $D['position_x'];
            $PostersModel->position_y       =   $D['position_y'];
            $PostersModel->size             =   $D['size'];
            if($PostersModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $PostersModel=PostersModel::where(['id'=>$id])->find();
            View::assign('Find',$PostersModel);
            $VipController=VipController::getCate([['vip.is_company','=',1]]);
            View::assign('vip',$VipController);
            return View::fetch('add');
        }
    }
    public function setStatus($id,$status)
    {
        $PostersModel=PostersModel::where(['id'=>$id])->find();
        $PostersModel->status=$status;
        if ($PostersModel->save()) {
            return $this->ajaxReturn('保存成功');
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function del($id)
    {
        $PostersModel=PostersModel::where(['id'=>$id])->find();
        if ($PostersModel->delete()) {
            return $this->ajaxReturn('已删除');
        }else{
            return $this->ajaxReturn('删除失败，请重试',-200);
        }
    }
}
