<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Cache;
use think\Validate;
use app\common\model\Orders as OrdersModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\NotifyAlipay as NotifyAlipayModel;
use app\common\model\NotifyWxpay as NotifyWxpayModel;
use app\common\model\NotifyApplepay as NotifyApplepayModel;
use app\common\model\NotifyToutiao as NotifyToutiaoModel;
use app\common\model\NotifyBaidu as NotifyBaiduModel;
class Orders extends Base
{
    public function index()
    {
        if(request()->isAjax()){
            $G=request()->get();
            $where=[];
            if (!empty($G['uid'])) 
                $where[]=['o.uid','=',$G['uid']];
            if (!empty($G['otrade'])) 
                $where[]=['o.otrade','=',$G['otrade']];
            if ($G['status']!='all') 
                $where[]=['o.status','=',$G['status']];
            if ($G['pay_type']!='all') 
                $where[]=['o.pay_type','=',$G['pay_type']];
            if (!empty($G['type'])){
                if (count($G['type'])==1) {
                    $where[]=['o.type','=',$G['type'][0]];
                }else{
                    $where[]=['o.type','in',$G['type']];
                }
            } 
            $whereTime=[];
            if (!empty($G['time'])) {
                $whereTime[]=$G['time'][0].' 00:00:00';
                $whereTime[]=$G['time'][1].'23:59:59';
            }
            $DataModel=OrdersModel::alias('o')->where($where);
            if (!empty($whereTime))
                $DataModel->whereTime('o.create_time','between',$whereTime);
            $Data=$DataModel->where(['type.alias'=>'vip/type'])
                ->join('user_info uinfo','uinfo.uid = o.uid')
                ->join('api_app app','app.app_id=o.channel_type')
                ->join('status_alias type','type.value=o.type')
                ->order('o.oid desc')->field('o.*,uinfo.nickname,uinfo.headimg,app.app_name as channel_type,type.title as type')->paginate($G['pageSize'])->each(function($v){
                    $v['nickname']=base64_decode($v['nickname']);
                    $v['headimg']=config('web.imgurl').$v['headimg'];
                    $v['expire_time']=$v['expire_time']?date('Y-m-d H:i:s',$v['expire_time']):'';
                    $v['pay_time']=$v['pay_time']?date('Y-m-d H:i:s',$v['pay_time']):'';
                    $v['finish_time']=$v['finish_time']?date('Y-m-d H:i:s',$v['finish_time']):'';
                    $v['cancel_time']=$v['cancel_time']?date('Y-m-d H:i:s',$v['cancel_time']):'';
                    $v['delete_time']=$v['delete_time']?date('Y-m-d H:i:s',$v['delete_time']):'';
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            $OrderType=StatusAliasModel::where(['alias'=>'vip/type'])->field('value,title')->select();
            View::assign('OrderType',$OrderType);
            return View::fetch();
        }
    }
    public function getPayInfo($pay_type,$otrade)
    {
        $NotifyModel=null;
        switch ($pay_type) {
            case 1:
                $NotifyModel=NotifyAlipayModel::where(['out_trade_no'=>$otrade])->find();
                break;
            case 2:
                $NotifyModel=NotifyWxpayModel::where(['out_trade_no'=>$otrade])->find();
                break;
            case 3:
                $NotifyModel=NotifyApplepayModel::where(['otrade'=>$otrade])->find();
                break;
            case 6:
                $NotifyModel=NotifyToutiaoModel::where(['cp_orderno'=>$otrade])->find();
                break;
            case 7:
                $NotifyModel=NotifyBaiduModel::where(['tp_order_id'=>$otrade])->find();
                break;
            default:
                return $this->ajaxReturn('无支付信息',-100);
                break;
        }
        if ($NotifyModel) {
            return $this->ajaxReturn('',0,$NotifyModel);
        }else{
            return $this->ajaxReturn('该订单的支付信息不存在~',-100);
        }
    }
}
