<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Validate;
use app\common\model\Menu as MenuModel;
class Menu extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            if (empty($G['id'])) {
                return $this->ajaxReturn('',0,MenuModel::getSelect(['pid'=>0]));
            }else{
                return $this->ajaxReturn('',0,MenuModel::getSelect(['pid'=>$G['id']]));
            }
        }else{
            return View::fetch();
        }
    }
    public function add()
    {
    	if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'title'         => 'require',
                'alias'         => 'unique:menu',
                'target'        => 'require',
                'status'        => 'require',
            ];
            $msg  =   [
                'title.require'     => '请输入名称',
                'alias.unique'      => '别名已存在',
                'target.require'    => '请选择窗口模式',
                'status.require'    => '请选择状态',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $MenuModel=new MenuModel;
            $MenuModel->pid        	=   $D['pid'];
            $MenuModel->title       =   $D['title'];
            $MenuModel->stitle      =   $D['stitle'];
            $MenuModel->icon        =   $D['icon'];
            $MenuModel->icon_is_img =   $D['icon_is_img'];
            $MenuModel->alias       =   $D['alias'];
            $MenuModel->cla         =   $D['cla'];
            $MenuModel->url        	=   $D['url'];
            $MenuModel->sort        =   intval($D['sort'])?intval($D['sort']):99;
            $MenuModel->target      =   $D['target'];
            $MenuModel->status      =   $D['status'];

            if($MenuModel->save()){
                $this->updateFileCache();
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
    	}else{
            View::assign('cate',MenuModel::getCate());
	        return View::fetch('add');
    	}
    }
    public function edit($id)
    {
    	if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'title'         => 'require',
                'alias'         => 'unique:menu',
                'target'        => 'require',
                'status'        => 'require',
            ];
            $msg  =   [
                'title.require'     => '请输入名称',
                'alias.unique'      => '别名已存在',
                'target.require'    => '请选择窗口模式',
                'status.require'    => '请选择状态',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $MenuModel=MenuModel::where(['id'=>$id])->find();
            $MenuModel->pid         =   $D['pid'];
            $MenuModel->title       =   $D['title'];
            $MenuModel->stitle      =   $D['stitle'];
            $MenuModel->icon        =   $D['icon'];
            $MenuModel->icon_is_img =   $D['icon_is_img'];
            $MenuModel->alias       =   $D['alias'];
            $MenuModel->cla         =   $D['cla'];
            $MenuModel->url         =   $D['url'];
            $MenuModel->sort        =   intval($D['sort'])?intval($D['sort']):99;
            $MenuModel->target      =   $D['target'];
            $MenuModel->status      =   $D['status'];
            if($MenuModel->save()){
                $this->updateFileCache();
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
    	}else{
            $MenuModel=MenuModel::where(['id'=>$id])->find();
            View::assign('Find',$MenuModel);
            View::assign('cate',MenuModel::getCate());
	        return View::fetch('add');
    	}
    }
    public function setStatus($id,$status)
    {
        $MenuModel=MenuModel::where(['id'=>$id])->find();
        $MenuModel->status=$status;
        if ($MenuModel->save()) {
            $this->updateFileCache();
            return $this->ajaxReturn('保存成功');
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function del($id)
    {
        if (MenuModel::where(['pid'=>$id])->count()) {
            return $this->ajaxReturn('该导航栏下级不为空，请先删除',-200);
        }else{
            $MenuModel=MenuModel::where(['id'=>$id])->find();
            if ($MenuModel->delete()) {
                $this->updateFileCache();
                return $this->ajaxReturn('已删除');
            }else{
                return $this->ajaxReturn('删除失败，请重试',-200);
            }
        }
    }
    public function updateFileAjax()
    {
        $this->updateFileCache();
        return $this->ajaxReturn('已更新');
    }
    public function updateFileCache()
    {
        $MenuCache=MenuModel::getCache()->toArray();
        foreach ($MenuCache as $k => $v) {
            if ($v['alias'])
                Cache::set('menu.'.$v['alias'],$v);
        }
    }
}
