<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Validate;
use app\common\model\Links as LinksModel;
use app\common\controller\Links as LinksController;
class Links extends Base
{
    public function index()
    {
        if(request()->isAjax()){
            $G=request()->get();
            $where=[];
            if (!empty($G['key'])) 
                $where[]=['title','like','%'.$G['key'].'%'];
            if (!empty($G['url'])) 
                $where[]=['url','like','%'.$G['url'].'%'];
            if ($G['status']!='all') 
                $where[]=['status','=',$G['status']];
            $Data=LinksModel::where($where)
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function add()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'title'         => 'require|max:50',
                'url'           => 'require|url',
                'status'        => 'require',
            ];
            $msg  =   [
                'title.require'     => '名称不能为空', 
                'title.max'         => '名称不能超过50个字符',
                'url.require'       => '链接不能为空',
                'url.url'           => '链接格式不正确',
                'status.require'    => '请选择状态',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $LinksModel=new LinksModel;
            $LinksModel->title        =   $D['title'];
            $LinksModel->url          =   $D['url'];
            $LinksModel->is_examine   =   1;
            $LinksModel->status       =   $D['status'];
            $LinksModel->sort       =   $D['sort'];
            if($LinksModel->save()){
                $this->cacheLink();
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch('add');
        }
    }
    public function edit($id)
    {
        if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'title'         => 'require|max:50',
                'url'           => 'require|url',
                'status'        => 'require',
            ];
            $msg  =   [
                'title.require'     => '名称不能为空', 
                'title.max'         => '名称不能超过50个字符',
                'url.require'       => '链接不能为空',
                'url.url'           => '链接格式不正确',
                'status.require'    => '请选择状态',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $LinksModel=LinksModel::where(['id'=>$id])->find();
            $LinksModel->title        =   $D['title'];
            $LinksModel->url          =   $D['url'];
            $LinksModel->is_examine   =   1;
            $LinksModel->status       =   $D['status'];
            $LinksModel->sort           =   $D['sort'];
            if($LinksModel->save()){
                $this->cacheLink();
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $LinksModel=LinksModel::where(['id'=>$id])->find();
            View::assign('Find',$LinksModel);
            return View::fetch('add');
        }
    }
    public function setStatus($id,$status)
    {
        $LinksModel=LinksModel::where(['id'=>$id])->find();
        $LinksModel->status=$status;
        $LinksModel->is_examine=1;
        if ($LinksModel->save()) {
            $this->cacheLink();
            return $this->ajaxReturn('保存成功');
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function del($id)
    {
        $LinksModel=LinksModel::where(['id'=>$id])->find();
        if ($LinksModel->delete()) {
            $this->cacheLink();
            return $this->ajaxReturn('已删除');
        }else{
            return $this->ajaxReturn('删除失败，请重试',-200);
        }
    }
    public function cacheLink()
    {
        $Data=LinksController::getSelect();
        Cache::set('links',$Data);
        return $this->ajaxReturn('保存成功');
    }
}
