<?php
namespace app\bsadmin\controller;
use think\facade\Cache;
use think\facade\Session;
use think\facade\View;
use think\facade\Db;
use think\facade\Validate;
use think\helper\Str;
use app\common\model\Jobs as JobsModel;
use app\common\model\Company as CompanyModel;
use app\common\model\JobsExamineLog as JobsExamineLogModel;
use app\common\model\JobsRefreshAuto as JobsRefreshAutoModel;
use app\common\model\JobsCate as JobsCateModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\InviteAninterview as InviteAninterviewModel;
use app\common\model\Feedback as FeedbackModel;
use app\common\model\PushTask as PushTaskModel;
use app\common\model\JobsExtensionLog as JobsExtensionLogModel;
use app\common\controller\Jobs as JobsController;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;
class Jobs extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=$this->getSearchJobsWhere();
            $Data=JobsModel::alias('jobs')->where($where)
                ->join('company company','company.id = jobs.company_id')
                ->join('user_vip user_vip','user_vip.uid = company.uid','LEFT')
                ->join('vip vip','vip.level = user_vip.company_vip_level AND vip.is_company=1','LEFT')
                ->join('api_app app','app.app_id = jobs.app_id')
                ->field('jobs.*,company.uid,company.title as company_name,company.attestation,app.app_name,vip.title as vip_title,user_vip.company_vip_time')
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                    $v['refresh_time']=$v['refresh_time']?date('Y-m-d H:i',$v['refresh_time']):'';
                    $v['top_time']=$v['top']&&$v['top_time']?date('Y-m-d H:i:s',$v['top_time']):'';
                    $v['recommend_time']=$v['recommend']&&$v['recommend_time']?date('Y-m-d H:i:s',$v['recommend_time']):'';
                    $v['delete_time']=$v['delete_time']?date('Y-m-d H:i:s',$v['delete_time']):'';
                    $v['urgent_time']=$v['urgent']&&$v['urgent_time']>time()?date('Y-m-d H:i:s',$v['urgent_time']):'';
                    $v['company_vip_time']=$v['company_vip_time']&&$v['company_vip_time']>time()?date('Y-m-d',$v['company_vip_time']):'';
                    $v['delivery_resume_not']=JobsDeliveryResumeModel::where(['jobs_id'=>$v->id,'status'=>0])->count();
                    $v['invite_an_interview']=InviteAninterviewModel::where(['jobs_id'=>$v->id])->count();
                    $v['log']=JobsExamineLogModel::where(['jobs_id'=>$v->id])->limit(10)->order('id desc')->select();
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            $attestation=StatusAliasModel::getCate('company/attestation');
            View::assign('attestation',$attestation);
            return View::fetch();
        }
    }
    public function getSearchJobsWhere()
    {
        $G=request()->get();
        $where=[];
        if ($G['key']) {
            switch($G['search_type']){
                case 'id':
                    $where[]=['jobs.id','=',$G['key']];
                    break;
                case 'company_id':
                    $where[]=['jobs.company_id','=',$G['key']];
                    break;
                case 'uid':
                    $where[]=['company.uid','=',$G['key']];
                    break;
                case 'company_name':
                    $where[]=['company.title','like','%'.$G['key'].'%'];
                    break;
            }
        }
        if ($G['attestation']!='all') {
            $where[]=['company.attestation','=',$G['attestation']];
        }
        if ($G['examine']!='all') {
            $where[]=['jobs.examine','=',$G['examine']];
        }
        return $where;
    }
    public function exportJobs()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=$this->getSearchJobsWhere();
            $Field=[
                'jobs.*',
                'desc.jobs_desc',
                'contacts.jobs_id,contacts.contacts,contacts.contacts_mobile,contacts.contacts_tel,contacts.contacts_email,contacts.contacts_address,contacts.contacts_lng,contacts.contacts_lat,contacts.contacts_lng,contacts.contacts_type',
                'company.uid,company.title as company_name,company.stitle as company_sname,company.logo as company_logo',
                'education.title as education_level',
                'exp_level.title as exp_level',
                'user_timer.online_time',
                'province.title as jobs_province,city.title as jobs_city,area.title as jobs_area',
                'jobs_cate.title as jobs_cate_text',
                'nature.title as nature,finance.title as finance,size_type.title as size_type,industry.title as industry',
                'app.app_name',
            ];
            $Data=JobsModel::alias('jobs')->where($where)
                ->where(['education.alias'=>'jobs/education_level'])
                ->where(['exp_level.alias'=>'jobs/exp_level'])
                ->where(['nature.alias'=>'company/nature'])
                ->where(['finance.alias'=>'company/finance'])
                ->where(['size_type.alias'=>'company/size_type'])
                ->join('company company','company.id=jobs.company_id')
                ->join('jobs_cate jobs_cate','jobs_cate.id=jobs.jobs_cate3')
                ->join('user_timer user_timer','user_timer.uid = company.uid','LEFT')
                ->join('jobs_desc desc','desc.jobs_id=jobs.id','LEFT')
                ->join('jobs_contacts contacts','contacts.jobs_id=jobs.id','LEFT')
                ->join('status_alias education','education.value=jobs.education_level')
                ->join('status_alias exp_level','exp_level.value=jobs.exp_level','LEFT')
                ->join('status_alias nature','nature.value=company.nature')
                ->join('status_alias finance','finance.value=company.finance')
                ->join('status_alias size_type','size_type.value=company.size_type')
                ->join('company_industry industry','industry.id = company.industry_id')
                ->join('area province','province.id = jobs.jobs_area1','LEFT')
                ->join('area city','city.id = jobs.jobs_area2','LEFT')
                ->join('area area','area.id = jobs.jobs_area3','LEFT')
                ->join('api_app app','app.app_id = jobs.app_id','LEFT')
                ->field(implode(",",$Field))
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                    $v['app_name']=$v['app_name']?$v['app_name']:'后台添加';
                    $v['refresh_time']=$v['refresh_time']?date('Y-m-d H:i',$v['refresh_time']):'';
                    $v['resume_not']=JobsDeliveryResumeModel::where(['jobs_id'=>$v->id,'status'=>0])->count();
                    $v['invite_aninterview']=InviteAninterviewModel::where(['jobs_id'=>$v->id])->count();
                    return $v;
                });
            if ($Data->items()) {
                $title = [
                    ['title'=>'ID','key'=>'id'],
                    ['title'=>'UID','key'=>'uid'],
                    ['title'=>'企业名称','key'=>'company_name'],
                    ['title'=>'职位名称','key'=>'title'],
                    ['title'=>'工作地区','key'=>'area'],
                    ['title'=>'薪资待遇(k)','key'=>'salary'],
                    ['title'=>'学历要求','key'=>'education_level'],
                    ['title'=>'经验要求','key'=>'exp_level'],
                    ['title'=>'招聘人数','key'=>'number_of_recruiters'],
                    ['title'=>'职位类别','key'=>'jobs_cate_text'],
                    ['title'=>'审核状态','key'=>'examine'],
                    ['title'=>'展示状态','key'=>'status'],
                    ['title'=>'已投递','key'=>'delivery_resume'],
                    ['title'=>'浏览数','key'=>'view'],
                    ['title'=>'未查看','key'=>'resume_not'],
                    ['title'=>'已面试','key'=>'invite_aninterview'],
                    ['title'=>'发布来源','key'=>'app_name'],
                    ['title'=>'创建时间','key'=>'create_time'],
                    ['title'=>'刷新时间','key'=>'refresh_time']
                ];
                $spreadsheet = new Spreadsheet;
                $sheet = $spreadsheet->getActiveSheet();
             
                //表头
                //设置单元格内容
                $titCol = 'A';
                foreach ($title as $key => $v) {
                    // 单元格内容写入
                    $sheet->setCellValue($titCol . '1', $v['title']);
                    $titCol++;
                }
                $row=2;
                foreach($Data->items() as $item){
                    $dataCol='A';
                    foreach ($title as $key => $v) {
                        switch ($v['key']) {
                            case 'area':
                                $sheet->setCellValue($dataCol.$row, $item->jobs_province.$item->jobs_city.$item->jobs_area);
                                break;
                            case 'examine':
                                switch ($item->examine) {
                                    case 0:
                                        $sheet->setCellValue($dataCol.$row, '未审核');
                                        break;
                                    case 1:
                                        $sheet->setCellValue($dataCol.$row, '已审核');
                                        break;
                                    case 2:
                                        $sheet->setCellValue($dataCol.$row, '未通过');
                                        break;
                                }
                                break;
                            case 'status':
                                switch ($item->status) {
                                    case 0:
                                        $sheet->setCellValue($dataCol.$row, '未展示');
                                        break;
                                    case 1:
                                        $sheet->setCellValue($dataCol.$row, '展示中');
                                        break;
                                    case 2:
                                        $sheet->setCellValue($dataCol.$row, '已删除');
                                        break;
                                }
                                break;
                            case 'salary':
                                $salary_min=$item->salary_min;
                                $salary_max=$item->salary_max;
                                if ($salary_min>0) {
                                    $sheet->setCellValue($dataCol.$row, $salary_min.'-'.$salary_max);
                                }else{
                                    $sheet->setCellValue($dataCol.$row, '面议');
                                }
                                break;
                            case 'number_of_recruiters':
                                if ($item->number_of_recruiters>0) {
                                    $sheet->setCellValue($dataCol.$row, $item->number_of_recruiters);
                                }else{
                                    $sheet->setCellValue($dataCol.$row, '若干');
                                }
                                break;
                            default:
                                $sheet->setCellValue($dataCol.$row, $item[$v['key']]);
                                break;
                        }
                        $dataCol++;
                    }
                    $row++;
                }
                $filename='output/jobs/'.Session::get('AdminUser.uid').'_'.date('YmdHis').Str::random(4).'.xlsx';
                if (!file_exists(dirname($filename)))
                    mkdir(dirname($filename), 0777, true);
                $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
                $writer->save($filename);
                return $this->ajaxReturn('生成~',0,['url'=>'/'.$filename]);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }
    }
    public function setJobsExamine($id,$status,$msg='')
    {
        $JobsModel=JobsModel::alias('jobs')->where(['jobs.id'=>$id])
        ->join('company company','company.id=jobs.company_id')
        ->field('jobs.*,company.uid')
        ->find();
        if($JobsModel->delete_time){
            $JobsModel->examine=1;
            $JobsModel->save();
            return $this->ajaxReturn('已保存');
        }
        $G=request()->get();
        if ($status==1) {
            $JobsModel->examine=1;
            $JobsModel->status=1;
            $JobsExamineLogModel=new JobsExamineLogModel;
            $JobsExamineLogModel->jobs_id=$JobsModel->id;
            $JobsExamineLogModel->status=1;
            $JobsExamineLogModel->msg='审核通过';
            $JobsExamineLogModel->admin_uid=Session::get('AdminUser.uid');
            $JobsExamineLogModel->ip=request()->ip();
            $PushTaskModel=null;
            if(!empty($G['notice'])){
                $PushTaskModel=new PushTaskModel;
                $PushTaskModel->event       =   'JobsExamine';
                $PushTaskModel->uid         =   $JobsModel->uid;
                $PushData=$JobsModel->toArray();
                $PushData['hi_text']='恭喜您';
                $PushData['status']='已通过';
                $PushData['msg']='通过';
                $PushData['time']=date('Y-m-d H:i:s');
                $PushTaskModel->data        =   json_encode($PushData,JSON_UNESCAPED_UNICODE);
            }
            // 启动事务
            Db::startTrans();
            try {
                $JobsModel->save();
                if($PushTaskModel)$PushTaskModel->save();
                $JobsExamineLogModel->save();
                // 提交事务
                Db::commit();
                return $this->ajaxReturn('已保存');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return $this->ajaxReturn('保存失败，请重试',-100);
            }
        }else{
            $JobsModel->examine=2;
            $JobsModel->status=0;
            $JobsExamineLogModel=new JobsExamineLogModel;
            $JobsExamineLogModel->jobs_id=$JobsModel->id;
            $JobsExamineLogModel->status=2;
            $JobsExamineLogModel->msg=$msg;
            $JobsExamineLogModel->admin_uid=Session::get('AdminUser.uid');
            $JobsExamineLogModel->ip=request()->ip();
            $PushTaskModel=null;
            if(!empty($G['notice'])){
                $PushTaskModel=new PushTaskModel;
                $PushTaskModel->event       =   'JobsExamine';
                $PushTaskModel->uid         =   $JobsModel->uid;
                $PushData=$JobsModel->toArray();
                $PushData['hi_text']='很遗憾';
                $PushData['status']='未通过';
                $PushData['msg']=$msg;
                $PushData['time']=date('Y-m-d H:i:s');
                $PushTaskModel->data        =   json_encode($PushData,JSON_UNESCAPED_UNICODE);
            }
            // 启动事务
            Db::startTrans();
            try {
                $JobsModel->save();
                if($PushTaskModel)$PushTaskModel->save();
                $JobsExamineLogModel->save();
                // 提交事务
                Db::commit();
                return $this->ajaxReturn('已保存');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return $this->ajaxReturn('保存失败，请重试',-100);
            }
        }
    }
    public function refreshJobs($id)
    {
        $JobsModel=JobsModel::where(['id'=>$id])->find();
        $JobsModel->refresh_time=time();
        if($JobsModel->save()){
            return $this->ajaxReturn('已刷新',0,['refresh_time'=>date('Y-m-d H:i',$JobsModel->refresh_time)]);
        }else{
            return $this->ajaxReturn('刷新失败，请重试',-100);
        }
    }
    public function jobsRefresh()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['key']) {
                switch($G['search_type']){
                    case 'uid':
                        $where[]=['refresh.uid','=',$G['key']];
                        break;
                    case 'jobs_id':
                        $where[]=['refresh.jobs_id','=',$G['key']];
                        break;
                }
            }
            if ($G['status']!='all') {
                $where[]=['refresh.status','=',$G['status']];
            }
            $Data=JobsRefreshAutoModel::alias('refresh')->where($where)
                ->join('jobs jobs','jobs.id = refresh.jobs_id')
                ->field('refresh.*,jobs.title')
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                    $v['start_time']=$v['start_time']?date('Y-m-d H:i:s',$v['start_time']):'';
                    $v['end_time']=$v['end_time']?date('Y-m-d H:i:s',$v['end_time']):'';
                    $v['next_time']=$v['next_time']?date('Y-m-d H:i:s',$v['next_time']):'';
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function addJobs($company_id)
    {
        $CompanyModel=CompanyModel::where(['id'=>$company_id])->find();
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$CompanyModel->uid;
            $D['app_id']=1;
            /*
            *  调用公共保存职位方法
            *  app\common\controller\Jobs
            */
            return JobsController::releaseJobs($D);
        }else{
            if(!$CompanyModel)
                return redirect('/unauthorized?msg=企业不存在');
            if(config('xy_company.is_forceattestation')
                &&$CompanyModel->attestation!=3)
                return redirect('/unauthorized?msg=该企业未完成企业认证');
            return View::fetch();
        }
    }
    public function editJobs($company_id,$id)
    {
        $CompanyModel=CompanyModel::where(['id'=>$company_id])->find();
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$CompanyModel->uid;
            $D['id']=$id;
            /*
            *  调用公共保存职位方法
            *  app\common\controller\Jobs
            */
            return JobsController::saveJobs($D);
        }else{
            $D['company_id']=$company_id;
            $D['id']=$id;
            View::assign('Find',JobsController::getJobsInfoAll($D));
            return View::fetch('add_jobs');
        }
    }
    public function delivery_resume()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['key']) {
                switch($G['search_type']){
                    case 'company_id':
                        $where[]=['d.company_id','=',$G['key']];
                        break;
                    case 'resume_id':
                        $where[]=['d.resume_id','=',$G['key']];
                        break;
                    case 'company_name':
                        $where[]=['company.title','like','%'.$G['key'].'%'];
                        break;
                }
            }
            $Data=JobsDeliveryResumeModel::alias('d')
                ->where($where)
                ->where(['edu.alias'=>'resume/educational_background'])
                ->join('company company','company.id=d.company_id')
                ->join('resume resume','resume.id=d.resume_id')
                ->join('jobs jobs','jobs.id=d.jobs_id')
                ->join('status_alias edu','edu.value=resume.educational_background')
                ->order('d.id desc')
                ->field('d.*,resume.name,resume.sex,resume.age,resume.work_experience_time,edu.title as educational_background,company.title as company_name,company.stitle as scompany_name,jobs.title as jobs_name')->paginate($G['pageSize'])
                ->each(function($item, $key){
                    return $item;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            $jobs_delivery=StatusAliasModel::getCate('jobs/delivery');
            View::assign('jobs_delivery',$jobs_delivery);
            return View::fetch();
        }
    }
    public function setJobsStatus($id,$status)
    {
        $JobsModel=JobsModel::find($id);
        $JobsModel->status=$status;
        if ($JobsModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setJobsTop()
    {
        $D=request()->post();
        if(empty($D['id'])) return $this->ajaxReturn('职位不存在',-100);
        $JobsModel=JobsModel::alias('jobs')->where(['jobs.id'=>$D['id']])
            ->join('company company','company.id=jobs.company_id')
            ->field('jobs.id,jobs.top,jobs.top_time,company.uid')->find();
        $top=0;
        if(!empty($D['top']))$top=1;
        $accumulation=0;
        if(!empty($D['accumulation']))$accumulation=1;
        $JobsModel->top=$top;
        $end_time=time();
        if($top){
            if($accumulation){
                if($JobsModel->top_time){
                    $end_time=$JobsModel->top_time+3600*24*intval($D['top']);
                }else{
                    $end_time=time()+3600*24*intval($D['top']);
                }
            }else{
                $end_time=time()+3600*24*intval($D['top']);
            }
        }
        $JobsModel->top_time=$end_time;
        $JobsExtensionLogModel=new JobsExtensionLogModel;
        $JobsExtensionLogModel->uid=$JobsModel->uid;
        $JobsExtensionLogModel->jobs_id=$JobsModel->id;
        $JobsExtensionLogModel->vid=0;
        $JobsExtensionLogModel->type=4;
        $JobsExtensionLogModel->value=intval($D['top']);
        $JobsExtensionLogModel->start_time=time();
        $JobsExtensionLogModel->end_time=$end_time;
        $JobsExtensionLogModel->admin_uid=Session::get('AdminUser.uid');
        // 启动事务
        Db::startTrans();
        try {
            $JobsModel->save();
            $JobsExtensionLogModel->save();
            // 提交事务
            Db::commit();
            $JobsModel->top_time=date('Y-m-d H:i:s',$JobsModel->top_time);
            return $this->ajaxReturn('',0,$JobsModel);
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setJobsRecommend()
    {
        $D=request()->post();
        if(empty($D['id'])) return $this->ajaxReturn('职位不存在',-100);
        $JobsModel=JobsModel::alias('jobs')->where(['jobs.id'=>$D['id']])
            ->join('company company','company.id=jobs.company_id')
            ->field('jobs.id,jobs.recommend,jobs.recommend_time,company.uid')->find();
        $recommend=0;
        if(!empty($D['recommend']))$recommend=1;
        $accumulation=0;
        if(!empty($D['accumulation']))$accumulation=1;
        $JobsModel->recommend=$recommend;
        $end_time=time();
        if($recommend){
            if($accumulation){
                if($JobsModel->recommend_time){
                    $end_time=$JobsModel->recommend_time+3600*24*intval($D['recommend']);
                }else{
                    $end_time=time()+3600*24*intval($D['recommend']);
                }
            }else{
                $end_time=time()+3600*24*intval($D['recommend']);
            }
        }
        $JobsModel->recommend_time=$end_time;
        $JobsExtensionLogModel=new JobsExtensionLogModel;
        $JobsExtensionLogModel->uid=$JobsModel->uid;
        $JobsExtensionLogModel->jobs_id=$JobsModel->id;
        $JobsExtensionLogModel->vid=0;
        $JobsExtensionLogModel->type=5;
        $JobsExtensionLogModel->value=intval($D['recommend']);
        $JobsExtensionLogModel->start_time=time();
        $JobsExtensionLogModel->end_time=$end_time;
        $JobsExtensionLogModel->admin_uid=Session::get('AdminUser.uid');
        // 启动事务
        Db::startTrans();
        try {
            $JobsModel->save();
            $JobsExtensionLogModel->save();
            // 提交事务
            Db::commit();
            $JobsModel->recommend_time=date('Y-m-d H:i:s',$JobsModel->recommend_time);
            return $this->ajaxReturn('',0,$JobsModel);
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setJobsUrgent()
    {
        $D=request()->post();
        if(empty($D['id'])) return $this->ajaxReturn('职位不存在',-100);
        $JobsModel=JobsModel::alias('jobs')->where(['jobs.id'=>$D['id']])
            ->join('company company','company.id=jobs.company_id')
            ->field('jobs.id,jobs.urgent,jobs.urgent_time,company.uid')->find();
        $urgent=0;
        if(!empty($D['urgent']))$urgent=1;
        $accumulation=0;
        if(!empty($D['accumulation']))$accumulation=1;
        $JobsModel->urgent=$urgent;
        $end_time=time();
        if($urgent){
            if($accumulation){
                if($JobsModel->urgent_time){
                    $end_time=$JobsModel->urgent_time+3600*24*intval($D['urgent']);
                }else{
                    $end_time=time()+3600*24*intval($D['urgent']);
                }
            }else{
                $end_time=time()+3600*24*intval($D['urgent']);
            }
        }
        $JobsModel->urgent_time=$end_time;
        $JobsExtensionLogModel=new JobsExtensionLogModel;
        $JobsExtensionLogModel->uid=$JobsModel->uid;
        $JobsExtensionLogModel->jobs_id=$JobsModel->id;
        $JobsExtensionLogModel->vid=0;
        $JobsExtensionLogModel->type=5;
        $JobsExtensionLogModel->value=intval($D['urgent']);
        $JobsExtensionLogModel->start_time=time();
        $JobsExtensionLogModel->end_time=$end_time;
        $JobsExtensionLogModel->admin_uid=Session::get('AdminUser.uid');
        // 启动事务
        Db::startTrans();
        try {
            $JobsModel->save();
            $JobsExtensionLogModel->save();
            // 提交事务
            Db::commit();
            $JobsModel->urgent_time=date('Y-m-d H:i:s',$JobsModel->urgent_time);
            return $this->ajaxReturn('',0,$JobsModel);
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function cate()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            if (empty($G['cid'])) {
                return $this->ajaxReturn('',0,JobsCateModel::getSelect(['pid'=>0]));
            }else{
                return $this->ajaxReturn('',0,JobsCateModel::getSelect(['pid'=>$G['cid']]));
            }
        }else{
            return View::fetch();
        }
    }
    /**
     * 编辑文章分类
     */
    public function editJobsCate($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'title'     => 'require|max:50',
	            'alias'  	=> 'unique:jobsCate',
            ];
            $msg  =   [
                'title.require' => 'Title 不能为空', 
                'title.max'     => 'Title 不能超过50个字符',
	            'alias.unique' 	=> '别名已存在',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $JobsCateModel=JobsCateModel::find($id);
            $JobsCateModel->title    = $D['title'];
            $JobsCateModel->alias    = $D['alias'];
            $JobsCateModel->icon     = $D['icon'];
            $JobsCateModel->status     = $D['status'];
            if (!empty($D['pid'])) {
	            $JobsCateModel->pid   	= $D['pid'];
            }else{
                $JobsCateModel->pid     = 0;
            }
            if (!empty($D['sort'])) 
            	$JobsCateModel->sort   	= $D['sort'];
            if($JobsCateModel->save()){
                $this->setCacheJobsCate();
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $cate=JobsCateModel::getCate()->toArray();
            View::assign('cate',$cate);
            $Find=JobsCateModel::where(['id'=>$id])->find();
            View::assign('Find',$Find);
            return View::fetch('add_jobs_cate');
        }
    }
    public function setJobsCateStatus($id,$status)
    {
        $JobsCateModel=JobsCateModel::find($id);
        $JobsCateModel->status=$status;
        if ($JobsCateModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    /**
     * 添加文章分类
     */
    public function addJobsCate()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'title'     => 'require|max:50',
	            'alias'  	=> 'unique:jobsCate',
            ];
            $msg  =   [
                'title.require' => 'Title 不能为空', 
                'title.max'     => 'Title 不能超过50个字符',
	            'alias.unique' 	=> '别名已存在',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $JobsCateModel=new JobsCateModel;
            $JobsCateModel->title    = $D['title'];
            $JobsCateModel->alias    = $D['alias'];
            $JobsCateModel->icon     = $D['icon'];
            $JobsCateModel->status   = $D['status'];
            if (!empty($D['pid'])) 
	            $JobsCateModel->pid   	= $D['pid'];
            if (!empty($D['sort'])) 
            	$JobsCateModel->sort   	= $D['sort'];
            if($JobsCateModel->save()){
                $this->setCacheJobsCate();
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $cate=JobsCateModel::getCate()->toArray();
            View::assign('cate',$cate);
            return View::fetch();
        }
    }
    public function setCacheJobsCate()
    {
        $Data=JobsCateModel::getCache();
        Cache::set('jobs_cate',$Data->toArray());
        return $this->ajaxReturn('保存成功');
    }
    public function inviteAnInterview()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['key']) {
                switch($G['search_type']){
                    case 'company_id':
                        $where[]=['i.company_id','=',$G['key']];
                        break;
                    case 'resume_id':
                        $where[]=['i.resume_id','=',$G['key']];
                        break;
                    case 'company_name':
                        $where[]=['company.title','like','%'.$G['key'].'%'];
                        break;
                }
            }
	        $Data=InviteAninterviewModel::alias('i')
	            ->where($where)
	            ->where(['edu.alias'=>'resume/educational_background'])
	            ->join('jobs jobs','jobs.id=i.jobs_id')
	            ->join('company company','company.id=i.company_id')
	            ->join('resume resume','resume.id=i.resume_id')
	            ->join('status_alias edu','edu.value=resume.educational_background')
	            ->order('i.id desc')
	            ->field('i.*,jobs.title,company.title as company_name,company.stitle as scompany_name,resume.name,resume.sex,resume.age,resume.work_experience_time,edu.title as educational_background')->paginate($G['pageSize'])
	            ->each(function($item, $key){
	                $item['interview_date']=date('Y年m月d日',$item['interview_date']);
	                $item['interview_start_time']=date('H:i',$item['interview_start_time']);
	                $item['interview_end_time']=date('H:i',$item['interview_end_time']);
	                return $item;
	            });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function job_complaints()
    {
        View::assign('type',7);
        return View::fetch('feedback/index');
    }
}
