<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Validate;
use app\bsadmin\model\Config as ConfigModel;
use app\common\model\Invoice as InvoiceModel;
class Invoice extends Base
{
    public function index()
    {
    	if(request()->isAjax()){
            $G=request()->get();
            $where=[];
            if ($G['key']) {
                switch($G['search_type']){
                    case 'uid':
                        $where[]=['i.uid','=',$G['key']];
                        break;
                    case 'invoice_title':
                        $where[]=['info.invoice_title','like','%'.$G['key'].'%'];
                        break;
                    case 'invoice_number':
                        $where[]=['i.invoice_number','=',$G['key']];
                        break;
                    case 'courier_number':
                        $where[]=['i.courier_number','=',$G['key']];
                        break;
                }
            }
            $Data=InvoiceModel::alias('i')->where($where)
                ->join('user_info m','m.uid = i.uid')
            	->join('invoice_info info','info.iid=i.id')
                ->join('invoice_mail_address address','address.iid = i.id')
                ->join('area area1','area1.id = address.area1')
                ->join('area area2','area2.id = address.area2')
                ->join('area area3','area3.id = address.area3')
                ->field('i.*,m.nickname,m.headimg,info.type,info.invoice_title,info.invoice_type,info.invoice_uscc,info.bank_of_deposit,info.basic_deposit_account,info.reg_address,info.reg_tel,address.name,address.name,address.area1,address.area2,address.area3,address.address,address.mobile,address.postcode,area1.title as area1_text,area2.title as area2_text,area3.title as area3_text')
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                	$v['nickname']=base64_decode($v['nickname']);
                	$v['headimg']=config('web.imgurl').$v['headimg'];
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
    	}else{
    		return View::fetch();
    	}
    }
    public function setting()
    {
        $Data=ConfigModel::getList(['ctype'=>'xy_invoice']);
        View::assign('Data',$Data);
        View::assign('ctype','xy_invoice');
        return View::fetch('setting/basic');
    }
    public function setStatus()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $rule =   [
                'id'            => 'require',
                'invoice_number'=> 'require',
                'courier'       => 'require',
                'courier_number'=> 'require',
            ];
            $msg  =   [
                'id.require'                => '为获取到发票信息', 
                'invoice_number.require'    => '发票编码不能为空', 
                'courier.require'           => '物流公司不能为空', 
                'courier_number.require'    => '物流编码不能为空', 
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $InvoiceModel=InvoiceModel::where(['id'=>$D['id']])->find();
            $InvoiceModel->invoice_number   =  $D['invoice_number'];
            $InvoiceModel->courier          =  $D['courier'];
            $InvoiceModel->courier_number   =  $D['courier_number'];
            $InvoiceModel->status           =  1;
            if ($InvoiceModel->save()) {
                return $this->ajaxReturn('已保存');
            }else{
                return $this->ajaxReturn('处理失败，请重试',-100);
            }
        }
    }
}
