<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Db;
use app\common\model\UserInfo as UserInfoMode;
use app\common\model\Jobs as JobsModel;
use app\common\model\JobsRefreshLog as JobsRefreshLogModel;
use app\common\model\ResumeDownloaded as ResumeDownloadedModel;
use app\common\model\Orders as OrdersModel;
use app\common\model\Resume as ResumeModel;
use app\common\model\ResumeRefreshLog as ResumeRefreshLogModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\UserRealName as UserRealNameModel;
use app\common\model\CompanyDemeanor as CompanyDemeanorModel;
use app\common\model\ResumeWorks as ResumeWorksModel;
use app\common\model\Feedback as FeedbackModel;
use app\common\model\Statistics as StatisticsModel;
class Index extends Base
{
    public function index()
    {
    	$System=[
    		'sys'=>PHP_OS,
    		'sys_r'=>php_uname('r'),
    		'software'=>$_SERVER['SERVER_SOFTWARE'],
    		'mysql_version'=>Db::query('select VERSION()')[0]['VERSION()'],
    		'php_version'=>PHP_VERSION,
    	];
        $SystemInfo=@file_get_contents(root_path()."VERSION/version.json");
        View::assign('SystemInfo',$SystemInfo);
        View::assign('System',$System);
    	return View::fetch();
    }
    public function statistics()
    {
    	$Data=[
    		'company_new_user'			=>	UserInfoMode::where(['role_type'=>1])->whereDay('create_time')->count(),
			'company_jobs_sum'			=>	JobsModel::whereDay('create_time')->count(),
			'company_jobs_refresh'		=>	JobsRefreshLogModel::whereDay('create_time')->count(),
			'company_download_resume'	=>	ResumeDownloadedModel::whereDay('create_time')->count(),
			'company_order'				=>	OrdersModel::where(['is_company'=>1,'status'=>2])->whereDay('create_time')->count(),
			'company_order_price'		=>	OrdersModel::where(['is_company'=>1,'status'=>2])->whereDay('create_time')->sum('oprice'),
			'personal_new_user'			=>	UserInfoMode::where(['role_type'=>0])->whereDay('create_time')->count(),
			'personal_resume'			=>	ResumeModel::whereDay('create_time')->count(),
			'personal_refresh'			=>	ResumeRefreshLogModel::whereDay('create_time')->count(),
			'personal_delivery_resume'	=>	JobsDeliveryResumeModel::whereDay('create_time')->count(),
			'personal_order'			=>	OrdersModel::where(['is_company'=>0,'status'=>2])->whereDay('create_time')->count(),
			'personal_order_price'		=>	OrdersModel::where(['is_company'=>0,'status'=>2])->whereDay('create_time')->sum('oprice'),
    	];
    	return $this->ajaxReturn('',0,$Data);
    }
    public function todoStatistics()
    {
    	$Data=[
    		'company_attestation'			=>	UserRealNameModel::where(['id_type'=>1,'status'=>0])->count(),
			'company_jobs_examine'			=>	JobsModel::where(['examine'=>0])->count(),
			'company_demeanor'		=>	CompanyDemeanorModel::where(['status'=>0])->count(),
			'written_off'	=>	0,
			'resume_examine'				=>	ResumeModel::where(['examine'=>0])->count(),
			'resume_works'		=>	ResumeWorksModel::where(['status'=>0])->count(),
			'real_name'			=>	UserRealNameModel::where(['id_type'=>0,'status'=>0])->count(),
			'feedback'			=>	FeedbackModel::where(['status'=>0])->count(),
    	];
    	return $this->ajaxReturn('',0,$Data);
    }
    public function chartsStatistics()
    {
    	$StatisticsModel=StatisticsModel::whereTime('create_time', '>=',time()-3600*24*15)->withoutField('id')->order('create_time asc')->select();
    	$Statistics=[];
    	$time=[];
    	$series=[];
	    $legend=['注册用户', '个人用户', '企业用户', '投递简历', '面试邀请', '订单数量', '订单金额'];
    	if(!$StatisticsModel->isEmpty()){
	    	foreach ($StatisticsModel as $item) {
	    		$Statistics[0][]=$item->new_user;
	    		$Statistics[1][]=$item->personal_new_user;
	    		$Statistics[2][]=$item->company_new_user;
	    		$Statistics[3][]=$item->delivery_resume;
	    		$Statistics[4][]=$item->invite_aninterview;
	    		$Statistics[5][]=$item->orders_sum;
	    		$Statistics[6][]=$item->order_price;
	    		$time[]=date('m-d',strtotime($item->create_time));
	    	}
	    	foreach ($legend as $k => $v) {
		    	$series[]=[
		    		'type'	=>'line',
		    		'data'	=>$Statistics[$k],
		    		'name'	=>$v,
		    	];
	    	}
    	}
    	$Data=[
    		'time'		=>	$time,
			'legend'	=>	$legend,
			'series'	=>	$series,
    	];
    	return $this->ajaxReturn('',0,$Data);
    }
}
