<?php
namespace app\bsadmin\controller;
use think\facade\View;
use app\common\UploadFile;
use app\common\model\Files as FilesModel;
use app\common\model\StatusAlias as StatusAliasModel;
class Files extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            switch ($G['sort']) {
            	case 'size':
            		$sort='size desc';
            		break;
            	default:
            		$sort='id desc';
            		break;
            }
            $where=[];
            if ($G['type']!='all') {
	            $where[]=['type','=',$G['type']];
            }
            if ($G['uid']) {
	            $where[]=['uid','=',$G['uid']];
            }
            $Data=FilesModel::where($where)->order($sort)->paginate(10)->each(function($v){
            		$v['url']=config('web.imgurl').$v['path'];
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('到底了~',-100);
            }
        }else{
        	$statusAlias=StatusAliasModel::getCate('file/type');
        	View::assign('statusAlias',$statusAlias);
            return View::fetch();
        }
    }
    public function uploads()
    {
    	if (request()->isAjax()) {
    		if (request()->isGet()) {
	            $G=request()->get();
	    		$filesModel=FilesModel::find($G['id']);
	    		if (@unlink(root_path().'public'.$filesModel->path)) {
	    			if ($filesModel->delete()) {
		    			return $this->ajaxReturn();
	    			}else{
		    			return $this->ajaxReturn('删除数据失败',-100);
	    			}
	    		}else{
	    			return $this->ajaxReturn('删除文件失败',-100);
	    		}
    		}
    	}else{
            return View::fetch();
    	}
    }
}
