<?php
namespace app\bsadmin\controller;
use think\facade\View;
use app\common\model\Feedback as FeedbackModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\Resume as ResumeModel;
class Feedback extends Base
{
    public function index()
    {
        if(request()->isAjax()){
            $G=request()->get();
            $where=[];
            if (!empty($G['uid'])) 
                $where[]=['f.uid','=',$G['uid']];
            if ($G['status']!='all') 
                $where[]=['f.status','=',$G['status']];
            if ($G['type']) 
                $where[]=['f.type','=',$G['type']];
            $whereTime=[];
            if (!empty($G['time'])) {
                $whereTime[]=$G['time'][0].' 00:00:00';
                $whereTime[]=$G['time'][1].'23:59:59';
            }
            $DataModel=FeedbackModel::alias('f')->where($where);
            if (!empty($whereTime))
                $DataModel->whereTime('f.create_time','between',$whereTime);
            $Data=$DataModel->where(['type.alias'=>'feedback/type'])
                ->join('user_info uinfo','uinfo.uid = f.uid','LEFT')
                ->join('api_app app','app.app_id=f.app_id')
                ->join('status_alias type','type.value=f.type')
                ->order('f.id desc')->field('f.*,uinfo.nickname,uinfo.headimg,app.app_name,type.title as type_text')->paginate($G['pageSize'])->each(function($v){
                    $v->nickname=$v['nickname']?base64_decode($v['nickname']):'';
                    $v->headimg=$v['headimg']?config('web.imgurl').$v['headimg']:'';
                    $v->content=htmlentities($v['content']);
                    $v->data=null;
                    if($v->type==6){
                        $v->data=ResumeModel::where(['id'=>$v->alias_id])->field('name')->find();
                    }elseif ($v->type==7) {
                        $v->data=JobsModel::where(['id'=>$v->alias_id])->field('title')->find();
                    }
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            $FeedbackType=StatusAliasModel::where(['alias'=>'feedback/type'])->field('value,title')->select();
            View::assign('FeedbackType',$FeedbackType);
            return View::fetch();
        }
    }
    public function setStatus($id,$status)
    {
    	$FeedbackModel=FeedbackModel::where(['id'=>$id])->find();
    	$FeedbackModel->status=$status;
    	if ($FeedbackModel->save()) {
                return $this->ajaxReturn();
    	}else{
            return $this->ajaxReturn('保存失败，请重试',-100);
    	}
    }
    public function reply()
    {
    	$D=request()->post();
    	$FeedbackModel=FeedbackModel::where(['id'=>$D['id']])->find();
    	if ($FeedbackModel) {
	    	$FeedbackModel->reply=$D['content'];
	    	if ($FeedbackModel->save()) {
	                return $this->ajaxReturn('已保存');
	    	}else{
	            return $this->ajaxReturn('保存失败，请重试',-100);
	    	}
    	}else{
            return $this->ajaxReturn('反馈不存在',-100);
    	}
    }
}
