<?php
namespace app\bsadmin\controller;
use think\facade\Cache;
use think\facade\Session;
use think\facade\View;
use think\facade\Db;
use think\facade\Validate;
use app\common\model\Coupon as CouponModel;
use app\common\model\CouponList as CouponListModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\service\queue\Coupon as CouponQueue;
use app\common\controller\Vip as VipController;
use app\common\model\User as UserModel;
class Coupon extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['key']) {
                switch($G['search_type']){
                    case 'id':
                        $where[]=['list.id','=',$G['key']];
                        break;
                    case 'alias':
                        $where[]=['list.alias','=',$G['key']];
                        break;
                    case 'uid':
                        $where[]=['user.id','=',$G['key']];
                        break;
                    case 'user':
                        $where[]=['user.user','=',$G['key']];
                        break;
                    case 'mobile':
                        $where[]=['user.mobile','=',$G['key']];
                        break;
                    case 'email':
                        $where[]=['user.email','=',$G['key']];
                        break;
                }
            }
            if ($G['status']!='all') {
                $where[]=['list.status','=',$G['status']];
            }
            if (!empty($G['coupon_id'])) {
                $where[]=['list.alias_id','=',$G['coupon_id']];
            }
            $sort='list.id desc';
            if (!empty($G['sort'])) {
                switch($G['sort']){
                    case 'user':
                        $sort='list.receive_time desc,list.end_time asc';
                        break;
                }
            }
            $Data=CouponListModel::alias('list')->where($where)
                ->join('user user','user.id = list.uid','LEFT')
                ->join('user_info uinfo','uinfo.uid = list.uid','LEFT')
                ->join('coupon c','c.id=list.alias_id')
                ->join('vip vip','vip.level = c.vip_level AND vip.is_company=1')
                ->field('list.*,uinfo.nickname,uinfo.headimg,c.type,c.alias_type,c.title,c.price,c.discount,c.satisfy_price,c.superposition,c.limit_sum,c.vip_level,vip.title as vip_name')
                ->order($sort)->paginate($G['pageSize'])
                ->each(function($v){
                    $v->cate=$v->type?'折扣券':'满减券';
                    $v->alias_type=json_decode($v->alias_type,true);
                    $v->alias_list=StatusAliasModel::where(['alias'=>'vip/type'])->whereIn('value',$v->alias_type)->column('title');
                    if($v->start_time)
                    $v->start_time=date('Y-m-d H:i:s',$v->start_time);
                    if($v->receive_time)
                    $v->receive_time=date('Y-m-d H:i:s',$v->receive_time);
                    if($v->use_time)
                    $v->use_time=date('Y-m-d H:i:s',$v->use_time);
                    $v->end_time=date('Y-m-d H:i:s',$v->end_time);
                    $v->nickname=$v['nickname']?base64_decode($v['nickname']):'';
                    $v->headimg=$v['headimg']?config('web.imgurl').$v['headimg']:'';
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function coupon()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if (!empty($G['key'])) {
                switch($G['search_type']){
                    case 'title':
                        $where[]=['c.title','like','%'.$G['key'].'%'];
                        break;
                }
            }
            if ($G['status']!='all') {
                $where[]=['c.status','=',$G['status']];
            }
            $Data=CouponModel::alias('c')->where($where)
                ->join('vip vip','vip.level = c.vip_level AND vip.is_company=1')
                ->field('c.*,vip.title as vip_name')
                ->order('c.id desc')->paginate($G['pageSize'])
                ->each(function($v){
                    $v->cate=$v->type?'折扣券':'满减券';
                    $v->alias_type=json_decode($v->alias_type,true);
                    $v->alias_list=StatusAliasModel::where(['alias'=>'vip/type'])->whereIn('value',$v->alias_type)->column('title');
                    if($v->use_start_time)
                        $v->use_start_time=date('Y-m-d H:i:s',$v->use_start_time);
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function edit($id)
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'type'      => 'require',
                'title'      => 'require',
            ];
            $msg  =   [
                'type.require' => '请选择类型', 
                'title.require' => '券名不能为空', 
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            if($D['type']){
                if ($D['discount']>=100||$D['discount']<=0)
                    return $this->ajaxReturn('请输入折扣',-100);
            }else{
                if (!$D['price'])
                    return $this->ajaxReturn('请输入满减',-100);
            }
            $CouponModel=CouponModel::where(['id'=>$id])->find();
            $CouponModel->type          = $D['type'];
            $CouponModel->alias_type    = empty($D['alias_type'])?'[]':json_encode(arrtoint($D['alias_type']));
            $CouponModel->title         = $D['title'];
            $CouponModel->price         = $D['price'];
            $CouponModel->discount      = $D['discount'];
            $CouponModel->satisfy_price = $D['satisfy_price'];
            $CouponModel->superposition = $D['superposition'];
            $CouponModel->vip_level     = $D['vip_level'];
            $CouponModel->status        = $D['status'];
            $CouponModel->limit_sum     = $D['limit_sum'];
            if (strtotime($D['use_start_time'])){
                $CouponModel->use_start_time= strtotime($D['use_start_time']);
            }else{
                $CouponModel->use_start_time=null;
            }
            if($CouponModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $alias=StatusAliasModel::getCate('vip/type');
            View::assign('alias',$alias);
            $Find=CouponModel::where(['id'=>$id])
            ->withAttr('use_start_time',function($v,$data){
                return date('Y-m-d H:i:s',$v);
            })
            ->withAttr('alias_type',function($v,$data){
                return json_decode($v,true);
            })->find();
            View::assign('Find',$Find);
            $VipController=VipController::getCate();
            View::assign('vip',$VipController);
            return View::fetch('add');
        }
    }
    public function add()
    {
        if(request()->isPost()){
            $D=request()->post();
            $rule =   [
                'type'      => 'require',
                'title'      => 'require',
            ];
            $msg  =   [
                'type.require' => '请选择类型', 
                'title.require' => '券名不能为空', 
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            if($D['type']){
                if ($D['discount']>=100||$D['discount']<=0)
                    return $this->ajaxReturn('请输入折扣',-100);
            }else{
                if (!$D['price'])
                    return $this->ajaxReturn('请输入满减',-100);
            }
            $CouponModel=new CouponModel;
            $CouponModel->type          = $D['type'];
            $CouponModel->alias_type    = empty($D['alias_type'])?'[]':json_encode(arrtoint($D['alias_type']));
            $CouponModel->title         = $D['title'];
            $CouponModel->price         = $D['price'];
            $CouponModel->discount      = $D['discount'];
            $CouponModel->satisfy_price = $D['satisfy_price'];
            $CouponModel->superposition = $D['superposition'];
            $CouponModel->vip_level     = $D['vip_level'];
            $CouponModel->status        = $D['status'];
            $CouponModel->limit_sum     = $D['limit_sum'];
            if (strtotime($D['use_start_time']))
            $CouponModel->use_start_time= strtotime($D['use_start_time']);
            if($CouponModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $alias=StatusAliasModel::getCate('vip/type');
            View::assign('alias',$alias);
            $VipController=VipController::getCate();
            View::assign('vip',$VipController);
            return View::fetch();
        }
    }
    public function setStatus($id,$status)
    {
        $CouponModel=CouponModel::where(['id'=>$id])->find();
        $CouponModel->status=$status;
        if ($CouponModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function del($id)
    {
        $CouponModel=CouponModel::where(['id'=>$id])->find();
        if (CouponListModel::where(['alias_id'=>$id])->count())
            return $this->ajaxReturn('当前优惠券列表不为空',-200);
        if ($CouponModel->delete()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function raise()
    {
        $D=request()->post();
        $rule =   [
            'stock'      => 'require',
            'end_time'      => 'require',
        ];
        $msg  =   [
            'stock.require' => '数量不能为空', 
            'end_time.require' => '结束时间不能为空', 
        ];
        $Validate=Validate::rule($rule)->message($msg);
        $result = $Validate->check($D);
        if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
        $CouponModel=CouponModel::where(['id'=>$D['id']])->find();
        if (!$CouponModel)
            return $this->ajaxReturn('优惠券不存在',-200);
        $end_time=strtotime($D['end_time']);
        $status=$CouponModel->use_start_time<=time()?1:0;
        $prefix=($CouponModel->type+1).''.$CouponModel->superposition.date('Ymd');
        $noAliasArr=CouponListModel::whereTime('create_time','today')->column('alias');
        $noAliasArrCount=count($noAliasArr);
        $randLength=4;
        switch(true){
            case $noAliasArrCount>=5000:
                $randLength=5;
                break;
            case $noAliasArrCount>=50000:
                $randLength=6;
                break;
        }
        $aliasArr=[];
        $CouponList=[];
        for ($i=0; $i < $D['stock']; $i++) {
            $alias=$prefix.GetRand($randLength);
            while (in_array($alias, $aliasArr)||in_array($alias, $noAliasArr)) {
                $alias=$prefix.GetRand($randLength);
            }
            $aliasArr[]=$alias;
            $CouponListFind=[
                'alias_id'  =>  $CouponModel->id,
                'alias'     =>  $alias,
                'status'    =>  $status,
                'start_time'=>  $CouponModel->use_start_time,
                'end_time'  =>  $end_time,
            ];
            ksort($CouponListFind);
            $CouponList[]=$CouponListFind;
        }
        $CouponListModel=new CouponListModel;
        $CouponModel->stock=Db::raw('stock+'.$D['stock']);
        $CouponModel->surplus_stock=Db::raw('surplus_stock+'.$D['stock']);
        // 启动事务
        Db::startTrans();
        try {
            $CouponListModel->saveAll($CouponList);
            $CouponModel->save();
            // 提交事务
            Db::commit();
            return $this->ajaxReturn('增发成功');
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $this->ajaxReturn('增发失败，请重试',-200);
        }
    }
    public function giveUserCoupon()
    {
        $D=request()->post();
        $rule =   [
            'coupon_id'      => 'require',
            'uid'      => 'require',
        ];
        $msg  =   [
            'coupon_id.require' => '请选择优惠券', 
            'uid.require' => '用户不存在', 
        ];
        $Validate=Validate::rule($rule)->message($msg);
        $result = $Validate->check($D);
        if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
        $CouponModel=CouponModel::where(['id'=>$D['coupon_id']])->find();
        if (!$CouponModel)
            return $this->ajaxReturn('优惠券不存在',-200);
        $CouponListModel=CouponListModel::where(['alias_id'=>$D['coupon_id']])->whereNull('uid')->whereNull('receive_time')->whereNull('use_time')->whereTime('end_time','>',time()+3600)->order('end_time asc')->find();
        if ($CouponListModel) {
            $CouponListModel->uid=$D['uid'];
            $CouponListModel->receive_time=time();
            $CouponListModel->admin_uid=Session::get('AdminUser.uid');
            $CouponModel->surplus_stock=Db::raw('surplus_stock-1');
            Db::startTrans();
            try {
                $CouponListModel->save();
                $CouponModel->save();
                // 提交事务
                Db::commit();
                return $this->ajaxReturn('赠送成功');
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return $this->ajaxReturn('赠送失败，请重试',-200);
            }
        }else{
            return $this->ajaxReturn('暂无可用优惠券，请先增发优惠券',-200);
        }
    }
    public function giveCoupon()
    {
        if(request()->isAjax()){
            if(request()->isPost()){
                $D=request()->post();
                $rule =   [
                    'coupon_id'      => 'require',
                    'end_time'      => 'require',
                ];
                $msg  =   [
                    'coupon_id.require' => '请选择优惠券', 
                    'end_time.require' => '结束时间不能为空', 
                ];
                $Validate=Validate::rule($rule)->message($msg);
                $result = $Validate->check($D);
                if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
                $CouponModel=CouponModel::where(['id'=>$D['coupon_id']])->find();
                if (!$CouponModel)
                    return $this->ajaxReturn('优惠券不存在',-200);
                $end_time=strtotime($D['end_time']);
                $status=$CouponModel->use_start_time<=time()?1:0;
                $prefix=($CouponModel->type+1).''.$CouponModel->superposition.date('Ymd');

                $where=[];
                switch($D['crowd']){
                    case 'company':
                    $where[]=['user_info.role_type','=',1];
                    break;
                    case 'personal':
                    $where[]=['user_info.role_type','=',0];
                    break;
                    case 'mp':
                    $where[]=['user_wx.subscribe','=',1];
                    break;
                    case 'mobile':
                    $where[]=['user.mobile','NOT NULL',''];
                    break;
                    case 'email':
                    $where[]=['user.email','NOT NULL',''];
                    break;
                }
                if ($D['vip_level']!='all') {
                    $where[]=['user_vip.company_vip_level','=',$D['vip_level']];
                }
                $whereTime=[];
                if (!empty($D['register_time'])) {
                    $whereTime[]=$D['register_time'][0].' 00:00:00';
                    $whereTime[]=$D['register_time'][1].' 23:59:59';
                }
                $DataObj=UserModel::alias('user')->where($where);
                if (!empty($whereTime))
                    $DataObj->whereTime('user.create_time','between',$whereTime);
                $Data=$DataObj->join('user_info user_info','user_info.uid = user.id','LEFT')
                    ->join('user_wx user_wx','user_wx.uid = user.id','LEFT')
                    ->join('user_vip user_vip','user_vip.uid = user.id','LEFT')
                    ->column('user.id');
                if (count($Data)<=0)
                    return $this->ajaxReturn('当前筛选结果为0',-200);

                $noAliasArr=CouponListModel::whereTime('create_time','today')->column('alias');
                $noAliasArrCount=count($noAliasArr);
                $randLength=4;
                switch(true){
                    case $noAliasArrCount>=5000:
                        $randLength=5;
                        break;
                    case $noAliasArrCount>=50000:
                        $randLength=6;
                        break;
                }
                $aliasArr=[];
                $CouponList=[];
                foreach ($Data as $key => $uid) {
                    $alias=$prefix.GetRand($randLength);
                    while (in_array($alias, $aliasArr)||in_array($alias, $noAliasArr)) {
                        $alias=$prefix.GetRand($randLength);
                    }
                    $aliasArr[]=$alias;
                    $CouponListFind=[
                        'alias_id'  =>  $CouponModel->id,
                        'alias'     =>  $alias,
                        'uid'       =>  $uid,
                        'status'    =>  $status,
                        'start_time'=>  $CouponModel->use_start_time,
                        'end_time'  =>  $end_time,
                    ];
                    ksort($CouponListFind);
                    $CouponList[]=$CouponListFind;
                }
                $CouponListModel=new CouponListModel;
                $CouponModel->stock=Db::raw('stock+'.count($Data));
                // 启动事务
                Db::startTrans();
                try {
                    $CouponListModel->saveAll($CouponList);
                    $CouponModel->save();
                    // 提交事务
                    Db::commit();
                    return $this->ajaxReturn('发放成功');
                } catch (\Exception $e) {
                    // 回滚事务
                    Db::rollback();
                    return $this->ajaxReturn('发放失败，请重试',-200);
                }
            }else{
                $G=request()->get();
                $where=[];
                switch($G['crowd']){
                    case 'company':
                    $where[]=['user_info.role_type','=',1];
                    break;
                    case 'personal':
                    $where[]=['user_info.role_type','=',0];
                    break;
                    case 'mp':
                    $where[]=['user_wx.subscribe','=',1];
                    break;
                    case 'mobile':
                    $where[]=['user.mobile','NOT NULL',''];
                    break;
                    case 'email':
                    $where[]=['user.email','NOT NULL',''];
                    break;
                }
                if ($G['vip_level']!='all') {
                    $where[]=['user_vip.company_vip_level','=',$G['vip_level']];
                }
                $whereTime=[];
                if (!empty($G['register_time'])) {
                    $whereTime[]=$G['register_time'][0].' 00:00:00';
                    $whereTime[]=$G['register_time'][1].' 23:59:59';
                }
                $DataObj=UserModel::alias('user')->where($where);
                if (!empty($whereTime))
                    $DataObj->whereTime('user.create_time','between',$whereTime);
                $Data=$DataObj->join('user_info user_info','user_info.uid = user.id','LEFT')
                    ->join('user_wx user_wx','user_wx.uid = user.id','LEFT')
                    ->join('user_vip user_vip','user_vip.uid = user.id','LEFT')
                    ->count();
                return $this->ajaxReturn('',0,$Data);
            }
        }else{
            $VipController=VipController::getCate();
            View::assign('vip',$VipController);
            return View::fetch();
        }
    }
}
