<?php
namespace app\bsadmin\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Validate;
use app\bsadmin\model\ApiApp as ApiAppModel;
use app\bsadmin\model\ApiRoute as ApiRouteModel;
use app\bsadmin\model\Config as ConfigModel;
use app\common\model\AppVersion as AppVersionModel;
use helper\Dir;

class Client extends Base
{
    public function index()
    {
    	if (request()->isAjax()) {
    		$G=request()->get();
    		if (empty($G['app_id'])) return $this->ajaxReturn('请先选择应用',-100);
            $where=[];
            if ($G['app_id']) {
                $where[]=['app_id','=',$G['app_id']];
            }
            $Data=ApiRouteModel::where($where)
                ->order('api_id desc')->paginate($G['pageSize'])->each(function($v){
                    $v['api_method']=strtoupper($v['api_method']);
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
    	}else{
            $this->updateApiAuth(1);
            View::assign('app_list',ApiAppModel::select());
	    	return View::fetch();
    	}
    }
    public function seo_index()
    {
    	if (request()->isAjax()) {
    		$G=request()->get();
    		if (empty($G['app_id'])) return $this->ajaxReturn('请先选择应用',-100);
            $where=[];
            if ($G['app_id']) {
                $where[]=['app_id','=',$G['app_id']];
            }
            $where[]=['api_method','in',['get','rule']];
            $where[]=['api_is_login','=',0];
            $Data=ApiRouteModel::where($where)
                ->order('api_id desc')->paginate($G['pageSize'])->each(function($v){
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
    	}else{
    		$ApiAppModel=ApiAppModel::where(['app_modul'=>'index'])->find();
            View::assign('app_id',$ApiAppModel->app_id);
	    	return View::fetch();
    	}
    }
    public function editApp($id)
    {
    	if (request()->isAjax()) {
            $D=request()->post();
	        $rule =   [
	            'app_name'  	=> 'require|max:50',
	            'app_domain'  	=> 'require|max:30|unique:api_app',
	            'app_modul'  	=> 'require|max:50',
	            'app_icon'  	=> 'require',
	            'app_status_msg'=> 'requireIf:app_status,0',
	        ];
	        $msg  =   [
	            'app_name.require' 		=> '名称不能为空', 
	            'app_name.max' 			=> '名称不能超过50个字符',
	            'app_icon.require' 		=> '图标不能为空', 
	            'app_domain.require' 	=> '域名不能为空',
	            'app_domain.max' 		=> '域名不能超过30个字符',
	            'app_domain.unique' 	=> '域名已存在',
	            'app_modul.require' 	=> '模块不能为空',
	            'app_modul.max' 		=> '模块不能超过50个字符',
	            'app_status_msg.max' 	=> '禁用消息不能为空',
	        ];
	        $Validate=Validate::rule($rule)->message($msg);
	        $result = $Validate->check($D);
	        if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
	        $ApiApp=ApiAppModel::where(['app_id'=>$id])->find();
            $ApiApp->app_name      	=   $D['app_name'];
            $ApiApp->app_icon    	=   $D['app_icon'];
            $ApiApp->app_domain    	=   $D['app_domain'];
            $ApiApp->app_modul    	=   $D['app_modul'];
	        $ApiApp->app_status 	=	$D['app_status'];
	        $ApiApp->app_status_msg =	$D['app_status_msg'];
	        if($ApiApp->save()){
                return $this->ajaxReturn('保存成功');
	        }else{
	            return $this->ajaxReturn('保存失败，请重试',-200);
	        }
    	}else{
            View::assign('Find',ApiAppModel::where(['app_id'=>$id])->find());
	    	return View::fetch('add_app');
    	}
    }
    public function addApp()
    {
    	if (request()->isAjax()) {
            $D=request()->post();
	        $rule =   [
	            'app_name'  	=> 'require|max:50',
	            'app_domain'  	=> 'require|max:30|unique:api_app',
	            'app_modul'  	=> 'require|max:50',
	            'app_icon'  	=> 'require',
	            'app_status_msg'=> 'requireIf:app_status,0',
	        ];
	        $msg  =   [
	            'app_name.require' 		=> '名称不能为空', 
	            'app_name.max' 			=> '名称不能超过50个字符',
	            'app_icon.require' 		=> '图标不能为空', 
	            'app_domain.require' 	=> '域名不能为空',
	            'app_domain.max' 		=> '域名不能超过30个字符',
	            'app_domain.unique' 	=> '域名已存在',
	            'app_modul.require' 	=> '模块不能为空',
	            'app_modul.max' 		=> '模块不能超过50个字符',
	            'app_status_msg.max' 	=> '禁用消息不能为空',
	        ];
	        $Validate=Validate::rule($rule)->message($msg);
	        $result = $Validate->check($D);
	        if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
        	$key=ApiAppModel::encryptionAppKey();
	        $ApiApp=new ApiAppModel;
            $ApiApp->app_name      	=   $D['app_name'];
            $ApiApp->app_icon    	=   $D['app_icon'];
            $ApiApp->app_domain    	=   $D['app_domain'];
            $ApiApp->app_modul    	=   $D['app_modul'];
	        $ApiApp->app_key 		=	$key['pubKey'];
            $ApiApp->app_key_secret =   $key['privKey'];
	        $ApiApp->app_status 	=	$D['app_status'];
	        $ApiApp->app_status_msg =	$D['app_status_msg'];
	        if($ApiApp->save()){
                return $this->ajaxReturn('保存成功');
	        }else{
	            return $this->ajaxReturn('保存失败，请重试',-200);
	        }
    	}else{
	    	return View::fetch();
    	}
    }
    public function setAppStatus($id,$status,$msg='')
    {
        $ApiApp=ApiAppModel::where(['app_id'=>$id])->find();
        $ApiApp->app_status=$status;
        if ($status) {
	        $ApiApp->app_status_msg='';
        }else{
	        $ApiApp->app_status_msg=$msg;
        }
        if ($ApiApp->save()) {
    		return $this->ajaxReturn();
        }else{
        	return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function editApi($id)
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'app_id'        => 'require',
                'api_name'      => 'require|max:50',
                'api_controller'=> 'require',
                'api_action'    => 'require',
                'api_url'       => 'require|unique:api_route',
                'api_status_msg'=> 'requireIf:api_status,0',
            ];
            $msg  =   [
                'app_id.require'        => '应用ID不能为空', 
                'api_name.require'      => '名称不能为空', 
                'api_name.max'          => '名称不能超过50个字符',
                'api_controller.require'=> '控制器不能为空',
                'api_action.require'    => '操作不能为空',
                'api_url.require'       => 'URL不能为空',
                'api_url.unique'        => 'URL已存在',
                'api_status_msg.require'=> '禁用消息不能为空',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $ApiRoute=ApiRouteModel::where(['api_id'=>$id])->find();
            $ApiRoute->app_id         =   $D['app_id'];
            $ApiRoute->api_method     =   $D['api_method'];
            $ApiRoute->api_name       =   $D['api_name'];
            $ApiRoute->api_controller =   $D['api_controller'];
            $ApiRoute->api_action     =   $D['api_action'];
            $ApiRoute->api_url        =   $D['api_url'];
            $ApiRoute->api_param      =   $D['api_param'];
            $ApiRoute->api_allow      =   $D['api_allow'];
            $ApiRoute->api_ext        =   $D['api_ext'];
            $ApiRoute->api_is_login   =   $D['api_is_login'];
            $ApiRoute->api_status     =   $D['api_status'];
            $ApiRoute->api_status_msg =   $D['api_status_msg'];
            $ApiRoute->api_is_web_name=   $D['api_is_web_name'];
            if($ApiRoute->save()){
                if ($this->updateApiAuth($D['app_id'])
                    && $this->updateRouteFile($D['app_id'])) {
                    return $this->ajaxReturn('保存成功');
                }else{
                    return $this->ajaxReturn('保存成功。更新路由失败，请手动更新');
                }
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=ApiRouteModel::where(['api_id'=>$id])->find();
            if (!$Find) {
                View::assign('message','未获取到接口');
                return View::fetch('login/unauthorized');
            }
            View::assign('Find',$Find);
            $AppInfo=ApiAppModel::where(['app_id'=>$Find->app_id])->find();
            if (!$AppInfo) {
                View::assign('message','未获取到应用');
                return View::fetch('login/unauthorized');
            }
            View::assign('AppInfo',$AppInfo);
            return View::fetch('add_api');
        }
    }
    public function editSeoApi($id)
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'seo_title'  	=> 'max:80',
                'seo_keywords'  => 'max:100',
                'seo_description'  => 'max:250',
            ];
            $msg  =   [
                'seo_title.max'     	 => 'SEO标题长度不能超过80个字符',
                'seo_keywords.max'      => '关键词长度不能超过100个字符',
                'seo_description.max'      => '描述长度不能超过250个字符',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $ApiRoute=ApiRouteModel::where(['api_id'=>$id])->find();
            $ApiRoute->api_is_web_name  =   $D['api_is_web_name'];
            $ApiRoute->seo_title        =   $D['seo_title'];
            $ApiRoute->seo_keywords     =   $D['seo_keywords'];
            $ApiRoute->seo_description  =   $D['seo_description'];
            if($ApiRoute->save()){
                if ($this->updateApiAuth($D['app_id'])) {
                    return $this->ajaxReturn('保存成功');
                }else{
                    return $this->ajaxReturn('保存成功。更新路由失败，请手动更新');
                }
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $Find=ApiRouteModel::where(['api_id'=>$id])->find();
            if (!$Find) {
                View::assign('message','未获取到接口');
                return View::fetch('login/unauthorized');
            }
            View::assign('Find',$Find);
            $AppInfo=ApiAppModel::where(['app_id'=>$Find->app_id])->find();
            if (!$AppInfo) {
                View::assign('message','未获取到应用');
                return View::fetch('login/unauthorized');
            }
            View::assign('AppInfo',$AppInfo);
            return View::fetch('edit_seo_api');
        }
    }
    public function addApi($id)
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'app_id'        => 'require',
                'api_name'      => 'require|max:50',
                'api_controller'=> 'require',
                'api_action'    => 'require',
                'api_url'       => 'require',
                'api_status_msg'=> 'requireIf:api_status,0',
            ];
            $msg  =   [
                'app_id.require'        => '应用ID不能为空', 
                'api_name.require'      => '名称不能为空', 
                'api_name.max'          => '名称不能超过50个字符',
                'api_controller.require'=> '控制器不能为空',
                'api_action.require'    => '操作不能为空',
                'api_url.require'       => 'URL不能为空',
                'api_url.unique'        => 'URL已存在',
                'api_status_msg.max'    => '禁用消息不能为空',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            if (ApiRouteModel::where(['app_id'=>$D['app_id'],'api_url'=>$D['api_url']])->count())
                return $this->ajaxReturn('URL已存在',-100);
            $ApiRoute=new ApiRouteModel;
            $ApiRoute->app_id         =   $D['app_id'];
            $ApiRoute->api_method     =   $D['api_method'];
            $ApiRoute->api_name       =   $D['api_name'];
            $ApiRoute->api_controller =   $D['api_controller'];
            $ApiRoute->api_action     =   $D['api_action'];
            $ApiRoute->api_url        =   $D['api_url'];
            $ApiRoute->api_param      =   $D['api_param'];
            $ApiRoute->api_allow      =   $D['api_allow'];
            $ApiRoute->api_ext        =   $D['api_ext'];
            $ApiRoute->api_is_login   =   $D['api_is_login'];
            $ApiRoute->api_status     =   $D['api_status'];
            $ApiRoute->api_status_msg =   $D['api_status_msg'];
            $ApiRoute->api_is_web_name=   $D['api_is_web_name'];
            if($ApiRoute->save()){
                if ($this->updateApiAuth($D['app_id'])
                    && $this->updateRouteFile($D['app_id'])) {
                    return $this->ajaxReturn('保存成功');
                }else{
                    return $this->ajaxReturn('保存成功。更新路由失败，请手动更新');
                }
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            $AppInfo=ApiAppModel::where(['app_id'=>$id])->find();
            if (!$AppInfo) {
                View::assign('message','未获取到应用');
                return View::fetch('login/unauthorized');
            }
            View::assign('AppInfo',$AppInfo);
            return View::fetch();
        }
    }
    public function setApiStatus($id,$status,$msg='')
    {
        $ApiRoute=ApiRouteModel::where(['api_id'=>$id])->find();
        $ApiRoute->api_status=$status;
        if ($status) {
            $ApiRoute->api_status_msg='';
        }else{
            $ApiRoute->api_status_msg=$msg;
        }
        if ($ApiRoute->save()) {
            if ($this->updateApiAuth($ApiRoute->app_id)) {
                return $this->ajaxReturn();
            }else{
                return $this->ajaxReturn('请手动更新缓存');
            }
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setApiAllow($id,$status)
    {
        $ApiRoute=ApiRouteModel::where(['api_id'=>$id])->find();
        $ApiRoute->api_allow=$status;
        if ($ApiRoute->save()) {
            if ($this->updateRouteFile($ApiRoute->app_id)) {
                return $this->ajaxReturn();
            }else{
                return $this->ajaxReturn('请手动更新缓存');
            }
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setApiIsLogin($id,$status)
    {
        $ApiRoute=ApiRouteModel::where(['api_id'=>$id])->find();
        $ApiRoute->api_is_login=$status;
        if ($ApiRoute->save()) {
            if ($this->updateApiAuth($ApiRoute->app_id)) {
                return $this->ajaxReturn();
            }else{
                return $this->ajaxReturn('请手动更新缓存');
            }
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function updateAppKeyAjax($id)
    {
        $ApiApp=ApiAppModel::where(['app_id'=>$id])->find();
        $key=ApiAppModel::encryptionAppKey();
        $ApiApp->app_key        =   $key['pubKey'];
        $ApiApp->app_key_secret =   $key['privKey'];
        if($ApiApp->save()){
            if ($this->updateApiAuth($ApiApp->app_id)) {
                return $this->ajaxReturn('保存成功',0,$ApiApp);
            }else{
                return $this->ajaxReturn('请手动更新缓存',0,$ApiApp);
            }
        }else{
            return $this->ajaxReturn('保存失败，请重试',-200);
        }
    }
    public function updateApiCacheAjax($id='')
    {
        if ($id) {
            $ApiApp=ApiAppModel::where(['app_id'=>$id])->find();
            if(!$ApiApp->app_key||!$ApiApp->app_key_secret)
                return $this->ajaxReturn('请先更新KEY',-100);
            if($ApiApp->app_modul=='mobile'){
            	$ret=$this->ReplaceJsUrl();
                if($ret)
                    return $this->ajaxReturn($ret,-100);
            }
            if ($this->updateApiAuth($id)
                && $this->updateRouteFile($id)) {
                return $this->ajaxReturn('已更新');
            }else{
                return $this->ajaxReturn('更新路由失败，请重试',-100);
            }
        }else{
            $ApiApp=ApiAppModel::field('app_id,app_modul')->select();
            foreach ($ApiApp as $val) {
                if($val->app_modul=='mobile'){
                    $ret=$this->ReplaceJsUrl();
                    if($ret)break;
                }
                $this->updateApiAuth($val->app_id);
                $this->updateRouteFile($val->app_id);
            }
            return $this->ajaxReturn('已更新');
        }
    }
    public function ReplaceJsUrl()
    {
        if(!config('web.h5'))return '未配置H5域名，请先到后台>系统>配置>站点配置>填写H5域名';
        $backpath='static/default/mobile/static/js/back';
        $savepath='static/default/mobile/static/js';
        $filename='';
        $indexjs='';
        $path=Dir::tree($backpath);
        foreach($path as $key => $v){
            if(substr($v['filename'],0,6)==='index.'){
                $filename=$v['filename'];
                $indexjs=$v['path'];
                break;
            }
        }
        if(!$indexjs){
            $path=Dir::tree($savepath);
            Dir::create($backpath);
            foreach($path as $key => $v){
                if(substr($v['filename'],0,6)==='index.'){
                    $filename=$v['filename'];
                    $indexjs=$v['path'];
                    copy($indexjs, $backpath.'/'.$v['filename']);
                    break;
                }
            }
        }
        if(!$indexjs)return '未找到H5核心JS文件，请确认安装文件是否完整';
        $indexjs_content=file_get_contents($indexjs);
        $indexjs_content=str_replace('{$appName}',config('web.name'),$indexjs_content);
        $indexjs_content=str_replace('{$Platform-url}',config('web.h5').'/',$indexjs_content);
        $indexjs_content=str_replace('{$Platform-wechatMpUrl}',config('web.wechatmp'),$indexjs_content);
        $indexjs_content=str_replace("\n",'\\n',$indexjs_content);
        file_put_contents($savepath.'/'.$filename,$indexjs_content);
        return false;
    }
    /**
     * [updateApiAuth 更新权限验证]
     * @return [type] [description]
     */
    protected function updateApiAuth($id)
    {
        try {
            $ApiApp=ApiAppModel::where(['app_id'=>$id])->field('app_key,app_key_secret,app_status,app_status_msg,app_modul')->find();
            if ($ApiApp) {
                $ApiData=ApiRouteModel::where(['app_id'=>$id])->field('api_id,app_id,api_name,api_controller,api_action,api_url,api_status,api_status_msg,api_is_login,api_is_web_name,seo_title,seo_keywords,seo_description')->select();
                $ApiCacheData=[];
                foreach ($ApiData as $k => $v) {
                    $ApiCacheData[$v['api_controller'].'/'.$v['api_action']]=$v->toArray();
                }
                $status=Cache::set('client.app.'.$ApiApp->app_modul,$ApiApp->toArray());
                $status1=Cache::set('client.app.'.$ApiApp->app_modul,$ApiApp->toArray());
                $status2=Cache::set('client.api.'.$ApiApp->app_modul,$ApiCacheData);
                if ($status && $status1 && $status2) return true;
            }
            return false;
        } catch (Exception $e) {
            return false;
        }
    }
    /**
     * [updateRouteFile 更新路由文件]
     * @return [type] [description]
     */
    protected function updateRouteFile($id)
    {
        try {
            $ApiApp=ApiAppModel::where(['app_id'=>$id])->field('app_modul')->find();
            $ApiData=ApiRouteModel::where(['app_id'=>$id])->field('api_method,api_name,api_controller,api_action,api_url,api_param,api_ext,api_allow')->select();
            if ($ApiData) {
                //路由
                $RouteWrite="<?php\nuse think\\facade\\Route;\n";
                foreach ($ApiData as $k => $v) {
                        $ext='';
                        $allow='';
                        if ($v['api_ext'])
                            $ext='->ext(\''.$v['api_ext'].'\')';
                        if ($v['api_allow'])
                            $allow='->allowCrossDomain()';
                        $RouteWrite.="//".$v['api_name'];
                        $RouteWrite.="\nRoute::".$v['api_method'];
                        $RouteWrite.="('";
                        $RouteWrite.=$v['api_url'].$v['api_param'];
                        $RouteWrite.="','";
                        $RouteWrite.=$ApiApp['app_modul']."/".$v['api_controller']."/".$v['api_action'];
                        $RouteWrite.="')".$ext.$allow.";\n";
                }
                //写入路由文件
                $RoutePath=base_path().$ApiApp['app_modul']."/route/route.php";
                if (!file_exists(dirname($RoutePath))) {
                    mkdir(dirname($RoutePath), 0777, true);
                }
                $RouteFile = fopen($RoutePath, "w") or die("Unable to open file!");
                fwrite($RouteFile, $RouteWrite);
                fclose($RouteFile);
                return true;
            }
            return false;
        } catch (Exception $e) {
            return false;
        }
    }
    public function appConfig()
    {
        $Data=ConfigModel::getList(['ctype'=>'xy_app_config']);
        View::assign('Data',$Data);
        View::assign('ctype','xy_app_config');
    	return View::fetch('setting/app_config');
    }
    public function appVersion()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $Data=AppVersionModel::order('version_code desc')->paginate($G['pageSize'])->each(function($v){
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
    public function addAppVersion()
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'platform'        => 'require|Array',
                'version_code'    => 'require|unique:app_version',
                'version_name'    => 'require',
                'wgt'             => 'require',
                'desc'            => 'require'
            ];
            $msg  =   [
                'platform.require'      => '请选择平台', 
                'platform.Array'        => '请选择平台', 
                'version_code.require'  => '版本号不能为空', 
                'version_code.unique'   => '版本号已存在',
                'version_name.require'  => '版本名称不能为空',
                'wgt.require'           => '请选择是安装包还是资源包',
                'desc.require'          => '请输入更新说明'
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $is_android=1;
            $is_ios=1;
            if($D['wgt']){
                if (!in_array('android',$D['platform']))
                    $is_android=0;
                if (!in_array('ios',$D['platform']))
                    $is_ios=0;
                if(!$is_android && !$is_ios)
                    return $this->ajaxReturn('请选择平台',-100);
                if(empty($D['path']))
                    return $this->ajaxReturn('请上传资源包',-100);
            }else{
                if (!in_array('android',$D['platform']) || empty($D['path']))
                    $is_android=0;
                if (!in_array('ios',$D['platform']) || empty($D['ios_url']))
                    $is_ios=0;
                if(!$is_android && !$is_ios)
                    return $this->ajaxReturn('请选择平台并上传APK或输入AppStore链接',-100);
            }
            $AppVersionModel=new AppVersionModel;
            $AppVersionModel->version_code      =   $D['version_code'];
            $AppVersionModel->version_name      =   $D['version_name'];
            $AppVersionModel->path              =   $D['path'];
            $AppVersionModel->ios_url           =   $D['ios_url'];
            $AppVersionModel->desc              =   $D['desc'];
            $AppVersionModel->status            =   $D['status'];
            $AppVersionModel->force             =   $D['force'];
            $AppVersionModel->wgt               =   intval($D['wgt']);
            $AppVersionModel->is_android        =   $is_android;
            $AppVersionModel->is_ios            =   $is_ios;
            if($AppVersionModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-200);
            }
        }else{
            return View::fetch();
        }
    }
    public function delAppVersion($id)
    {
        $AppVersionModel=AppVersionModel::find($id);
        if($AppVersionModel->is_android)
            @unlink(root_path().'public'.$AppVersionModel->path);
        if ($AppVersionModel->delete()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('删除数据失败',-100);
        }
    }
    public function setAppVersionStatus($id,$status)
    {
        $AppVersionModel=AppVersionModel::where(['id'=>$id])->find();
        $AppVersionModel->status=$status;
        if ($AppVersionModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function setAppVersionForce($id,$status)
    {
        $AppVersionModel=AppVersionModel::where(['id'=>$id])->find();
        $AppVersionModel->force=$status;
        if ($AppVersionModel->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    public function h5Config()
    {
        $Data=ConfigModel::getList(['ctype'=>'xy_h5_config']);
        View::assign('Data',$Data);
        View::assign('ctype','xy_h5_config');
    	return View::fetch('setting/basic');
    }
    public function mpConfig()
    {
        $Data=ConfigModel::getList(['ctype'=>'xy_mp_config']);
        View::assign('Data',$Data);
        View::assign('ctype','xy_mp_config');
    	return View::fetch('setting/basic');
    }
}
