<?php
namespace app\bsadmin\controller;
use app\common\model\UserVip as UserVipModel;
use app\common\model\Company as CompanyModel;
use app\common\model\CompanyDemeanor as CompanyDemeanorModel;
use app\common\model\Resume as ResumeModel;
use app\common\model\ResumeWorks as ResumeWorksModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\Orders as OrdersModel;
use app\common\model\JobsExtensionLog as JobsExtensionLogModel;
use app\common\model\ResumeDownloaded as ResumeDownloadedModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\InviteAninterview as InviteAninterviewModel;
use app\common\model\CouponList as CouponListModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\bsadmin\model\Admin as AdminModel;
class Business extends Base
{
    public function index()
    {
    	$G=request()->get();
    	if(!empty($G['role_type'])&&$G['role_type']){
			$Field=[
				'company.id,company.uid,company.title,company.adviser_id,company.attestation',
				'user.mobile,user.email',
				'user_info.nickname,user_info.headimg,user_info.score',
				'user_timer.login_ip',
				'content.contacts,content.contacts_mobile',
				'user_vip.company_vip_time,user_vip.company_vip_level,user_vip.download_resume',
				'company_vip.title as company_vip'
			];
    		$Find=CompanyModel::alias('company')
    			->where(['company.id'=>$G['id']])
                ->join('user user','user.id = company.uid')
                ->join('company_content content','content.cid = company.id')
                ->join('user_info user_info','user_info.uid = user.id','LEFT')
                ->join('user_timer user_timer','user_timer.uid = user.id','LEFT')
				->join('user_vip user_vip','user_vip.uid=user.id','LEFT')
				->join('vip company_vip','company_vip.level=user_vip.company_vip_level AND company_vip.is_company=1','LEFT')
				->field(implode(',',$Field))->find();
    		if($Find){
    			$Find->attestation=StatusAliasModel::where(['alias'=>'company/attestation','value'=>$Find->attestation])->find();
                $Find->nickname=$Find->nickname?base64_decode($Find->nickname):'';
                $Find->headimg=$Find->headimg?config('web.imgurl').$Find->headimg:'';
	            if($Find->adviser_id){
		            $Find->adviser=AdminModel::where(['id'=>$Find->adviser_id])->field('nickname,headimg')->withAttr('headimg',function($v,$data){
		                return $v?config('web.imgurl').$v:$v;
		            })->find();
	            }else{
		            $Find->adviser=AdminModel::where(['adviser_default'=>1])->field('nickname,headimg')->withAttr('headimg',function($v,$data){
		                return $v?config('web.imgurl').$v:$v;
		            })->find();
	            }
				if($Find->company_vip_level&&$Find->company_vip_time>time()){
					$Find->company_vip_time=date('Y-m-d',$Find->company_vip_time);
				}else{
					$Find->company_vip_time='永久';
				}
				$Find->jobs_sum=JobsModel::where(['company_id'=>$Find->id,'status'=>1])->count();
				$Find->order_sum=OrdersModel::where(['uid'=>$Find->uid])->count();
				$Find->order_finish_sum=OrdersModel::where(['uid'=>$Find->uid,'status'=>2])->count();
				$Find->top_sum=JobsExtensionLogModel::where(['uid'=>$Find->uid,'type'=>4])->count();
				$Find->demeanor=CompanyDemeanorModel::where(['cid'=>$Find->id])->count();
				$Find->recommend_sum=JobsExtensionLogModel::where(['uid'=>$Find->uid,'type'=>5])->count();
				$Find->refresh_auto=JobsExtensionLogModel::where(['uid'=>$Find->uid,'type'=>7])->count();
				$Find->downloaded_resume=ResumeDownloadedModel::where(['company_id'=>$Find->id,'status'=>1])->count();
				$Find->delivery_resume=JobsDeliveryResumeModel::where(['company_id'=>$Find->id])->count();
				$Find->invite_anInterview=InviteAninterviewModel::where(['company_id'=>$Find->id])->count();
				$Find->coupon_sum=CouponListModel::where(['uid'=>$Find->uid,'status'=>1])->count();
				$Find->expiry_coupon_sum=CouponListModel::where(['uid'=>$Find->uid,'status'=>-1])->count();
				$Find->use_coupon_sum=CouponListModel::where(['uid'=>$Find->uid,'status'=>2])->count();
				$Find->give_coupon_sum=CouponListModel::where(['uid'=>$Find->uid])->whereNotNull('admin_uid')->count();
				$Find->rights=UserVipModel::where(['uid'=>$Find->uid])->find();
	    		return $this->ajaxReturn('',0,$Find);
    		}else{
	    		return $this->ajaxReturn('该企业不存在',-100);
    		}
    	}else{
			$Field=[
				'resume.id,resume.uid,resume.name as title,resume.adviser_id',
				'user_info.nickname,user_info.headimg,user_info.score,user_info.is_real_name',
				'user.mobile,user.email',
				'user_timer.login_ip',
				'user_vip.personal_vip_time,user_vip.personal_vip_level,user_vip.download_resume',
				'personal_vip.title as personal_vip'
			];
    		$Find=ResumeModel::alias('resume')
    			->where(['resume.id'=>$G['id']])
                ->join('user user','user.id = resume.uid')
                ->join('user_info user_info','user_info.uid = user.id','LEFT')
                ->join('user_timer user_timer','user_timer.uid = user.id','LEFT')
				->join('user_vip user_vip','user_vip.uid=user.id','LEFT')
				->join('vip personal_vip','personal_vip.level=user_vip.personal_vip_level AND personal_vip.is_company=0','LEFT')
				->field(implode(',',$Field))->find();
    		if($Find){
                $Find->nickname=$Find->nickname?base64_decode($Find->nickname):'';
                $Find->headimg=$Find->headimg?config('web.imgurl').$Find->headimg:'';
	            if($Find->adviser_id){
		            $Find->adviser=AdminModel::where(['id'=>$Find->adviser_id])->field('nickname,headimg')->withAttr('headimg',function($v,$data){
		                return $v?config('web.imgurl').$v:$v;
		            })->find();
	            }else{
		            $Find->adviser=AdminModel::where(['adviser_default'=>1])->field('nickname,headimg')->withAttr('headimg',function($v,$data){
		                return $v?config('web.imgurl').$v:$v;
		            })->find();
	            }
				if($Find->personal_vip_level&&$Find->personal_vip_time>time()){
					$Find->personal_vip_time=date('Y-m-d',$Find->personal_vip_time);
				}else{
					$Find->personal_vip_time='永久';
				}
				$Find->order_sum=OrdersModel::where(['uid'=>$Find->uid])->count();
				$Find->order_finish_sum=OrdersModel::where(['uid'=>$Find->uid,'status'=>2])->count();
				$Find->delivery_resume=JobsDeliveryResumeModel::where(['resume_id'=>$Find->id])->count();
				$Find->invite_anInterview=InviteAninterviewModel::where(['resume_id'=>$Find->id])->count();
				$Find->refresh_auto=0;
				$Find->downloaded_resume=ResumeDownloadedModel::where(['resume_id'=>$Find->id,'status'=>1])->count();
				$Find->works=ResumeWorksModel::where(['resume_id'=>$Find->id])->count();
				$Find->coupon_sum=CouponListModel::where(['uid'=>$Find->uid,'status'=>1])->count();
				$Find->expiry_coupon_sum=CouponListModel::where(['uid'=>$Find->uid,'status'=>-1])->count();
				$Find->use_coupon_sum=CouponListModel::where(['uid'=>$Find->uid,'status'=>2])->count();
				$Find->give_coupon_sum=CouponListModel::where(['uid'=>$Find->uid])->whereNotNull('admin_uid')->count();
				$Find->rights=UserVipModel::where(['uid'=>$Find->uid])->find();
	    		return $this->ajaxReturn('',0,$Find);
    		}else{
	    		return $this->ajaxReturn('该简历不存在',-100);
    		}
    	}
    }
    public function getExtension()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['key']) {
                switch($G['search_type']){
                    case 'uid':
                        $where[]=['e.uid','=',$G['key']];
                        break;
                    case 'jobs_id':
                        $where[]=['e.jobs_id','=',$G['key']];
                        break;
                }
            }
            $Data=JobsExtensionLogModel::alias('e')->where($where)
            	->where(['type.alias'=>'vip/value_added_type'])
                ->join('jobs jobs','jobs.id = e.jobs_id')
                ->join('status_alias type','type.value = e.type')
                ->field('e.*,jobs.title as jobs_name,type.title as type,type.type as unit')
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                    $v['start_time']=$v['start_time']?date('Y-m-d H:i:s',$v['start_time']):'';
                    $v['end_time']=$v['end_time']?date('Y-m-d H:i:s',$v['end_time']):'';
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            return View::fetch();
        }
    }
}
