<?php
namespace app\bsadmin\controller;
use think\facade\Session;
use think\facade\Cache;
use think\facade\View;
use think\facade\Validate;
use think\helper\Str;
use app\bsadmin\model\Auth as AuthModel;
use app\bsadmin\model\Role as RoleModel;
use app\bsadmin\model\Admin as AdminModel;
use app\bsadmin\model\AdminLoginLog as AdminLoginLogModel;
use app\bsadmin\model\AdminLog as AdminLogModel;
class Admin extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $G=request()->get();
            $where=[];
            if ($G['rid']) {
                $where[]=['admin.role_id','=',$G['rid']];
            }
            if ($G['nickname']) {
                $where[]=['admin.nickname','like','%'.$G['nickname'].'%'];
            }
            if ($G['username']) {
                $where[]=['admin.username','like','%'.$G['username'].'%'];
            }
            if ($G['status']!='all') {
                $where[]=['admin.status','=',$G['status']];
            }
            $Data=AdminModel::alias('admin')->where($where)
                ->join('role role','role.rid = admin.role_id')
                ->field('admin.*,role.title')
                ->order('id desc')->paginate($G['pageSize'])->each(function($v){
                    $v['allow_week']=explode(",", $v['allow_week']);
                    $v['login_time']=$v['login_time']?date('Y-m-d H:i:s',$v['login_time']):'';
                    return $v;
                });
            if ($Data->items()) {
                return $this->ajaxReturn('',0,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }else{
            View::assign('role',RoleModel::getCateList());
            return View::fetch();
        }
    }
    public function addAdmin()
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'role_id'           => 'require',
                'nickname'          => 'require|max:30',
                'username'          => 'require|length:6,25|unique:admin',
                'password'          => 'require|length:6,25',
                'allow_time_start'  => 'require',
                'allow_time_end'    => 'require|gt:allow_time_start',
                'allow_week'        => 'require|array',
            ];
            $msg  =   [
                'role_id.require'           => '请选择角色', 
                'nickname.require'          => '请输入昵称', 
                'nickname.max'              => '昵称不能超过30个字符', 
                'username.require'          => '用户名不能为空',
                'username.unique'           => '该管理员已存在',
                'username.length'           => '用户名长度应在6~25位之间',
                'password.require'          => '密码不能为空',
                'password.length'           => '密码长度应在6~25位之间',
                'allow_time_start.require'  => '请输入允许开始时间',
                'allow_time_end.require'    => '请输入允许结束时间',
                'allow_time_end.gt'         => '结束时间需大于开始时间',
                'allow_week.require'        => '请选择工作日',
                'allow_week.array'          => '工作日不合法',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $passHash=Str::random(4);
            $adminModel=new AdminModel;
            $adminModel->headimg        = $D['headimg'];
            $adminModel->nickname       = $D['nickname'];
            $adminModel->username       = $D['username'];
            $adminModel->password       = AdminModel::getAdminPassword($passHash,$D['password']);
            $adminModel->password_hash  = $passHash;
            $adminModel->status         = $D['status'];
            $adminModel->mobile         = $D['mobile'];
            $adminModel->email          = $D['email'];
            $adminModel->other_contact  = $D['other_contact'];
            $adminModel->other_img      = $D['other_img'];
            $adminModel->adviser_default= $D['adviser_default'];
            $adminModel->role_id        = $D['role_id'];
            $adminModel->allow_time_start= $D['allow_time_start'];
            $adminModel->allow_time_end = $D['allow_time_end'];
            if($D['openid'])
            $adminModel->openid         = $D['openid'];
            $adminModel->allow_week     = implode(',', $D['allow_week']);
            if($adminModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-100);
            }
        }else{
            View::assign('role',RoleModel::getCateList());
            return View::fetch();
        }
    }
    public function editAdmin($id)
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'role_id'           => 'require',
                'nickname'          => 'require|max:30',
                'username'          => 'require|unique:admin|length:6,25',
                'password'          => 'length:6,25',
                'allow_time_start'  => 'require',
                'allow_time_end'    => 'require|gt:allow_time_start',
                'allow_week'        => 'require|array',
            ];
            $msg  =   [
                'role_id.require'           => '请选择角色', 
                'nickname.require'          => '请输入昵称', 
                'nickname.max'              => '昵称不能超过30个字符', 
                'username.require'          => '用户名不能为空',
                'username.unique'           => '该管理员已存在',
                'username.length'           => '用户名长度应在6~25位之间',
                'password.length'           => '密码长度应在6~25位之间',
                'allow_time_start.require'  => '请输入允许开始时间',
                'allow_time_end.require'    => '请输入允许结束时间',
                'allow_time_end.gt'         => '结束时间需大于开始时间',
                'allow_week.require'        => '请选择工作日',
                'allow_week.array'          => '工作日不合法',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $passHash=Str::random(4);
            $adminModel=AdminModel::where(['id'=>$id])->find();
            $adminModel->nickname       = $D['nickname'];
            $adminModel->headimg        = $D['headimg'];
            $adminModel->username       = $D['username'];
            if (!empty($D['password'])) {
                $adminModel->password       = AdminModel::getAdminPassword($passHash,$D['password']);
                $adminModel->password_hash  = $passHash;
            }
            $adminModel->status         = $D['status'];
            $adminModel->mobile         = $D['mobile'];
            $adminModel->email          = $D['email'];
            $adminModel->other_contact  = $D['other_contact'];
            $adminModel->other_img      = $D['other_img'];
            $adminModel->adviser_default= $D['adviser_default'];
            $adminModel->role_id        = $D['role_id'];
            $adminModel->allow_time_start= $D['allow_time_start'];
            $adminModel->allow_time_end = $D['allow_time_end'];
            $adminModel->allow_week     = implode(',', $D['allow_week']);
            if($D['openid']){
                $adminModel->openid         = $D['openid'];
            }else{
                $adminModel->openid         = null;
            }
            if($adminModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-100);
            }
        }else{
            View::assign('role',RoleModel::getCateList());
            $Find=AdminModel::editAdmin(['id'=>$id]);
            if ($Find) {
                View::assign('Find',$Find);
            }
            return View::fetch('add_admin');
        }
    }
    public function editMy()
    {
        if (request()->isAjax()) {
            $D=request()->post();
            $rule =   [
                'role_id'           => 'require',
                'nickname'          => 'require|max:30',
                'username'          => 'require|unique:admin|length:6,25',
                'password'          => 'length:6,25',
                'allow_time_start'  => 'require',
                'allow_time_end'    => 'require|gt:allow_time_start',
                'allow_week'        => 'require|array',
            ];
            $msg  =   [
                'role_id.require'           => '请选择角色', 
                'nickname.require'          => '请输入昵称', 
                'nickname.max'              => '昵称不能超过30个字符',
                'username.require'          => '用户名不能为空',
                'username.unique'           => '该管理员已存在',
                'username.length'           => '用户名长度应在6~25位之间', 
                'password.length'           => '密码长度应在6~25位之间',
                'allow_time_start.require'  => '请输入允许开始时间',
                'allow_time_end.require'    => '请输入允许结束时间',
                'allow_time_end.gt'         => '结束时间需大于开始时间',
                'allow_week.require'        => '请选择工作日',
                'allow_week.array'          => '工作日不合法',
            ];
            $Validate=Validate::rule($rule)->message($msg);
            $result = $Validate->check($D);
            if(!$result){return $this->ajaxReturn($Validate->getError(),-100);}
            $passHash=Str::random(4);
            $adminModel=AdminModel::where(['id'=>Session::get('AdminUser.uid')])->find();
            $adminModel->nickname       = $D['nickname'];
            $adminModel->headimg        = $D['headimg'];
            $adminModel->username       = $D['username'];
            if (!empty($D['password'])) {
                $adminModel->password       = AdminModel::getAdminPassword($passHash,$D['password']);
                $adminModel->password_hash  = $passHash;
            }
            $adminModel->mobile         = $D['mobile'];
            $adminModel->email          = $D['email'];
            $adminModel->other_contact  = $D['other_contact'];
            $adminModel->other_img      = $D['other_img'];
            if($D['openid']){
                $adminModel->openid         = $D['openid'];
            }else{
                $adminModel->openid         = null;
            }
            if($adminModel->save()){
                return $this->ajaxReturn('保存成功');
            }else{
                return $this->ajaxReturn('保存失败，请重试',-100);
            }
        }else{
            $Find=AdminModel::editAdmin(['id'=>Session::get('AdminUser.uid')]);
            if ($Find) {
                View::assign('Find',$Find);
            }
            return View::fetch('my_admin');
        }
    }
    /**
     * 设置管理员状态
     */
    public function setAdminStatus($id,$status)
    {
        $adminData=AdminModel::where('id',$id)->find();
        $adminData->status=$status;
        if ($adminData->save()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('保存失败，请重试',-100);
        }
    }
    /**
     * 获取管理员日志
     */
    public function getAdminLog()
    {
        $G=request()->get();
        if($G['type'] == 'login'){
            $adminLog=AdminLoginLogModel::where(['admin_id'=>$G['id']])->order('id desc')->paginate(10);
            if($adminLog->items()){
                return $this->ajaxReturn('success',0,$adminLog);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }elseif($G['type'] == 'log'){
            $adminLog=AdminLogModel::where(['l_uid'=>$G['id']])->order('lid desc')->paginate(10);
            if($adminLog->items()){
                return $this->ajaxReturn('success',0,$adminLog);
            }else{
                return $this->ajaxReturn('暂无数据~',-100);
            }
        }
    }
    public function adminNotice()
    {
        $TypeList=['pay', 'resume_examine', 'jobs_examine', 'real_name', 'company_attestation', 'report_resume', 'report_jobs', 'feedback'];
        if(request()->isPost()){
            $D=request()->post();
            $Data=[];
            foreach ($TypeList as $key => $value) {
                $Data[$value]=empty($D[$value])?[]:$D[$value];
            }
            Cache::set('AdminNotice',$Data);
            return $this->ajaxReturn('保存成功');
        }else{
            $Find=Cache::get('AdminNotice');
            if ($Find) {
                foreach ($TypeList as $key => $value) {
                    $Find[$value]=empty($Find[$value])?[]:arrtoint($Find[$value]);
                }
                View::assign('Find',$Find);
            }
            $AdminModel=AdminModel::alias('admin')->join('role role','role.rid=admin.role_id')->field('admin.id,admin.nickname,role.title')->select();
            View::assign('admin',$AdminModel);
            return View::fetch();
        }
    }
}









